/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.math.filters.IntegratorBiasCompensatorYoVariable;
import us.ihmc.robotics.math.filters.ProcessingYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class IntegratorBiasCompensatorYoFrameVector3D
extends YoFrameVector3D
implements ProcessingYoVariable {
    private final double dt;
    private final DoubleProvider kp;
    private final DoubleProvider ki;
    private final FrameTuple3DReadOnly rawPosition;
    private final FrameTuple3DReadOnly rawRate;
    private final YoFrameVector3D error;
    private final YoFrameVector3D estimatedRate;
    private final YoFrameVector3D estimatedRateBias;
    private final YoBoolean hasBeenCalled;
    private final Vector3D xd_filt = new Vector3D();
    private final Vector3D x_pred = new Vector3D();
    private final FrameVector3D intermediateBias = new FrameVector3D();

    public IntegratorBiasCompensatorYoFrameVector3D(String name, YoRegistry registry, double kp, double ki, FrameTuple3DReadOnly rawPosition, FrameTuple3DReadOnly rawRate, double dt) {
        this(name, registry, kp, ki, rawPosition, rawRate, rawPosition.getReferenceFrame(), dt);
    }

    public IntegratorBiasCompensatorYoFrameVector3D(String name, YoRegistry registry, double kp, double ki, FrameTuple3DReadOnly rawPosition, FrameTuple3DReadOnly rawRate, ReferenceFrame biasEstimationFrame, double dt) {
        this(name, registry, IntegratorBiasCompensatorYoVariable.createKpYoDouble(name, kp, registry), IntegratorBiasCompensatorYoVariable.createKiYoDouble(name, ki, registry), rawPosition, rawRate, biasEstimationFrame, dt);
    }

    public IntegratorBiasCompensatorYoFrameVector3D(String name, YoRegistry registry, DoubleProvider kp, DoubleProvider ki, ReferenceFrame referenceFrame, double dt) {
        this(name, registry, kp, ki, referenceFrame, referenceFrame, dt);
    }

    public IntegratorBiasCompensatorYoFrameVector3D(String name, YoRegistry registry, DoubleProvider kp, DoubleProvider ki, ReferenceFrame referenceFrame, ReferenceFrame biasEstimationFrame, double dt) {
        this(name, registry, kp, ki, null, null, referenceFrame, biasEstimationFrame, dt);
    }

    public IntegratorBiasCompensatorYoFrameVector3D(String name, YoRegistry registry, DoubleProvider kp, DoubleProvider ki, FrameTuple3DReadOnly rawPosition, FrameTuple3DReadOnly rawRate, double dt) {
        this(name, registry, kp, ki, rawPosition, rawRate, rawPosition.getReferenceFrame(), dt);
    }

    public IntegratorBiasCompensatorYoFrameVector3D(String name, YoRegistry registry, DoubleProvider kp, DoubleProvider ki, FrameTuple3DReadOnly rawPosition, FrameTuple3DReadOnly rawRate, ReferenceFrame biasEstimationFrame, double dt) {
        this(name, registry, kp, ki, rawPosition, rawRate, rawPosition.getReferenceFrame(), biasEstimationFrame, dt);
    }

    private IntegratorBiasCompensatorYoFrameVector3D(String name, YoRegistry registry, DoubleProvider kp, DoubleProvider ki, FrameTuple3DReadOnly rawPosition, FrameTuple3DReadOnly rawRate, ReferenceFrame referenceFrame, ReferenceFrame biasEstimationFrame, double dt) {
        super(name, referenceFrame, registry);
        if (rawPosition != null && rawRate != null) {
            rawPosition.checkReferenceFrameMatch((ReferenceFrameHolder)rawRate);
        }
        this.kp = kp;
        this.ki = ki;
        this.dt = dt;
        this.rawPosition = rawPosition;
        this.rawRate = rawRate;
        this.error = new YoFrameVector3D(name + "PositionError", referenceFrame, registry);
        this.estimatedRate = new YoFrameVector3D(name + "EstimatedRate", referenceFrame, registry);
        this.estimatedRateBias = new YoFrameVector3D(name + "EstimatedRateBias", biasEstimationFrame, registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.reset();
    }

    @Override
    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public YoFrameVector3D getPositionEstimation() {
        return this;
    }

    public YoFrameVector3D getRateEstimation() {
        return this.estimatedRate;
    }

    public YoFrameVector3D getBiasEstimation() {
        return this.estimatedRateBias;
    }

    @Override
    public void update() {
        this.update(this.rawPosition, this.rawRate);
    }

    public void update(FrameTuple3DReadOnly rawPosition, FrameTuple3DReadOnly rawRate) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)rawPosition, (ReferenceFrameHolder)rawRate);
        this.update((Tuple3DReadOnly)rawPosition, (Tuple3DReadOnly)rawRate);
    }

    public void update(Tuple3DReadOnly rawPosition, Tuple3DReadOnly rawRate) {
        if (!this.hasBeenCalled.getBooleanValue()) {
            this.hasBeenCalled.set(true);
            this.set(rawPosition);
            this.estimatedRate.set(rawRate);
            this.error.setToZero();
            this.estimatedRateBias.setToZero();
            return;
        }
        this.intermediateBias.setIncludingFrame((FrameTuple3DReadOnly)this.estimatedRateBias);
        this.intermediateBias.changeFrame(this.getReferenceFrame());
        IntegratorBiasCompensatorYoFrameVector3D x_filt = this;
        this.xd_filt.add(rawRate, (Tuple3DReadOnly)this.intermediateBias);
        this.xd_filt.interpolate((Tuple3DReadOnly)this.estimatedRate, 0.5);
        this.x_pred.scaleAdd(this.dt, (Tuple3DReadOnly)this.xd_filt, (Tuple3DReadOnly)x_filt);
        this.error.sub(rawPosition, (Tuple3DReadOnly)this.x_pred);
        x_filt.scaleAdd(this.kp.getValue(), (Tuple3DReadOnly)this.error, (Tuple3DReadOnly)this.x_pred);
        this.intermediateBias.scaleAdd(this.ki.getValue(), (FrameTuple3DReadOnly)this.error, (FrameTuple3DReadOnly)this.intermediateBias);
        this.estimatedRate.add(rawRate, (FrameTuple3DReadOnly)this.intermediateBias);
        this.estimatedRateBias.setMatchingFrame((FrameTuple3DReadOnly)this.intermediateBias);
    }
}

