/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ButterworthFilteredYoVariable
extends YoDouble {
    private final DoubleProvider alphaVariable;
    private final ButterworthFilterType butterworthFilterType;
    private final DoubleProvider position;
    private final YoDouble previousInput;
    private final YoBoolean hasBeenCalled;

    public ButterworthFilteredYoVariable(String name, YoRegistry registry, double alpha, ButterworthFilterType butterworthFilterType) {
        this(name, registry, AlphaFilteredYoVariable.createAlphaYoDouble(name, alpha, registry), butterworthFilterType);
    }

    public ButterworthFilteredYoVariable(String name, YoRegistry registry, double alpha, DoubleProvider positionVariable, ButterworthFilterType butterworthFilterType) {
        this(name, registry, AlphaFilteredYoVariable.createAlphaYoDouble(name, alpha, registry), positionVariable, butterworthFilterType);
    }

    public ButterworthFilteredYoVariable(String name, YoRegistry registry, DoubleProvider alphaVariable, ButterworthFilterType butterworthFilterType) {
        this(name, registry, alphaVariable, null, butterworthFilterType);
    }

    public ButterworthFilteredYoVariable(String name, YoRegistry registry, DoubleProvider alphaVariable, DoubleProvider positionVariable, ButterworthFilterType butterworthFilterType) {
        super(name, registry);
        this.alphaVariable = alphaVariable;
        this.butterworthFilterType = butterworthFilterType;
        this.position = positionVariable;
        this.previousInput = new YoDouble(name + "_prevIn", registry);
        this.hasBeenCalled = new YoBoolean(name + "HasBeenCalled", registry);
        this.reset();
    }

    public void reset() {
        this.hasBeenCalled.set(false);
    }

    public void update() {
        if (this.position == null) {
            throw new NullPointerException(((Object)((Object)this)).getClass().getSimpleName() + " must be constructed with a non null position variable to call update(), otherwise use update(double)");
        }
        this.update(this.position.getValue());
    }

    public void update(double currentInput) {
        if (!this.hasBeenCalled.getValue()) {
            this.hasBeenCalled.set(true);
            if (this.butterworthFilterType == ButterworthFilterType.HIGH_PASS) {
                this.set(0.0);
            } else {
                this.set(currentInput);
            }
        } else {
            double alpha = this.alphaVariable.getValue();
            switch (this.butterworthFilterType) {
                case LOW_PASS: {
                    this.set(alpha * this.getValue() + 0.5 * (1.0 - alpha) * (currentInput + this.previousInput.getValue()));
                    break;
                }
                case HIGH_PASS: {
                    this.set(alpha * this.getValue() + 0.5 * (1.0 + alpha) * (currentInput - this.previousInput.getValue()));
                }
            }
        }
        this.previousInput.set(currentInput);
    }

    public static double computeAlphaGivenBreakFrequency(double breakFrequencyInHertz, double dt) {
        if (Double.isInfinite(breakFrequencyInHertz)) {
            return 0.0;
        }
        double samplingFrequency = 1.0 / dt;
        if (breakFrequencyInHertz > 0.25 * samplingFrequency) {
            return 0.0;
        }
        double tanOmegaBreak = Math.tan(Math.PI * breakFrequencyInHertz * dt);
        return MathTools.clamp((double)((1.0 - tanOmegaBreak) / (1.0 + tanOmegaBreak)), (double)0.0, (double)1.0);
    }

    public static double computeBreakFrequencyGivenAlpha(double alpha, double dt) {
        double beta = (1.0 - alpha) / (1.0 + alpha);
        return Math.max(Math.atan(beta) / (dt * Math.PI), 0.0);
    }

    public static enum ButterworthFilterType {
        LOW_PASS,
        HIGH_PASS;

    }
}

