/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.robotics.math.filters.BetaFilteredYoVariable;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.tools.YoGeometryNameTools;
import us.ihmc.yoVariables.variable.YoDouble;

public class BetaFilteredYoFramePoint2d
extends YoFramePoint2D {
    private final BetaFilteredYoVariable x;
    private final BetaFilteredYoVariable y;

    private BetaFilteredYoFramePoint2d(BetaFilteredYoVariable x, BetaFilteredYoVariable y, ReferenceFrame referenceFrame) {
        super((YoDouble)x, (YoDouble)y, referenceFrame);
        this.x = x;
        this.y = y;
    }

    public static BetaFilteredYoFramePoint2d createBetaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, int beta, ReferenceFrame referenceFrame) {
        BetaFilteredYoVariable x = new BetaFilteredYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, beta);
        BetaFilteredYoVariable y = new BetaFilteredYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, beta);
        BetaFilteredYoFramePoint2d ret = new BetaFilteredYoFramePoint2d(x, y, referenceFrame);
        return ret;
    }

    public static BetaFilteredYoFramePoint2d createBetaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, String description, YoRegistry registry, int beta, ReferenceFrame referenceFrame) {
        BetaFilteredYoVariable x = new BetaFilteredYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), description, registry, beta);
        BetaFilteredYoVariable y = new BetaFilteredYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), description, registry, beta);
        BetaFilteredYoFramePoint2d ret = new BetaFilteredYoFramePoint2d(x, y, referenceFrame);
        return ret;
    }

    public static BetaFilteredYoFramePoint2d createBetaFilteredYoFramePoint2d(String namePrefix, String nameSuffix, YoRegistry registry, int beta, YoFramePoint2D unfilteredPoint) {
        BetaFilteredYoVariable x = new BetaFilteredYoVariable(YoGeometryNameTools.createXName((String)namePrefix, (String)nameSuffix), registry, beta, unfilteredPoint.getYoX());
        BetaFilteredYoVariable y = new BetaFilteredYoVariable(YoGeometryNameTools.createYName((String)namePrefix, (String)nameSuffix), registry, beta, unfilteredPoint.getYoY());
        BetaFilteredYoFramePoint2d ret = new BetaFilteredYoFramePoint2d(x, y, unfilteredPoint.getReferenceFrame());
        return ret;
    }

    public void update() {
        this.x.update();
        this.y.update();
    }

    public void update(double xUnfiltered, double yUnfiltered) {
        this.x.update(xUnfiltered);
        this.y.update(yUnfiltered);
    }

    public void update(Point2D point2dUnfiltered) {
        this.x.update(point2dUnfiltered.getX());
        this.y.update(point2dUnfiltered.getY());
    }

    public void update(FramePoint2D point2dUnfiltered) {
        this.checkReferenceFrameMatch((ReferenceFrameHolder)point2dUnfiltered);
        this.x.update(point2dUnfiltered.getX());
        this.y.update(point2dUnfiltered.getY());
    }

    public void reset() {
        this.x.reset();
        this.y.reset();
    }
}

