/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math;

import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.kinematics.TransformInterpolationCalculator;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoReferencePose
extends ReferenceFrame {
    private final YoFramePoseUsingYawPitchRoll yoFramePose;
    private final TransformInterpolationCalculator transformInterpolationCalculator = new TransformInterpolationCalculator();
    private final RigidBodyTransform interpolationStartingPosition = new RigidBodyTransform();
    private final RigidBodyTransform interpolationGoalPosition = new RigidBodyTransform();
    private final RigidBodyTransform output = new RigidBodyTransform();
    private final Quaternion rotation = new Quaternion();
    private final Vector3D translation = new Vector3D();

    public YoReferencePose(String frameName, ReferenceFrame parentFrame, YoRegistry registry) {
        super(frameName, parentFrame);
        this.yoFramePose = new YoFramePoseUsingYawPitchRoll(frameName + "_", (ReferenceFrame)this, registry);
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.rotation.set((Orientation3DReadOnly)this.yoFramePose.getYawPitchRoll());
        transformToParent.getRotation().set((Orientation3DReadOnly)this.rotation);
        YoFramePoint3D yoFramePoint = this.yoFramePose.getPosition();
        transformToParent.getTranslation().set(yoFramePoint.getX(), yoFramePoint.getY(), yoFramePoint.getZ());
    }

    public void setAndUpdate(RigidBodyTransform transform) {
        transform.get((Orientation3DBasics)this.rotation, (Tuple3DBasics)this.translation);
        this.setAndUpdate(this.rotation, this.translation);
    }

    public void setAndUpdate(Vector3D newTranslation) {
        this.set(newTranslation);
        this.update();
    }

    public void setAndUpdate(Quaternion newRotation) {
        this.set(newRotation);
        this.update();
    }

    public void setAndUpdate(Quaternion newRotation, Vector3D newTranslation) {
        this.set(newRotation);
        this.set(newTranslation);
        this.update();
    }

    private void set(Quaternion newRotation) {
        this.yoFramePose.setOrientation((Orientation3DReadOnly)newRotation);
    }

    private void set(Vector3D newTranslation) {
        this.yoFramePose.setPosition(newTranslation.getX(), newTranslation.getY(), newTranslation.getZ());
    }

    public void interpolate(YoReferencePose start, YoReferencePose goal, double alpha) {
        start.getTransformToDesiredFrame(this.interpolationStartingPosition, this.getParent());
        goal.getTransformToDesiredFrame(this.interpolationGoalPosition, this.getParent());
        this.transformInterpolationCalculator.computeInterpolation(this.interpolationStartingPosition, this.interpolationGoalPosition, this.output, alpha);
        this.setAndUpdate(this.output);
    }

    public void get(Quaternion rotation) {
        rotation.set((QuaternionReadOnly)this.yoFramePose.getOrientation());
    }

    public void get(Vector3D translation) {
        translation.set((Tuple3DReadOnly)this.yoFramePose.getPosition());
    }
}

