/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import Jama.Matrix;
import us.ihmc.robotics.linearDynamicSystems.LinearDynamicSystem;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;

public class TransferFunctionToStateSpaceConverter {
    public static LinearDynamicSystem convertTransferFunctionToStateSpaceControllableCanonicalForm(TransferFunction transferFunction) {
        double[] numeratorCoefficients = transferFunction.getNumeratorCoefficients();
        double[] denominatorCoefficients = transferFunction.getDenominatorCoefficients();
        int systemOrder = denominatorCoefficients.length - 1;
        numeratorCoefficients = TransferFunctionToStateSpaceConverter.padZerosOnFront(numeratorCoefficients, denominatorCoefficients.length);
        double a0 = denominatorCoefficients[0];
        for (int i = 0; i < systemOrder; ++i) {
            denominatorCoefficients[i] = denominatorCoefficients[i] / a0;
        }
        double[][] elementsA = new double[systemOrder][systemOrder];
        for (int i = 0; i < systemOrder; ++i) {
            for (int j = 0; j < systemOrder; ++j) {
                elementsA[i][j] = i == systemOrder - 1 ? -denominatorCoefficients[systemOrder - j] : (j == i + 1 ? 1.0 : 0.0);
            }
        }
        double[][] elementsB = new double[systemOrder][1];
        for (int i = 0; i < systemOrder; ++i) {
            elementsB[i][0] = i == systemOrder - 1 ? 1.0 : 0.0;
        }
        double b0 = numeratorCoefficients[0];
        double[][] elementsC = new double[1][systemOrder];
        for (int i = 0; i < systemOrder; ++i) {
            elementsC[0][i] = numeratorCoefficients[systemOrder - i] - b0 * denominatorCoefficients[systemOrder - i];
        }
        double[][] elementsD = new double[1][1];
        elementsD[0][0] = b0;
        Matrix matrixA = new Matrix(elementsA);
        Matrix matrixB = new Matrix(elementsB);
        Matrix matrixC = new Matrix(elementsC);
        Matrix matrixD = new Matrix(elementsD);
        LinearDynamicSystem linearDynamicSystem = new LinearDynamicSystem(matrixA, matrixB, matrixC, matrixD);
        return linearDynamicSystem;
    }

    public static LinearDynamicSystem convertTransferFunctionToStateSpaceObservableCanonicalForm(TransferFunction transferFunction) {
        double[] numeratorCoefficients = transferFunction.getNumeratorCoefficients();
        double[] denominatorCoefficients = transferFunction.getDenominatorCoefficients();
        int systemOrder = denominatorCoefficients.length - 1;
        numeratorCoefficients = TransferFunctionToStateSpaceConverter.padZerosOnFront(numeratorCoefficients, denominatorCoefficients.length);
        double a0 = denominatorCoefficients[0];
        for (int i = 0; i < systemOrder; ++i) {
            denominatorCoefficients[i] = denominatorCoefficients[i] / a0;
        }
        double[][] elementsA = new double[systemOrder][systemOrder];
        for (int i = 0; i < systemOrder; ++i) {
            for (int j = 0; j < systemOrder; ++j) {
                elementsA[i][j] = j == i + 1 ? 1.0 : (j == 0 ? -denominatorCoefficients[i + 1] : 0.0);
            }
        }
        double[][] elementsB = new double[systemOrder][1];
        double b0 = numeratorCoefficients[0];
        for (int i = 0; i < systemOrder; ++i) {
            elementsB[i][0] = numeratorCoefficients[i + 1] - denominatorCoefficients[i + 1] * b0;
        }
        double[][] elementsC = new double[1][systemOrder];
        for (int i = 0; i < systemOrder; ++i) {
            elementsC[0][i] = i == 0 ? 1.0 : 0.0;
        }
        double[][] elementsD = new double[1][1];
        elementsD[0][0] = b0;
        Matrix matrixA = new Matrix(elementsA);
        Matrix matrixB = new Matrix(elementsB);
        Matrix matrixC = new Matrix(elementsC);
        Matrix matrixD = new Matrix(elementsD);
        LinearDynamicSystem linearDynamicSystem = new LinearDynamicSystem(matrixA, matrixB, matrixC, matrixD);
        return linearDynamicSystem;
    }

    private static double[] padZerosOnFront(double[] coefficients, int newLength) {
        double[] newCoefficients = new double[newLength];
        int numberOfPaddedZeros = newCoefficients.length - coefficients.length;
        for (int i = 0; i < newLength; ++i) {
            newCoefficients[i] = i < numberOfPaddedZeros ? 0.0 : coefficients[i - numberOfPaddedZeros];
        }
        return newCoefficients;
    }
}

