/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearDynamicSystems;

import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.matrixlib.MatrixTools;
import us.ihmc.robotics.linearAlgebra.MatrixExponentialCalculator;
import us.ihmc.robotics.linearDynamicSystems.StateSpaceSystemDiscretizer;

public class SingleMatrixExponentialStateSpaceSystemDiscretizer
implements StateSpaceSystemDiscretizer {
    private final DMatrixRMaj discretizationMatrix;
    private final MatrixExponentialCalculator matrixExponentialCalculator;
    private final DMatrixRMaj F3;
    private final DMatrixRMaj G2;
    private final DMatrixRMaj G3;
    private final DMatrixRMaj negativeATranspose;
    private final int nStates;
    private final int nInputs;

    public SingleMatrixExponentialStateSpaceSystemDiscretizer(int numberOfStates, int numberOfInputs) {
        int discretizationMatrixSize = 2 * numberOfStates + numberOfInputs;
        this.discretizationMatrix = new DMatrixRMaj(discretizationMatrixSize, discretizationMatrixSize);
        this.matrixExponentialCalculator = new MatrixExponentialCalculator(discretizationMatrixSize);
        this.F3 = new DMatrixRMaj(numberOfStates, numberOfStates);
        this.G2 = new DMatrixRMaj(numberOfStates, numberOfStates);
        this.G3 = new DMatrixRMaj(numberOfStates, numberOfInputs);
        this.negativeATranspose = new DMatrixRMaj(numberOfStates, numberOfStates);
        this.nStates = numberOfStates;
        this.nInputs = numberOfInputs;
    }

    @Override
    public void discretize(DMatrixRMaj A, DMatrixRMaj B, DMatrixRMaj Q, double dt) {
        MatrixTools.checkMatrixDimensions((DMatrix1Row)A, (int)this.nStates, (int)this.nStates);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)B, (int)this.nStates, (int)this.nInputs);
        MatrixTools.checkMatrixDimensions((DMatrix1Row)Q, (int)this.nStates, (int)this.nStates);
        CommonOps_DDRM.insert((DMatrix)A, (DMatrix)this.discretizationMatrix, (int)this.nStates, (int)this.nStates);
        CommonOps_DDRM.transpose((DMatrixRMaj)A, (DMatrixRMaj)this.negativeATranspose);
        CommonOps_DDRM.changeSign((DMatrixD1)this.negativeATranspose);
        CommonOps_DDRM.insert((DMatrix)this.negativeATranspose, (DMatrix)this.discretizationMatrix, (int)0, (int)0);
        CommonOps_DDRM.insert((DMatrix)Q, (DMatrix)this.discretizationMatrix, (int)0, (int)this.nStates);
        CommonOps_DDRM.insert((DMatrix)B, (DMatrix)this.discretizationMatrix, (int)this.nStates, (int)(2 * this.nStates));
        CommonOps_DDRM.scale((double)dt, (DMatrixD1)this.discretizationMatrix);
        this.matrixExponentialCalculator.compute(this.discretizationMatrix, this.discretizationMatrix);
        CommonOps_DDRM.extract((DMatrix)this.discretizationMatrix, (int)this.nStates, (int)(2 * this.nStates), (int)this.nStates, (int)(2 * this.nStates), (DMatrix)this.F3, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.discretizationMatrix, (int)0, (int)this.nStates, (int)this.nStates, (int)(2 * this.nStates), (DMatrix)this.G2, (int)0, (int)0);
        CommonOps_DDRM.extract((DMatrix)this.discretizationMatrix, (int)this.nStates, (int)(2 * this.nStates), (int)(2 * this.nStates), (int)(2 * this.nStates + this.nInputs), (DMatrix)this.G3, (int)0, (int)0);
        A.set((DMatrixD1)this.F3);
        CommonOps_DDRM.mult((DMatrix1Row)this.F3, (DMatrix1Row)this.G3, (DMatrix1Row)B);
        CommonOps_DDRM.multTransA((DMatrix1Row)this.F3, (DMatrix1Row)this.G2, (DMatrix1Row)Q);
    }
}

