/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra.careSolvers.signFunction;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.matrixlib.NativeCommonOps;
import us.ihmc.robotics.linearAlgebra.careSolvers.MatrixToolsLocal;
import us.ihmc.robotics.linearAlgebra.careSolvers.signFunction.SignFunction;

public class NewtonSignFunction
implements SignFunction {
    private static final boolean debug = false;
    private int maxIterations = Integer.MAX_VALUE;
    private double epsilon = 1.0E-12;
    private final DMatrixRMaj Wlocal = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj W = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj WInverse = new DMatrixRMaj(0, 0);
    private final DMatrixRMaj WDiff = new DMatrixRMaj(0, 0);

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public void setConvergenceEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    @Override
    public boolean compute(DMatrixRMaj K) {
        int size = K.getNumRows();
        this.Wlocal.set((DMatrixD1)K);
        this.WDiff.reshape(size, size);
        this.W.reshape(size, size);
        this.WInverse.reshape(size, size);
        boolean converged = false;
        int iterations = 0;
        while (!converged) {
            if (iterations > this.maxIterations) {
                return false;
            }
            NativeCommonOps.invert((DMatrix1Row)this.Wlocal, (DMatrix1Row)this.WInverse);
            CommonOps_DDRM.subtract((DMatrixD1)this.Wlocal, (DMatrixD1)this.WInverse, (DMatrixD1)this.WDiff);
            CommonOps_DDRM.add((DMatrixD1)this.Wlocal, (double)-0.5, (DMatrixD1)this.WDiff, (DMatrixD1)this.W);
            converged = MatrixToolsLocal.distance(this.W, this.Wlocal) < this.epsilon;
            this.Wlocal.set((DMatrixD1)this.W);
            ++iterations;
        }
        return true;
    }

    private static void checkProperInversion(DMatrixRMaj A, DMatrixRMaj Ainv) {
        int n = A.getNumRows();
        DMatrixRMaj expectedIdentify = new DMatrixRMaj(n, n);
        CommonOps_DDRM.mult((DMatrix1Row)Ainv, (DMatrix1Row)A, (DMatrix1Row)expectedIdentify);
        for (int row = 0; row < n; ++row) {
            for (int col = 0; col < n; ++col) {
                if (row == col && !MathTools.epsilonEquals((double)1.0, (double)expectedIdentify.get(row, col), (double)1.0E-7)) {
                    throw new RuntimeException("Wrong inversion. Identity property should be held at 1, was " + expectedIdentify.get(row, col));
                }
                if (row == col || MathTools.epsilonEquals((double)0.0, (double)expectedIdentify.get(row, col), (double)1.0E-7)) continue;
                throw new RuntimeException("Wrong inversion. Off-diagonal property should be held at 0, was " + expectedIdentify.get(row, col));
            }
        }
    }

    @Override
    public DMatrixRMaj getW(DMatrixRMaj WToPack) {
        if (WToPack != null) {
            WToPack.set((DMatrixD1)this.W);
            return null;
        }
        return new DMatrixRMaj(this.W);
    }
}

