/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import Jama.Matrix;

public class MatrixStatistics {
    public static int[] indecesOfMaxElement(Matrix m) {
        int[] ret = new int[2];
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                if (!(m.get(i, j) > max)) continue;
                max = m.get(i, j);
                ret[0] = i;
                ret[1] = j;
            }
        }
        return ret;
    }

    public static Matrix getCovarianceMatrix(Matrix m) {
        int N = m.getColumnDimension();
        Matrix ret = MatrixStatistics.subtractAverageColumnFromEachRow(m);
        ret = ret.times(ret.transpose());
        ret = ret.times(1.0 / (double)N);
        return ret;
    }

    public static Matrix subtractAverageColumnFromEachRow(Matrix m) {
        Matrix u = MatrixStatistics.getAverageColumnVector(m);
        Matrix h = MatrixStatistics.createRowVector(m.getColumnDimension(), 1.0);
        Matrix ret = m.copy();
        return ret.minus(u.times(h));
    }

    public static double sumAllElements(Matrix m) {
        final DoubleWrapper ret = new DoubleWrapper();
        MatrixStatistics.forEachElement(m, new ElementHandler(){

            @Override
            public void handleElement(double value, int rowNumber, int columnNumber) {
                ret.val += value;
            }
        });
        return ret.val;
    }

    public static Matrix divideEachRowByStdDevOfRow(Matrix m) {
        final Matrix variance = MatrixStatistics.getVarianceOfEachRow(m);
        final Matrix ret = m.copy();
        MatrixStatistics.forEachElement(ret, new ElementHandler(){

            @Override
            public void handleElement(double value, int rowNumber, int columnNumber) {
                ret.set(rowNumber, columnNumber, value / Math.sqrt(variance.get(rowNumber, 0)));
            }
        });
        return ret;
    }

    public static Matrix getVarianceOfEachRow(Matrix m) {
        final Matrix ret = MatrixStatistics.createColumnVector(m.getRowDimension());
        final Matrix mean = MatrixStatistics.getAverageColumnVector(m);
        MatrixStatistics.forEachRow(m, new RowHandler(){

            @Override
            public void handleRow(Matrix row, final int rowNumber) {
                final DoubleWrapper total = new DoubleWrapper();
                MatrixStatistics.forEachColumn(row, new ColumnHandler(){

                    @Override
                    public void handleColumn(Matrix column, int columnNumber) {
                        total.val += (column.get(0, 0) - mean.get(rowNumber, 0)) * (column.get(0, 0) - mean.get(rowNumber, 0));
                    }
                });
                double var = total.val / (double)row.getColumnDimension();
                ret.set(rowNumber, 0, var);
            }
        });
        return ret;
    }

    public static Matrix getAverageColumnVector(Matrix m) {
        final Matrix ret = MatrixStatistics.createColumnVector(m.getRowDimension());
        MatrixStatistics.forEachRow(m, new RowHandler(){

            @Override
            public void handleRow(Matrix row, int rowNumber) {
                final DoubleWrapper total = new DoubleWrapper();
                MatrixStatistics.forEachColumn(row, new ColumnHandler(){

                    @Override
                    public void handleColumn(Matrix column, int columnNumber) {
                        total.val += column.get(0, 0);
                    }
                });
                ret.set(rowNumber, 0, total.val / (double)row.getColumnDimension());
            }
        });
        return ret;
    }

    public static Matrix createColumnVector(int numberOfRows, double initialVal) {
        return new Matrix(numberOfRows, 1, initialVal);
    }

    public static Matrix createRowVector(int numberOfColumns, double initialVal) {
        return new Matrix(1, numberOfColumns, initialVal);
    }

    public static Matrix createColumnVector(int numberOfRows) {
        return new Matrix(numberOfRows, 1);
    }

    public static Matrix createRowVector(int numberOfColumns) {
        return new Matrix(1, numberOfColumns);
    }

    public static Matrix getRowNumber(int i, Matrix m) {
        Matrix ret = m.getMatrix(i, i, 0, m.getColumnDimension() - 1);
        return ret;
    }

    public static Matrix getColumnNumber(int i, Matrix m) {
        return m.getMatrix(0, m.getRowDimension() - 1, i, i);
    }

    public static void forEachElement(Matrix m, final ElementHandler elementHandler) {
        MatrixStatistics.forEachRow(m, new RowHandler(){

            @Override
            public void handleRow(Matrix row, final int rowNumber) {
                MatrixStatistics.forEachColumn(row, new ColumnHandler(){

                    @Override
                    public void handleColumn(Matrix column, int columnNumber) {
                        elementHandler.handleElement(column.get(0, 0), rowNumber, columnNumber);
                    }
                });
            }
        });
    }

    public static void forEachColumn(Matrix m, ColumnHandler columnHandler) {
        for (int i = 0; i < m.getColumnDimension(); ++i) {
            columnHandler.handleColumn(MatrixStatistics.getColumnNumber(i, m), i);
        }
    }

    public static void forEachRow(Matrix m, RowHandler rowHandler) {
        for (int i = 0; i < m.getRowDimension(); ++i) {
            rowHandler.handleRow(MatrixStatistics.getRowNumber(i, m), i);
        }
    }

    public static class DoubleWrapper {
        public double val;
    }

    public static interface ElementHandler {
        public void handleElement(double var1, int var3, int var4);
    }

    public static interface RowHandler {
        public void handleRow(Matrix var1, int var2);
    }

    public static interface ColumnHandler {
        public void handleColumn(Matrix var1, int var2);
    }
}

