/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.linearAlgebra;

import org.ejml.UtilEjml;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.factory.DecompositionFactory_DDRM;
import org.ejml.interfaces.decomposition.SingularValueDecomposition_F64;
import org.ejml.interfaces.linsol.LinearSolverDense;

public class ConfigurableSolvePseudoInverseSVD
implements LinearSolverDense<DMatrixRMaj> {
    private SingularValueDecomposition_F64<DMatrixRMaj> svd;
    private DMatrixRMaj pinv = new DMatrixRMaj(1, 1);
    private final double singularValueLimit;
    private final DMatrixRMaj V = new DMatrixRMaj(1, 1);

    public ConfigurableSolvePseudoInverseSVD(int maxRows, int maxCols, double singularValueLimit) {
        this.svd = DecompositionFactory_DDRM.svd((int)maxRows, (int)maxCols, (boolean)true, (boolean)true, (boolean)true);
        this.singularValueLimit = singularValueLimit;
    }

    public ConfigurableSolvePseudoInverseSVD() {
        this(100, 100, 100.0 * UtilEjml.EPS);
    }

    public boolean setA(DMatrixRMaj A) {
        int i;
        this.pinv.reshape(A.numCols, A.numRows, false);
        if (!this.svd.decompose((Matrix)A)) {
            return false;
        }
        DMatrixRMaj U_t = (DMatrixRMaj)this.svd.getU(null, true);
        DMatrixRMaj V_t = (DMatrixRMaj)this.svd.getV(null, true);
        this.V.reshape(V_t.getNumCols(), V_t.getNumRows());
        CommonOps_DDRM.transpose((DMatrixRMaj)V_t, (DMatrixRMaj)this.V);
        double[] S = this.svd.getSingularValues();
        int N = Math.min(A.numRows, A.numCols);
        for (i = 0; i < N; ++i) {
            double s = S[i];
            S[i] = s < this.singularValueLimit ? 0.0 : 1.0 / S[i];
        }
        for (i = 0; i < this.V.numRows; ++i) {
            int index = i * this.V.numCols;
            for (int j = 0; j < this.V.numCols; ++j) {
                int n = index++;
                this.V.data[n] = this.V.data[n] * S[j];
            }
        }
        CommonOps_DDRM.mult((DMatrix1Row)this.V, (DMatrix1Row)U_t, (DMatrix1Row)this.pinv);
        return true;
    }

    public double quality() {
        throw new IllegalArgumentException("Not supported by this solver.");
    }

    public void solve(DMatrixRMaj b, DMatrixRMaj x) {
        CommonOps_DDRM.mult((DMatrix1Row)this.pinv, (DMatrix1Row)b, (DMatrix1Row)x);
    }

    public void invert(DMatrixRMaj A_inv) {
        A_inv.set((DMatrixD1)this.pinv);
    }

    public boolean modifiesA() {
        return this.svd.inputModified();
    }

    public boolean modifiesB() {
        return false;
    }

    public SingularValueDecomposition_F64<DMatrixRMaj> getDecomposition() {
        return this.svd;
    }
}

