/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import us.ihmc.robotics.hyperCubeTree.HyperCubeLeaf;
import us.ihmc.robotics.hyperCubeTree.HyperCubeTree;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;
import us.ihmc.robotics.hyperCubeTree.RecursableHyperTreeNode;

public class SimpleLossyDoubleTree
extends HyperCubeTree<Double, Void> {
    private final double constantResolution;
    private final double eps;

    public SimpleLossyDoubleTree(OneDimensionalBounds[] bounds, double constantResolution, double eps) {
        super(bounds);
        this.constantResolution = constantResolution;
        this.eps = eps;
    }

    public double getResolution(OneDimensionalBounds[] bounds, int i) {
        return this.constantResolution;
    }

    public boolean shouldSubdivide(HyperCubeLeaf<Double> leaf1, HyperCubeLeaf<Double> leaf2) {
        double diff = leaf1.getValue() - leaf2.getValue();
        return diff > this.eps || diff < -this.eps;
    }

    @Override
    protected boolean canSplit(RecursableHyperTreeNode<Double, Void> node) {
        for (int i = 0; i < node.getDimensionality(); ++i) {
            if (!(node.getBounds(i).size() <= this.constantResolution)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected HyperCubeLeaf<Double> mergeLeaves(HyperCubeLeaf<Double> oldLeaf, HyperCubeLeaf<Double> newLeaf) {
        return newLeaf;
    }

    @Override
    protected boolean canMergeLeaves(HyperCubeLeaf<Double> firstLeaf, HyperCubeLeaf<Double> secondLeaf) {
        double diff = firstLeaf.getValue() - secondLeaf.getValue();
        return diff > this.eps || diff < -this.eps;
    }

    @Override
    public void treeCleared() {
    }
}

