/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.robotics.hyperCubeTree.DimensionalityMismatchException;
import us.ihmc.robotics.hyperCubeTree.HyperVolume;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;

public class LineSegmentSearchVolume
extends HyperVolume {
    final int dim;
    private final double[] pointA;
    private final double[] pointB;
    private final double[] scale;

    public LineSegmentSearchVolume(LineSegment3D lineSegment) {
        super(3, LineSegmentSearchVolume.computeOuterBounds(lineSegment), null, true);
        this.dim = 3;
        this.pointA = new double[this.dim];
        this.pointB = new double[this.dim];
        this.scale = new double[this.dim];
        lineSegment.getFirstEndpoint().get(this.pointA);
        lineSegment.getSecondEndpoint().get(this.pointB);
        for (int i = 0; i < this.dim; ++i) {
            this.scale[i] = 1.0 / (this.pointB[i] - this.pointA[i]);
        }
    }

    private static OneDimensionalBounds[] computeOuterBounds(LineSegment3D lineSegment) {
        double[] aVals = new double[3];
        lineSegment.getFirstEndpoint().get(aVals);
        double[] bVals = new double[3];
        lineSegment.getSecondEndpoint().get(bVals);
        OneDimensionalBounds[] ret = new OneDimensionalBounds[3];
        for (int i = 0; i < 3; ++i) {
            ret[i] = new OneDimensionalBounds(Math.min(aVals[i], bVals[i]), Math.max(aVals[i], bVals[i]));
        }
        return ret;
    }

    public LineSegmentSearchVolume(Point2D point1, Point2D point2) {
        this(new double[]{point1.getX(), point1.getY()}, new double[]{point2.getX(), point2.getY()});
    }

    public LineSegmentSearchVolume(double[] point1, double[] point2) {
        super(point1.length, LineSegmentSearchVolume.calculateBounds(point1, point2), null, true);
        this.dim = point1.length;
        this.pointA = point1;
        this.pointB = point2;
        this.scale = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            this.scale[i] = 1.0 / (this.pointB[i] - this.pointA[i]);
        }
    }

    private static OneDimensionalBounds[] calculateBounds(double[] point1, double[] point2) {
        if (point1.length != point2.length) {
            throw new DimensionalityMismatchException();
        }
        int dim = point1.length;
        OneDimensionalBounds[] bounds = new OneDimensionalBounds[dim];
        for (int i = 0; i < dim; ++i) {
            bounds[i] = new OneDimensionalBounds(point1[i], point2[i]);
        }
        return bounds;
    }

    @Override
    protected boolean complexBoundsIntersect(OneDimensionalBounds[] bounds) {
        OneDimensionalBounds accumulatorBounds = new OneDimensionalBounds(0.0, 1.0);
        for (int i = 0; i < this.dim; ++i) {
            OneDimensionalBounds boundaryRepresentedInLineParameterSpace = this.transformOneDimensionalBoundsToLineParameterSpace(bounds, i);
            if (null != (accumulatorBounds = accumulatorBounds.intersectionWith(boundaryRepresentedInLineParameterSpace))) continue;
            return false;
        }
        return true;
    }

    private OneDimensionalBounds transformOneDimensionalBoundsToLineParameterSpace(OneDimensionalBounds[] bounds, int i) {
        double scale = this.scale[i];
        double translation = this.pointA[i];
        if (Double.isInfinite(scale)) {
            return OneDimensionalBounds.unbounded();
        }
        return new OneDimensionalBounds((bounds[i].min() - translation) * scale, (bounds[i].max() - translation) * scale);
    }

    @Override
    protected boolean containsBoundsIfWithinOuterBounds(OneDimensionalBounds[] bounds) {
        return false;
    }

    @Override
    protected boolean containsPointIfWithinOuterBounds(double[] point) {
        return false;
    }

    @Override
    protected double[] pointWithin(OneDimensionalBounds[] bounds) {
        OneDimensionalBounds sBounds = this.sBoundsWithin(bounds);
        double sValue = sBounds.midpoint();
        double[] ret = new double[this.dim];
        for (int i = 0; i < this.dim; ++i) {
            ret[i] = this.pointA[i] * (1.0 - sValue) + this.pointB[i] * sValue;
        }
        return ret;
    }

    private OneDimensionalBounds sBoundsWithin(OneDimensionalBounds[] bounds) {
        OneDimensionalBounds accumulatorBounds = new OneDimensionalBounds(0.0, 1.0);
        for (int i = 0; i < this.dim; ++i) {
            OneDimensionalBounds boundaryRepresentedInLineParameterSpace = this.transformOneDimensionalBoundsToLineParameterSpace(bounds, i);
            if (null != (accumulatorBounds = accumulatorBounds.intersectionWith(boundaryRepresentedInLineParameterSpace))) continue;
            return null;
        }
        return accumulatorBounds;
    }
}

