/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.hyperCubeTree;

import us.ihmc.robotics.hyperCubeTree.DimensionalityMismatchException;
import us.ihmc.robotics.hyperCubeTree.OneDimensionalBounds;

public abstract class HyperVolume {
    private final int dimensionality;
    private final OneDimensionalBounds[] outerBounds;
    private final OneDimensionalBounds[] innerBounds;
    private final boolean hasOuterBounds;
    private final boolean hasInnerBounds;

    public HyperVolume(int dimensionality, OneDimensionalBounds[] outerBounds, OneDimensionalBounds[] innerBounds, boolean hasFunction) {
        this.dimensionality = dimensionality;
        this.hasOuterBounds = outerBounds != null;
        this.outerBounds = outerBounds;
        this.hasInnerBounds = innerBounds != null;
        this.innerBounds = innerBounds;
        if (this.hasOuterBounds) {
            this.testArrayDimensionality(outerBounds);
        }
        if (this.hasInnerBounds) {
            this.testArrayDimensionality(innerBounds);
        }
    }

    public boolean outerBoundsIntersect(OneDimensionalBounds[] bounds) {
        if (this.hasOuterBounds) {
            this.testArrayDimensionality(bounds);
            for (int i = 0; i < this.dimensionality; ++i) {
                if (bounds[i].intersects(this.outerBounds[i])) continue;
                return false;
            }
        }
        return true;
    }

    public boolean includedWithinInnerBounds(OneDimensionalBounds[] bounds) {
        if (this.hasInnerBounds) {
            OneDimensionalBounds[] innerBounds2 = this.innerBounds;
            int dimensionality2 = this.dimensionality;
            this.testArrayDimensionality(bounds);
            for (int i = 0; i < dimensionality2; ++i) {
                if (innerBounds2[i].isSupersetOf(bounds[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void testArrayDimensionality(OneDimensionalBounds[] bounds) {
        if (bounds.length != this.dimensionality) {
            throw new DimensionalityMismatchException();
        }
    }

    protected abstract boolean complexBoundsIntersect(OneDimensionalBounds[] var1);

    protected abstract double[] pointWithin(OneDimensionalBounds[] var1);

    protected abstract boolean containsBoundsIfWithinOuterBounds(OneDimensionalBounds[] var1);

    protected abstract boolean containsPointIfWithinOuterBounds(double[] var1);

    public boolean intersectsBounds(OneDimensionalBounds[] bounds) {
        if (this.outerBoundsIntersect(bounds)) {
            return this.complexBoundsIntersect(bounds);
        }
        return false;
    }

    public double[] intersectionWithBounds(OneDimensionalBounds[] bounds) {
        OneDimensionalBounds[] reducedBounds = OneDimensionalBounds.intersection(this.outerBounds, bounds);
        if (null == reducedBounds) {
            return null;
        }
        return this.pointWithin(reducedBounds);
    }
}

