/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.graphics;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Random;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.AffineTransform;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D32;
import us.ihmc.euclid.tuple3D.Vector3D32;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.GraphicsUpdatable;
import us.ihmc.graphicsDescription.MeshDataHolder;
import us.ihmc.graphicsDescription.ModifiableMeshDataHolder;
import us.ihmc.graphicsDescription.TexCoord2f;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.instructions.Graphics3DAddMeshDataInstruction;
import us.ihmc.graphicsDescription.plotting.artifact.Artifact;
import us.ihmc.graphicsDescription.yoGraphics.RemoteYoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicJob;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint2D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePose3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoGraphicPlanarRegionsList
extends YoGraphic
implements RemoteYoGraphic,
GraphicsUpdatable {
    private static final int MAX_PLANAR_REGIONS_LIST_DEQUE_SIZE = 2;
    private final YoGraphicJob yoGraphicJob;
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final Random random = new Random(165165L);
    private final TIntObjectMap<AppearanceDefinition> regionIdToAppearance = new TIntObjectHashMap();
    private final int vertexBufferSize;
    private final int meshBufferSize;
    private final YoBoolean waitForReader;
    private final YoBoolean hasReaderProcessedMesh;
    private final YoBoolean hasWriterProcessedMesh;
    private final List<YoFramePoint2D> vertexBuffer;
    private final YoInteger currentMeshIndex;
    private final YoInteger currentRegionId;
    private final YoBoolean isPlanarRegionsListComplete;
    private final YoBoolean clear;
    private final YoFramePose3D currentRegionPose;
    private final YoInteger[] planarRegionsColorBuffer;
    private final Graphics3DObject graphics3dObject;
    private final List<Graphics3DAddMeshDataInstruction> meshBuffer;
    private final RigidBodyTransform regionTransform = new RigidBodyTransform();
    private final Deque<PlanarRegionsList> planarRegionsListsDeque = new ArrayDeque<PlanarRegionsList>();

    public YoGraphicPlanarRegionsList(String name, int vertexBufferSize, int meshBufferSize, YoRegistry registry) {
        this(name, vertexBufferSize, meshBufferSize, false, -1, registry);
    }

    public YoGraphicPlanarRegionsList(String name, int vertexBufferSize, int meshBufferSize, boolean useCustomColors, int numberOfPlanarRegions, YoRegistry registry) {
        super(name);
        int i;
        this.yoGraphicJob = YoGraphicJob.WRITER;
        this.vertexBufferSize = vertexBufferSize;
        this.meshBufferSize = meshBufferSize;
        this.waitForReader = new YoBoolean(name + "WaitForReader", registry);
        this.hasReaderProcessedMesh = new YoBoolean(name + "HasReaderProcessedMesh", registry);
        this.hasWriterProcessedMesh = new YoBoolean(name + "HasWriterProcessedMesh", registry);
        this.vertexBuffer = new ArrayList<YoFramePoint2D>(vertexBufferSize);
        for (i = 0; i < vertexBufferSize; ++i) {
            YoFramePoint2D vertex = new YoFramePoint2D(name + "Vertex" + i, worldFrame, registry);
            vertex.setToNaN();
            this.vertexBuffer.add(vertex);
        }
        this.currentMeshIndex = new YoInteger(name + "CurrentMeshIndex", registry);
        this.currentRegionId = new YoInteger(name + "CurrentRegionId", registry);
        this.isPlanarRegionsListComplete = new YoBoolean(name + "IsComplete", registry);
        this.clear = new YoBoolean(name + "Clear", registry);
        this.currentRegionPose = new YoFramePose3D(name + "CurrentRegionPose", worldFrame, registry);
        this.clearYoVariables();
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        this.meshBuffer = new ArrayList<Graphics3DAddMeshDataInstruction>(meshBufferSize);
        for (int polygonIndex = 0; polygonIndex < meshBufferSize; ++polygonIndex) {
            this.meshBuffer.add(this.graphics3dObject.addMeshData(null, YoAppearance.AliceBlue()));
        }
        if (useCustomColors) {
            this.planarRegionsColorBuffer = new YoInteger[numberOfPlanarRegions];
            for (i = 0; i < numberOfPlanarRegions; ++i) {
                this.planarRegionsColorBuffer[i] = new YoInteger("customColor" + i, registry);
            }
        } else {
            this.planarRegionsColorBuffer = null;
        }
    }

    public static YoGraphicPlanarRegionsList createAsRemoteYoGraphic(String name, YoVariable[] yoVariables, double[] constants) {
        return new YoGraphicPlanarRegionsList(name, yoVariables, constants);
    }

    private YoGraphicPlanarRegionsList(String name, YoVariable[] yoVariables, double[] constants) {
        super(name);
        this.yoGraphicJob = YoGraphicJob.READER;
        this.vertexBufferSize = (int)constants[0];
        this.meshBufferSize = (int)constants[1];
        this.vertexBuffer = new ArrayList<YoFramePoint2D>(this.vertexBufferSize);
        int variableIndex = 0;
        this.waitForReader = (YoBoolean)yoVariables[variableIndex++];
        this.hasReaderProcessedMesh = (YoBoolean)yoVariables[variableIndex++];
        this.hasWriterProcessedMesh = (YoBoolean)yoVariables[variableIndex++];
        for (int vertexIndex = 0; vertexIndex < this.vertexBufferSize; ++vertexIndex) {
            YoDouble x = (YoDouble)yoVariables[variableIndex++];
            YoDouble y = (YoDouble)yoVariables[variableIndex++];
            YoFramePoint2D vertex = new YoFramePoint2D(x, y, worldFrame);
            this.vertexBuffer.add(vertex);
        }
        this.currentMeshIndex = (YoInteger)yoVariables[variableIndex++];
        this.currentRegionId = (YoInteger)yoVariables[variableIndex++];
        this.isPlanarRegionsListComplete = (YoBoolean)yoVariables[variableIndex++];
        this.clear = (YoBoolean)yoVariables[variableIndex++];
        YoDouble x = (YoDouble)yoVariables[variableIndex++];
        YoDouble y = (YoDouble)yoVariables[variableIndex++];
        YoDouble z = (YoDouble)yoVariables[variableIndex++];
        YoDouble qx = (YoDouble)yoVariables[variableIndex++];
        YoDouble qy = (YoDouble)yoVariables[variableIndex++];
        YoDouble qz = (YoDouble)yoVariables[variableIndex++];
        YoDouble qs = (YoDouble)yoVariables[variableIndex++];
        YoFramePoint3D position = new YoFramePoint3D(x, y, z, worldFrame);
        YoFrameQuaternion orientation = new YoFrameQuaternion(qx, qy, qz, qs, worldFrame);
        this.currentRegionPose = new YoFramePose3D(position, orientation);
        this.graphics3dObject = new Graphics3DObject();
        this.graphics3dObject.setChangeable(true);
        this.meshBuffer = new ArrayList<Graphics3DAddMeshDataInstruction>(this.meshBufferSize);
        for (int polygonIndex = 0; polygonIndex < this.meshBufferSize; ++polygonIndex) {
            this.meshBuffer.add(this.graphics3dObject.addMeshData(null, YoAppearance.AliceBlue()));
        }
        if (yoVariables.length > variableIndex) {
            int numberOfPlanarRegions = yoVariables.length - variableIndex;
            this.planarRegionsColorBuffer = new YoInteger[numberOfPlanarRegions];
            for (int i = 0; i < numberOfPlanarRegions; ++i) {
                this.planarRegionsColorBuffer[i] = (YoInteger)yoVariables[variableIndex++];
            }
        } else {
            this.planarRegionsColorBuffer = null;
        }
    }

    public void update() {
        switch (this.yoGraphicJob) {
            case READER: {
                this.waitForReader.set(true);
                this.hasReaderProcessedMesh.set(true);
                if (!this.clear.getBooleanValue()) break;
                for (int meshIndex = 0; meshIndex < this.meshBufferSize; ++meshIndex) {
                    this.meshBuffer.get(meshIndex).setMesh(null);
                }
                this.clear.set(false);
                return;
            }
            case WRITER: {
                this.hasWriterProcessedMesh.set(true);
                if (!this.clear.getBooleanValue()) break;
                for (int meshIndex = 0; meshIndex < this.meshBufferSize; ++meshIndex) {
                    this.meshBuffer.get(meshIndex).setMesh(null);
                }
                if (!this.waitForReader.getBooleanValue()) {
                    this.clear.set(false);
                }
                return;
            }
            default: {
                throw new RuntimeException("Unknown job: " + this.yoGraphicJob);
            }
        }
        if (this.currentMeshIndex.getIntegerValue() == -1) {
            return;
        }
        MeshDataHolder polygonMesh = this.createCurrentMesh();
        polygonMesh.setName("PlanarRegion");
        AppearanceDefinition appearance = this.getCurrentAppearance();
        Graphics3DAddMeshDataInstruction instructionToUpdate = this.meshBuffer.get(this.currentMeshIndex.getIntegerValue());
        instructionToUpdate.setMesh(polygonMesh);
        instructionToUpdate.setAppearance(appearance);
        if (this.isPlanarRegionsListComplete.getBooleanValue()) {
            for (int meshIndex = this.currentMeshIndex.getIntegerValue() + 1; meshIndex < this.meshBufferSize; ++meshIndex) {
                this.meshBuffer.get(meshIndex).setMesh(null);
            }
        }
    }

    private AppearanceDefinition getCurrentAppearance() {
        AppearanceDefinition appearance;
        if (this.planarRegionsColorBuffer != null) {
            int requestedColorRGB = this.planarRegionsColorBuffer[this.currentMeshIndex.getIntegerValue()].getIntegerValue();
            appearance = YoAppearance.RGBColorFromHex((int)requestedColorRGB);
        } else if (this.regionIdToAppearance.containsKey(this.currentRegionId.getIntegerValue())) {
            appearance = (AppearanceDefinition)this.regionIdToAppearance.get(this.currentRegionId.getIntegerValue());
        } else {
            appearance = YoAppearance.randomColor((Random)this.random);
            this.regionIdToAppearance.put(this.currentRegionId.getIntegerValue(), (Object)appearance);
        }
        return appearance;
    }

    private MeshDataHolder createCurrentMesh() {
        ModifiableMeshDataHolder modifiableMeshDataHolder = new ModifiableMeshDataHolder();
        int firstVertexIndex = 0;
        boolean isDoneExtractingPolygons = false;
        while (!isDoneExtractingPolygons) {
            int numberOfVertices = this.findPolygonSize(firstVertexIndex);
            modifiableMeshDataHolder.add(this.createPolygonMesh(firstVertexIndex, numberOfVertices), true);
            if ((firstVertexIndex += numberOfVertices + 1) >= this.vertexBufferSize) {
                isDoneExtractingPolygons = true;
                continue;
            }
            isDoneExtractingPolygons = this.vertexBuffer.get(firstVertexIndex).containsNaN();
        }
        return modifiableMeshDataHolder.createMeshDataHolder();
    }

    private MeshDataHolder createPolygonMesh(int indexInVertexBuffer, int numberOfVertices) {
        int vertexIndex;
        if (numberOfVertices <= 0) {
            return null;
        }
        int numberOfTriangles = numberOfVertices - 2;
        if (numberOfTriangles <= 0) {
            return null;
        }
        Point3D32[] vertices = new Point3D32[numberOfVertices];
        TexCoord2f[] texturePoints = new TexCoord2f[numberOfVertices];
        Vector3D32[] vertexNormals = new Vector3D32[numberOfVertices];
        RigidBodyTransform transform = new RigidBodyTransform();
        this.currentRegionPose.get((RigidBodyTransformBasics)transform);
        for (vertexIndex = 0; vertexIndex < numberOfVertices; ++vertexIndex) {
            Point3D32 vertex = new Point3D32();
            vertex.set((Tuple2DReadOnly)this.vertexBuffer.get(vertexIndex + indexInVertexBuffer));
            transform.transform((Point3DBasics)vertex);
            vertices[vertexIndex] = vertex;
        }
        for (vertexIndex = 0; vertexIndex < numberOfVertices; ++vertexIndex) {
            Vector3D32 normal = new Vector3D32();
            normal.setX((float)transform.getM02());
            normal.setY((float)transform.getM12());
            normal.setZ((float)transform.getM22());
            vertexNormals[vertexIndex] = normal;
        }
        for (vertexIndex = 0; vertexIndex < numberOfVertices; ++vertexIndex) {
            texturePoints[vertexIndex] = new TexCoord2f();
        }
        int[] triangleIndices = new int[3 * numberOfTriangles];
        int index = 0;
        int j = 2;
        while (j < numberOfVertices) {
            triangleIndices[index++] = 0;
            triangleIndices[index++] = j - 1;
            triangleIndices[index++] = j++;
        }
        return new MeshDataHolder(vertices, texturePoints, triangleIndices, vertexNormals);
    }

    private int findPolygonSize(int firstVertexIndex) {
        for (int i = firstVertexIndex; i < this.vertexBuffer.size(); ++i) {
            if (!this.vertexBuffer.get(i).containsNaN()) continue;
            return i - firstVertexIndex;
        }
        return this.vertexBuffer.size() - firstVertexIndex;
    }

    public void submitPlanarRegionsListToRender(PlanarRegionsList planarRegionsList, Color requestedColor) {
        int index;
        for (int i = 0; i < planarRegionsList.getNumberOfPlanarRegions() && (index = i + this.currentMeshIndex.getIntegerValue()) >= 0 && index < this.planarRegionsColorBuffer.length; ++i) {
            this.planarRegionsColorBuffer[index].set(requestedColor.getRGB());
        }
        this.submitPlanarRegionsListToRender(planarRegionsList);
    }

    public void submitPlanarRegionsListToRender(PlanarRegionsList planarRegionsList) {
        if (planarRegionsList == null) {
            return;
        }
        if (this.planarRegionsListsDeque.size() > 2) {
            return;
        }
        PlanarRegionsList copy = planarRegionsList.copy();
        PlanarRegionsList filteredPlanarRegionsList = this.filterEmptyRegionsAndEmptyPolygons(copy);
        if (filteredPlanarRegionsList != null) {
            this.planarRegionsListsDeque.addLast(filteredPlanarRegionsList);
        }
    }

    private PlanarRegionsList filterEmptyRegionsAndEmptyPolygons(PlanarRegionsList planarRegionsList) {
        for (int regionIndex = planarRegionsList.getNumberOfPlanarRegions() - 1; regionIndex >= 0; --regionIndex) {
            PlanarRegion planarRegion = planarRegionsList.getPlanarRegion(regionIndex);
            for (int polygonIndex = planarRegion.getNumberOfConvexPolygons() - 1; polygonIndex >= 0; --polygonIndex) {
                if (!planarRegion.getConvexPolygon(polygonIndex).isEmpty()) continue;
                planarRegion.pollConvexPolygon(polygonIndex);
            }
            if (!planarRegion.isEmpty()) continue;
            planarRegionsList.pollPlanarRegion(regionIndex);
        }
        if (planarRegionsList.isEmpty()) {
            return null;
        }
        return planarRegionsList;
    }

    public void clear() {
        this.clear.set(true);
        this.planarRegionsListsDeque.clear();
        this.clearYoVariables();
        this.update();
    }

    public void processPlanarRegionsListQueue() {
        this.processPlanarRegionsListQueue(true);
    }

    public void processPlanarRegionsListQueue(boolean callUpdate) {
        if (this.waitForReader.getBooleanValue() ? !this.hasReaderProcessedMesh.getBooleanValue() : !this.hasWriterProcessedMesh.getBooleanValue()) {
            return;
        }
        if (this.clear.getBooleanValue()) {
            return;
        }
        if (this.planarRegionsListsDeque.isEmpty()) {
            this.clearYoVariables();
            return;
        }
        int currentIndex = this.currentMeshIndex.getIntegerValue();
        if (currentIndex >= this.meshBufferSize - 1) {
            currentIndex = -1;
            this.planarRegionsListsDeque.removeFirst();
            if (this.planarRegionsListsDeque.isEmpty()) {
                this.clearYoVariables();
                return;
            }
        }
        PlanarRegionsList planarRegionsListToProcess = this.planarRegionsListsDeque.peekFirst();
        PlanarRegion planarRegionToProcess = null;
        ConvexPolygon2D polygonToProcess = null;
        while (polygonToProcess == null) {
            if (planarRegionsListToProcess == null || planarRegionsListToProcess.isEmpty()) {
                currentIndex = -1;
                this.planarRegionsListsDeque.removeFirst();
                if (this.planarRegionsListsDeque.isEmpty()) {
                    this.clearYoVariables();
                    return;
                }
                planarRegionsListToProcess = this.planarRegionsListsDeque.peekFirst();
            }
            if ((planarRegionToProcess = planarRegionsListToProcess.getLastPlanarRegion()).isEmpty()) {
                planarRegionsListToProcess.pollLastPlanarRegion();
                planarRegionToProcess = null;
                continue;
            }
            polygonToProcess = planarRegionToProcess.pollLastConvexPolygon();
            if (polygonToProcess.getNumberOfVertices() <= this.vertexBufferSize) continue;
            polygonToProcess = null;
        }
        this.currentMeshIndex.set(++currentIndex);
        planarRegionToProcess.getTransformToWorld(this.regionTransform);
        this.currentRegionPose.set((RigidBodyTransformReadOnly)this.regionTransform);
        this.currentRegionId.set(planarRegionToProcess.getRegionId());
        boolean isDonePackingPolygons = false;
        int vertexIndexOffset = 0;
        while (!isDonePackingPolygons) {
            int numberOfVertices = polygonToProcess.getNumberOfVertices();
            for (int vertexIndex = 0; vertexIndex < numberOfVertices; ++vertexIndex) {
                this.vertexBuffer.get(vertexIndex + vertexIndexOffset).set((Tuple2DReadOnly)polygonToProcess.getVertex(vertexIndex));
            }
            if ((vertexIndexOffset += numberOfVertices) >= this.vertexBufferSize) {
                isDonePackingPolygons = true;
                continue;
            }
            this.vertexBuffer.get(vertexIndexOffset).setToNaN();
            ++vertexIndexOffset;
            polygonToProcess = planarRegionToProcess.getLastConvexPolygon();
            if (polygonToProcess == null) {
                isDonePackingPolygons = true;
                continue;
            }
            if (vertexIndexOffset + polygonToProcess.getNumberOfVertices() > this.vertexBufferSize) {
                isDonePackingPolygons = true;
                continue;
            }
            polygonToProcess = planarRegionToProcess.pollLastConvexPolygon();
            isDonePackingPolygons = false;
        }
        for (int vertexIndex = vertexIndexOffset; vertexIndex < this.vertexBufferSize; ++vertexIndex) {
            this.vertexBuffer.get(vertexIndex).setToNaN();
        }
        if (planarRegionToProcess.isEmpty()) {
            planarRegionsListToProcess.pollLastPlanarRegion();
        }
        this.isPlanarRegionsListComplete.set(planarRegionsListToProcess.isEmpty());
        this.hasReaderProcessedMesh.set(false);
        this.hasWriterProcessedMesh.set(false);
        if (callUpdate) {
            this.update();
        }
    }

    public int getQueueSize() {
        return this.planarRegionsListsDeque.size();
    }

    public boolean isQueueEmpty() {
        return this.planarRegionsListsDeque.isEmpty();
    }

    private void clearYoVariables() {
        for (int vertexIndex = 0; vertexIndex < this.vertexBufferSize; ++vertexIndex) {
            this.vertexBuffer.get(vertexIndex).setToNaN();
        }
        this.currentMeshIndex.set(-1);
        this.currentRegionId.set(-1);
        this.currentRegionPose.setToNaN();
    }

    public YoVariable[] getVariables() {
        ArrayList<Object> allVariables = new ArrayList<Object>();
        allVariables.add(this.waitForReader);
        allVariables.add(this.hasReaderProcessedMesh);
        allVariables.add(this.hasWriterProcessedMesh);
        for (int i = 0; i < this.vertexBufferSize; ++i) {
            allVariables.add(this.vertexBuffer.get(i).getYoX());
            allVariables.add(this.vertexBuffer.get(i).getYoY());
        }
        allVariables.add(this.currentMeshIndex);
        allVariables.add(this.currentRegionId);
        allVariables.add(this.isPlanarRegionsListComplete);
        allVariables.add(this.clear);
        allVariables.add(this.currentRegionPose.getYoX());
        allVariables.add(this.currentRegionPose.getYoY());
        allVariables.add(this.currentRegionPose.getYoZ());
        allVariables.add(this.currentRegionPose.getYoQx());
        allVariables.add(this.currentRegionPose.getYoQy());
        allVariables.add(this.currentRegionPose.getYoQz());
        allVariables.add(this.currentRegionPose.getYoQs());
        return allVariables.toArray(new YoVariable[0]);
    }

    public double[] getConstants() {
        return new double[]{this.vertexBufferSize, this.meshBufferSize};
    }

    public AppearanceDefinition getAppearance() {
        return YoAppearance.AliceBlue();
    }

    public Graphics3DObject getLinkGraphics() {
        return this.graphics3dObject;
    }

    protected void computeRotationTranslation(AffineTransform transform3d) {
        transform3d.setIdentity();
    }

    protected boolean containsNaN() {
        return false;
    }

    public YoGraphicPlanarRegionsList duplicate(YoRegistry newRegistry) {
        return new YoGraphicPlanarRegionsList(this.getName(), this.getVariables(), this.getConstants());
    }

    public Artifact createArtifact() {
        throw new RuntimeException("Implement Me!");
    }
}

