/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.shapes;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.shape.primitives.interfaces.Capsule3DReadOnly;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DChangeListener;
import us.ihmc.euclid.shape.tools.EuclidShapeIOTools;
import us.ihmc.euclid.tools.EuclidCoreFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tools.EuclidHashCodeTools;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.geometry.shapes.STPShape3DTools;
import us.ihmc.robotics.geometry.shapes.interfaces.STPCapsule3DBasics;
import us.ihmc.robotics.geometry.shapes.interfaces.STPCapsule3DReadOnly;

public class STPCapsule3D
implements STPCapsule3DBasics {
    private final List<Shape3DChangeListener> changeListeners = new ArrayList<Shape3DChangeListener>();
    private double minimumMargin;
    private double maximumMargin;
    private double largeRadius;
    private double smallRadius;
    private final STPShape3DTools.STPCapsule3DSupportingVertexCalculator supportingVertexCalculator = new STPShape3DTools.STPCapsule3DSupportingVertexCalculator();
    private final Point3DBasics position = EuclidCoreFactories.newObservablePoint3DBasics((axis, value) -> this.notifyChangeListeners(), null);
    private final UnitVector3DBasics axis = EuclidCoreFactories.newObservableUnitVector3DBasics((axis, value) -> this.notifyChangeListeners(), null, (UnitVector3DBasics)new UnitVector3D((Tuple3DReadOnly)Axis3D.Z));
    private double radius;
    private double length;
    private double halfLength;
    private final Point3DReadOnly topCenter = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> this.halfLength * this.axis.getX() + this.position.getX(), () -> this.halfLength * this.axis.getY() + this.position.getY(), () -> this.halfLength * this.axis.getZ() + this.position.getZ());
    private final Point3DReadOnly bottomCenter = EuclidCoreFactories.newLinkedPoint3DReadOnly(() -> -this.halfLength * this.axis.getX() + this.position.getX(), () -> -this.halfLength * this.axis.getY() + this.position.getY(), () -> -this.halfLength * this.axis.getZ() + this.position.getZ());
    private boolean stpRadiiDirty = true;

    public STPCapsule3D() {
        this(1.0, 0.5);
    }

    public STPCapsule3D(double length, double radius) {
        this.setSize(length, radius);
        this.setupListeners();
    }

    public STPCapsule3D(Point3DReadOnly position, Vector3DReadOnly axis2, double length, double radius) {
        this.set(position, axis2, length, radius);
        this.setupListeners();
    }

    public STPCapsule3D(Capsule3DReadOnly other) {
        this.set(other);
        this.setupListeners();
    }

    public STPCapsule3D(STPCapsule3DReadOnly other) {
        this.set(other);
        this.setupListeners();
    }

    private void setupListeners() {
        this.addChangeListener(() -> {
            this.stpRadiiDirty = true;
        });
    }

    public void setRadius(double radius) {
        if (radius < 0.0) {
            throw new IllegalArgumentException("The radius of a Capsule3D cannot be negative: " + radius);
        }
        this.radius = radius;
        this.notifyChangeListeners();
    }

    public void setLength(double length) {
        if (length < 0.0) {
            throw new IllegalArgumentException("The length of a Capsule3D cannot be negative: " + length);
        }
        this.length = length;
        this.halfLength = 0.5 * length;
        this.notifyChangeListeners();
    }

    public double getRadius() {
        return this.radius;
    }

    public double getLength() {
        return this.length;
    }

    public double getHalfLength() {
        return this.halfLength;
    }

    public Point3DBasics getPosition() {
        return this.position;
    }

    public UnitVector3DBasics getAxis() {
        return this.axis;
    }

    public Point3DReadOnly getTopCenter() {
        return this.topCenter;
    }

    public Point3DReadOnly getBottomCenter() {
        return this.bottomCenter;
    }

    @Override
    public double getMinimumMargin() {
        return this.minimumMargin;
    }

    @Override
    public double getMaximumMargin() {
        return this.maximumMargin;
    }

    @Override
    public double getSmallRadius() {
        this.updateRadii();
        return this.smallRadius;
    }

    @Override
    public double getLargeRadius() {
        this.updateRadii();
        return this.largeRadius;
    }

    @Override
    public void setMargins(double minimumMargin, double maximumMargin) {
        if (maximumMargin <= minimumMargin) {
            throw new IllegalArgumentException("The maximum margin has to be strictly greater that the minimum margin, max margin: " + maximumMargin + ", min margin: " + minimumMargin);
        }
        this.minimumMargin = minimumMargin;
        this.maximumMargin = maximumMargin;
        this.stpRadiiDirty = true;
    }

    protected void updateRadii() {
        if (!this.stpRadiiDirty) {
            return;
        }
        this.stpRadiiDirty = false;
        if (this.minimumMargin == 0.0 && this.maximumMargin == 0.0) {
            this.smallRadius = Double.NaN;
            this.largeRadius = Double.NaN;
        } else {
            this.smallRadius = this.radius + this.minimumMargin;
            this.largeRadius = this.radius + STPShape3DTools.computeLargeRadiusFromMargins(this.minimumMargin, this.maximumMargin, EuclidCoreTools.square((double)this.length));
        }
    }

    @Override
    public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
        return this.supportingVertexCalculator.getSupportingVertex(this, this.getSmallRadius(), this.getLargeRadius(), supportDirection, supportingVertexToPack);
    }

    public void notifyChangeListeners() {
        for (int i = 0; i < this.changeListeners.size(); ++i) {
            this.changeListeners.get(i).changed();
        }
    }

    public void addChangeListeners(List<? extends Shape3DChangeListener> listeners) {
        for (int i = 0; i < listeners.size(); ++i) {
            this.addChangeListener(listeners.get(i));
        }
    }

    public void addChangeListener(Shape3DChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public boolean removeChangeListener(Shape3DChangeListener listener) {
        return this.changeListeners.remove(listener);
    }

    public STPCapsule3D copy() {
        return new STPCapsule3D(this);
    }

    public boolean equals(Object object) {
        if (object instanceof STPCapsule3DReadOnly) {
            return STPCapsule3DBasics.super.equals((STPCapsule3DReadOnly)object);
        }
        return false;
    }

    public int hashCode() {
        long hash = 1L;
        hash = EuclidHashCodeTools.toLongHashCode((double)this.length, (double)this.radius);
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)EuclidHashCodeTools.toLongHashCode((Object)this.position, (Object)this.axis));
        hash = EuclidHashCodeTools.combineHashCode((long)hash, (long)EuclidHashCodeTools.toLongHashCode((double)this.minimumMargin, (double)this.maximumMargin));
        return EuclidHashCodeTools.toIntHashCode((long)hash);
    }

    public String toString() {
        String stpSuffix = String.format(", small radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + ", large radius: " + EuclidCoreIOTools.DEFAULT_FORMAT + "]", this.getSmallRadius(), this.getLargeRadius());
        return "STP " + EuclidShapeIOTools.getCapsule3DString((Capsule3DReadOnly)this).replace("]", stpSuffix);
    }
}

