/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.concavePolygon2D.clippingAndMerging;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2D;
import us.ihmc.robotics.geometry.concavePolygon2D.ConcavePolygon2DReadOnly;
import us.ihmc.robotics.geometry.concavePolygon2D.GeometryPolygonTools;
import us.ihmc.robotics.geometry.concavePolygon2D.clippingAndMerging.IntersectionInfo;

public class ConcavePolygon2DClippingTools {
    private static final double epsilonForSamePoint = 1.0E-6;
    private static final double epsilonSquaredForSamePoint = 1.0E-12;
    private static final double wiggleDistance = 0.001;

    public static LinkedPointList createLinkedPointList(ConcavePolygon2DReadOnly polygon) {
        LinkedPointList linkedPointList = new LinkedPointList();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            linkedPointList.addPointToEnd(polygon.getVertex(i));
        }
        return linkedPointList;
    }

    public static ConcavePolygon2DReadOnly createConcavePolygon(LinkedPointList list) {
        ConcavePolygon2D polygon = new ConcavePolygon2D();
        LinkedPoint point = list.getFirstPoint();
        do {
            polygon.addVertex(point.getPoint());
        } while (!(point = list.isForwardList() ? point.getSuccessor() : point.getPredecessor()).equals(list.getFirstPoint()));
        polygon.update();
        return polygon;
    }

    public static void linkSharedVertices(LinkedPointList listA, LinkedPointList listB, double epsilon) {
        double epsilonSquared = epsilon * epsilon;
        LinkedPoint linkA = listA.getFirstPoint();
        do {
            LinkedPoint linkB = listB.getFirstPoint();
            LinkedPoint closestLink = null;
            double smallestDistanceSquared = epsilonSquared;
            do {
                double distanceSquared;
                if (!((distanceSquared = linkA.getPoint().distanceSquared(linkB.getPoint())) < smallestDistanceSquared)) continue;
                smallestDistanceSquared = distanceSquared;
                closestLink = linkB;
            } while ((linkB = linkB.getSuccessor()) != listB.getFirstPoint());
            if (closestLink == null) continue;
            linkA.linkToOtherList(closestLink);
            closestLink.linkToOtherList(linkA);
        } while ((linkA = linkA.getSuccessor()) != listA.getFirstPoint());
    }

    public static void insertIntersectionsIntoList(LinkedPointList list, ConcavePolygon2DReadOnly polygonToIntersect) {
        LinkedPoint startPoint = list.getFirstPoint();
        HashSet<Object> intersections = new HashSet<Object>();
        for (int i = 0; i < polygonToIntersect.getNumberOfVertices(); ++i) {
            Point2DReadOnly vertex = polygonToIntersect.getVertex(i);
            Point2DReadOnly nextVertex = polygonToIntersect.getNextVertex(i);
            if (!(EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)startPoint.getPoint(), (Point2DReadOnly)vertex, (Point2DReadOnly)nextVertex) < 1.0E-12)) continue;
            ConcavePolygon2DClippingTools.setIntersectionInfo(startPoint, startPoint.getPredecessor().getPoint(), startPoint.getPoint(), startPoint.getSuccessor().getPoint(), polygonToIntersect);
            intersections.add(new Point2D((Tuple2DReadOnly)startPoint.getPoint()));
            break;
        }
        while (true) {
            LinkedPoint nextPoint = startPoint.getSuccessor();
            IntersectionInfo intersectionInfo = ConcavePolygon2DClippingTools.findFirstIntersectionInfo(startPoint.getPoint(), nextPoint.getPoint(), polygonToIntersect, (Point2DBasics)new Point2D());
            Point2DReadOnly intersection = intersectionInfo.getIntersection();
            if (intersectionInfo.getIntersectionType() == IntersectionInfo.IntersectionType.NEW) {
                LinkedPoint point = new LinkedPoint(intersection);
                ConcavePolygon2DClippingTools.setIntersectionInfo(point, startPoint.getPoint(), intersection, nextPoint.getPoint(), polygonToIntersect);
                intersections.add(intersection);
                list.insertPoint(point, startPoint);
                continue;
            }
            if (intersectionInfo.getIntersectionType() == IntersectionInfo.IntersectionType.END && !intersections.contains(intersectionInfo.getIntersection())) {
                ConcavePolygon2DClippingTools.setIntersectionInfo(nextPoint, startPoint.getPoint(), intersection, nextPoint.getSuccessor().getPoint(), polygonToIntersect);
                intersections.add(intersection);
            }
            if ((startPoint = nextPoint) == list.getFirstPoint()) break;
        }
    }

    private static void setIntersectionInfo(LinkedPoint pointToSet, Point2DReadOnly pointBefore, Point2DReadOnly intersection, Point2DReadOnly pointAfter, ConcavePolygon2DReadOnly polygonToIntersect) {
        boolean trulyOutsideAfter;
        Point2DReadOnly slightlyBeforeIntersection = ConcavePolygon2DClippingTools.getPointSlightlyAfterIntersection(intersection, pointBefore, 0.001);
        Point2DReadOnly slightlyAfterIntersection = ConcavePolygon2DClippingTools.getPointSlightlyAfterIntersection(intersection, pointAfter, 0.001);
        boolean isBeforeOnEdge = GeometryPolygonTools.isPoint2DOnPerimeterOfSimplePolygon2D(slightlyBeforeIntersection, polygonToIntersect.getVertexBufferView(), polygonToIntersect.getNumberOfVertices(), 1.0E-6);
        boolean isAfterOnEdge = GeometryPolygonTools.isPoint2DOnPerimeterOfSimplePolygon2D(slightlyAfterIntersection, polygonToIntersect.getVertexBufferView(), polygonToIntersect.getNumberOfVertices(), 1.0E-6);
        boolean isBeforeInside = GeometryPolygonTools.isPoint2DStrictlyInsideSimplePolygon2D(slightlyBeforeIntersection, polygonToIntersect.getVertexBufferView(), polygonToIntersect.getNumberOfVertices(), null, false, 1.0E-6);
        boolean isAfterInside = GeometryPolygonTools.isPoint2DStrictlyInsideSimplePolygon2D(slightlyAfterIntersection, polygonToIntersect.getVertexBufferView(), polygonToIntersect.getNumberOfVertices(), null, false, 1.0E-6);
        boolean trulyOutsideBefore = !isBeforeOnEdge && !isBeforeInside;
        boolean bl = trulyOutsideAfter = !isAfterOnEdge && !isAfterInside;
        if (trulyOutsideAfter) {
            pointToSet.setIsPointAfterInsideOther(false);
            pointToSet.setIsPointBeforeInsideOther(isBeforeInside || isBeforeOnEdge);
        } else if (trulyOutsideBefore) {
            pointToSet.setIsPointAfterInsideOther(isAfterInside || isAfterOnEdge);
            pointToSet.setIsPointBeforeInsideOther(false);
        } else {
            pointToSet.setIsPointAfterInsideOther(true);
            pointToSet.setIsPointBeforeInsideOther(true);
        }
    }

    private static IntersectionInfo findFirstIntersectionInfo(Point2DReadOnly edgeStart, Point2DReadOnly edgeEnd, ConcavePolygon2DReadOnly polygonToIntersect, Point2DBasics intersectionToPack) {
        intersectionToPack.setToNaN();
        IntersectionInfo info = new IntersectionInfo(IntersectionInfo.IntersectionType.NONE, null);
        double epsilonForOnLine = 1.0E-4;
        double epsilonSquared = epsilonForOnLine * epsilonForOnLine;
        for (int i = 0; i < polygonToIntersect.getNumberOfVertices(); ++i) {
            Point2DReadOnly polygonNextVertex;
            Point2DReadOnly polygonVertex = polygonToIntersect.getVertex(i);
            if (EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)edgeEnd, (Point2DReadOnly)polygonVertex, (Point2DReadOnly)(polygonNextVertex = polygonToIntersect.getNextVertex(i))) < epsilonSquared) {
                info = new IntersectionInfo(IntersectionInfo.IntersectionType.END, edgeEnd);
                continue;
            }
            Point2DBasics candidateIntersection = null;
            if (EuclidGeometryTools.intersectionBetweenTwoLineSegment2Ds((Point2DReadOnly)edgeStart, (Point2DReadOnly)edgeEnd, (Point2DReadOnly)polygonVertex, (Point2DReadOnly)polygonNextVertex, (Point2DBasics)intersectionToPack)) {
                candidateIntersection = intersectionToPack;
            } else if (EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)polygonVertex, (Point2DReadOnly)edgeStart, (Point2DReadOnly)edgeEnd) < epsilonSquared) {
                candidateIntersection = polygonVertex;
            } else if (EuclidGeometryTools.distanceSquaredFromPoint2DToLineSegment2D((Point2DReadOnly)polygonNextVertex, (Point2DReadOnly)edgeStart, (Point2DReadOnly)edgeEnd) < epsilonSquared) {
                candidateIntersection = polygonNextVertex;
            }
            if (candidateIntersection == null || !(candidateIntersection.distanceSquared(edgeStart) > 1.0E-12) || !(candidateIntersection.distanceSquared(edgeEnd) > 1.0E-12)) continue;
            return new IntersectionInfo(IntersectionInfo.IntersectionType.NEW, (Point2DReadOnly)candidateIntersection);
        }
        return info;
    }

    private static Point2DReadOnly getPointSlightlyAfterIntersection(Point2DReadOnly intersection, Point2DReadOnly vertexAfter, double epsilon) {
        Vector2D direction = new Vector2D();
        direction.sub((Tuple2DReadOnly)vertexAfter, (Tuple2DReadOnly)intersection);
        direction.scale(epsilon / direction.length());
        Point2D littleBefore = new Point2D();
        littleBefore.add((Tuple2DReadOnly)direction, (Tuple2DReadOnly)intersection);
        return littleBefore;
    }

    public static class LinkedPointList {
        private LinkedPoint firstPoint;
        private LinkedPoint lastPoint;
        private boolean isForwardList = true;
        private final Collection<LinkedPoint> points = new HashSet<LinkedPoint>();

        public void addPointToEnd(double x, double y) {
            this.addPointToEnd(new LinkedPoint(x, y));
        }

        public void addPointToEnd(Point2DReadOnly point) {
            this.addPointToEnd(new LinkedPoint(point));
        }

        public void addPointToEnd(LinkedPoint point) {
            if (this.points.size() == 0) {
                this.firstPoint = point;
                this.lastPoint = point;
                point.setPredecessor(point);
                point.setSuccessor(point);
                this.points.add(point);
            } else {
                this.insertPoint(point, this.lastPoint);
            }
        }

        public void clear() {
            this.points.clear();
            this.firstPoint = null;
            this.lastPoint = null;
        }

        public LinkedPoint getLinkedPointAtLocation(Point2DReadOnly location) {
            return this.points.stream().filter(linkedPoint -> linkedPoint.getPoint().epsilonEquals((EuclidGeometry)location, 1.0E-7)).findFirst().orElse(null);
        }

        public void insertPoint(LinkedPoint pointToInsert, LinkedPoint predecessor) {
            LinkedPoint oldSuccessor = predecessor.getSuccessor();
            predecessor.setSuccessor(pointToInsert);
            oldSuccessor.setPredecessor(pointToInsert);
            pointToInsert.setSuccessor(oldSuccessor);
            pointToInsert.setPredecessor(predecessor);
            this.points.add(pointToInsert);
            if (predecessor.equals(this.lastPoint)) {
                this.lastPoint = pointToInsert;
            }
        }

        public void removePoint(LinkedPoint pointToRemove) {
            LinkedPoint predecessor = pointToRemove.getPredecessor();
            LinkedPoint successor = pointToRemove.getSuccessor();
            predecessor.setSuccessor(successor);
            successor.setPredecessor(predecessor);
            if (pointToRemove == this.firstPoint) {
                this.firstPoint = successor;
            }
            if (pointToRemove == this.lastPoint) {
                this.lastPoint = predecessor;
            }
            this.points.remove(pointToRemove);
        }

        public LinkedPoint getFirstPoint() {
            return this.firstPoint;
        }

        public LinkedPoint getLastPoint() {
            return this.lastPoint;
        }

        public boolean isForwardList() {
            return this.isForwardList;
        }

        public void reverseOrder() {
            this.isForwardList = !this.isForwardList;
            this.points.forEach(LinkedPoint::reverse);
            LinkedPoint oldFirstPoint = this.firstPoint;
            this.firstPoint = this.lastPoint;
            this.lastPoint = oldFirstPoint;
        }

        public Collection<LinkedPoint> getPoints() {
            return this.points;
        }

        public Collection<LinkedPoint> getPointsCopy() {
            ArrayList<LinkedPoint> pointsCopy = new ArrayList<LinkedPoint>();
            for (LinkedPoint point : this.points) {
                pointsCopy.add(new LinkedPoint(point));
            }
            return pointsCopy;
        }
    }

    public static class LinkedPoint {
        private LinkedPoint predecessor;
        private LinkedPoint successor;
        private boolean isPointAfterInsideOther = false;
        private boolean isPointBeforeInsideOther = false;
        private final Point2DBasics point = new Point2D();
        private LinkedPoint pointOnOtherList = null;

        public LinkedPoint() {
        }

        public LinkedPoint(Point2DReadOnly other) {
            this(other.getX(), other.getY());
        }

        public LinkedPoint(LinkedPoint other) {
            this(other.getPoint());
            this.setIsPointAfterInsideOther(other.isPointAfterInsideOther);
            this.setIsPointBeforeInsideOther(other.isPointBeforeInsideOther);
            this.setPredecessor(other.predecessor);
            this.setSuccessor(other.successor);
        }

        public LinkedPoint(double x, double y) {
            this(x, y, false, false);
        }

        public LinkedPoint(Point2DReadOnly other, boolean isPointAfterInsideOther, boolean isPointBeforeInsideOther) {
            this(other.getX(), other.getY(), isPointAfterInsideOther, isPointBeforeInsideOther);
        }

        public LinkedPoint(double x, double y, boolean isPointAfterInsideOther, boolean isPointBeforeInsideOther) {
            this.isPointAfterInsideOther = isPointAfterInsideOther;
            this.isPointBeforeInsideOther = isPointBeforeInsideOther;
            this.setPoint(x, y);
        }

        public void setIsPointAfterInsideOther(boolean isPointAfterInsideOther) {
            this.isPointAfterInsideOther = isPointAfterInsideOther;
        }

        public void setIsPointBeforeInsideOther(boolean isOutgoingIntersection) {
            this.isPointBeforeInsideOther = isOutgoingIntersection;
        }

        public boolean getIsIntersectionPoint() {
            return this.isPointAfterInsideOther || this.isPointBeforeInsideOther;
        }

        public boolean isPointAfterInsideOther() {
            return this.isPointAfterInsideOther;
        }

        public boolean isPointBeforeInsideOther() {
            return this.isPointBeforeInsideOther;
        }

        public void set(LinkedPoint other) {
            this.setPoint((Point2DReadOnly)other.point);
            this.setPredecessor(other.predecessor);
            this.setSuccessor(other.successor);
        }

        public void linkToOtherList(LinkedPoint pointOnOtherList) {
            this.pointOnOtherList = pointOnOtherList;
        }

        public boolean isLinkedToOtherList() {
            return this.pointOnOtherList != null;
        }

        public LinkedPoint getPointOnOtherList() {
            return this.pointOnOtherList;
        }

        public void reverse() {
            LinkedPoint oldSuccessor = this.successor;
            this.successor = this.predecessor;
            this.predecessor = oldSuccessor;
            boolean oldIsIncoming = this.isPointAfterInsideOther;
            this.isPointAfterInsideOther = this.isPointBeforeInsideOther;
            this.isPointBeforeInsideOther = oldIsIncoming;
        }

        public void setPoint(Point2DReadOnly point) {
            this.setPoint(point.getX(), point.getY());
        }

        public void setPoint(double x, double y) {
            this.point.set(x, y);
        }

        public void setPredecessor(LinkedPoint point) {
            this.predecessor = point;
        }

        public void setSuccessor(LinkedPoint successor) {
            this.successor = successor;
        }

        public LinkedPoint getPredecessor() {
            return this.predecessor;
        }

        public LinkedPoint getSuccessor() {
            return this.successor;
        }

        public Point2DReadOnly getPoint() {
            return this.point;
        }

        public boolean equals(LinkedPoint other) {
            if (other == this) {
                return true;
            }
            if (other == null) {
                return false;
            }
            return this.point.getX() == other.point.getX() && this.point.getY() == other.point.getY();
        }

        public String toString() {
            return this.point.toString();
        }
    }

    static class LinkedPointListHolder {
        private final Collection<LinkedPoint> listAPool;
        private final Collection<LinkedPoint> listBPool;

        public LinkedPointListHolder(Collection<LinkedPoint> listAPool, Collection<LinkedPoint> listBPool) {
            this.listAPool = listAPool;
            this.listBPool = listBPool;
        }

        public void removePoint(LinkedPoint pointToRemove) {
            LinkedPointListHolder.removePointFromList(this.listAPool, pointToRemove);
            LinkedPointListHolder.removePointFromList(this.listBPool, pointToRemove);
        }

        private static void removePointFromList(Collection<LinkedPoint> listToEdit, LinkedPoint pointToRemove) {
            for (LinkedPoint other : listToEdit) {
                if (!other.getPoint().epsilonEquals((EuclidGeometry)pointToRemove.getPoint(), 1.0E-7)) continue;
                listToEdit.remove(other);
                break;
            }
        }

        public int getNumberOfPoints() {
            return this.listAPool.size() + this.listBPool.size();
        }
    }
}

