/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commons.lists.RecyclingArrayList;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.geometry.MinMaxPointHolder;

public class StringStretcher2d {
    private final Point2D startPoint = new Point2D();
    private final Point2D endPoint = new Point2D();
    private final RecyclingArrayList<MinMaxPointHolder> minMaxPool = new RecyclingArrayList(20, MinMaxPointHolder.class);
    private final RecyclingArrayList<Point2D> waypointPool = new RecyclingArrayList(20, Point2D.class);
    private final List<MinMaxPointHolder> minMaxPoints = new ArrayList<MinMaxPointHolder>();
    private final List<Point2DBasics> waypoints = new ArrayList<Point2DBasics>();
    private final List<MinMaxPointHolder> pointsToInterpolate = new ArrayList<MinMaxPointHolder>();

    public void setStartPoint(Point2D startPoint) {
        this.setStartPoint(startPoint.getX(), startPoint.getY());
    }

    public void setStartPoint(double x, double y) {
        this.startPoint.set(x, y);
    }

    public void setEndPoint(Point2DReadOnly endPoint) {
        this.setEndPoint(endPoint.getX(), endPoint.getY());
    }

    public void setEndPoint(double x, double y) {
        this.endPoint.set(x, y);
    }

    public void stretchString(List<Point2DBasics> waypointListToPack) {
        waypointListToPack.clear();
        this.pointsToInterpolate.clear();
        this.waypointPool.clear();
        this.findWaypoints(this.waypoints);
        Point2D leftPoint = this.startPoint;
        waypointListToPack.add((Point2DBasics)this.startPoint);
        int minMaxPointsIndex = 0;
        int waypointsIndex = 0;
        boolean done = false;
        while (!done) {
            MinMaxPointHolder minMaxPoint = this.getMinMaxPoint(minMaxPointsIndex);
            Point2DBasics waypoint = this.getWaypoint(this.waypoints, waypointsIndex);
            if (minMaxPoint == null && waypoint == null) {
                done = true;
                continue;
            }
            if (minMaxPoint == null) {
                throw new RuntimeException("Shouldn't get here!");
            }
            if (waypoint == minMaxPoint.getMinPoint() || waypoint == minMaxPoint.getMaxPoint()) {
                for (int i = 0; i < this.pointsToInterpolate.size(); ++i) {
                    MinMaxPointHolder pointToInterpolate = this.pointsToInterpolate.get(i);
                    Point2DBasics wayPoint = (Point2DBasics)this.waypointPool.add();
                    StringStretcher2d.interpolate((Point2DReadOnly)leftPoint, (Point2DReadOnly)waypoint, pointToInterpolate.getMinPoint().getX(), wayPoint);
                    waypointListToPack.add(wayPoint);
                }
                this.pointsToInterpolate.clear();
                waypointListToPack.add(waypoint);
                leftPoint = waypoint;
                ++minMaxPointsIndex;
                ++waypointsIndex;
                continue;
            }
            this.pointsToInterpolate.add(minMaxPoint);
            ++minMaxPointsIndex;
        }
        for (int i = 0; i < this.pointsToInterpolate.size(); ++i) {
            MinMaxPointHolder pointToInterpolate = this.pointsToInterpolate.get(i);
            Point2D wayPoint = (Point2D)this.waypointPool.add();
            StringStretcher2d.interpolate((Point2DReadOnly)leftPoint, (Point2DReadOnly)this.endPoint, pointToInterpolate.getMinPoint().getX(), (Point2DBasics)wayPoint);
            waypointListToPack.add((Point2DBasics)wayPoint);
        }
        waypointListToPack.add((Point2DBasics)this.endPoint);
    }

    private MinMaxPointHolder getMinMaxPoint(int minMaxPointsIndex) {
        if (minMaxPointsIndex < 0) {
            return null;
        }
        if (minMaxPointsIndex >= this.minMaxPoints.size()) {
            return null;
        }
        return this.minMaxPoints.get(minMaxPointsIndex);
    }

    private Point2DBasics getWaypoint(List<Point2DBasics> waypoints, int waypointsIndex) {
        if (waypointsIndex < 0) {
            return null;
        }
        if (waypointsIndex >= waypoints.size()) {
            return null;
        }
        return waypoints.get(waypointsIndex);
    }

    public void findWaypoints(List<Point2DBasics> waypointsToPack) {
        waypointsToPack.clear();
        this.findWaypoints(waypointsToPack, (Point2DReadOnly)this.startPoint, (Point2DReadOnly)this.endPoint, 0, this.minMaxPoints.size() - 1);
    }

    public void findWaypoints(List<Point2DBasics> waypointsToPack, Point2DReadOnly startPoint, Point2DReadOnly endPoint, int startIndex, int endIndex) {
        if (startIndex > endIndex) {
            return;
        }
        if (startIndex < 0) {
            return;
        }
        if (endIndex >= this.minMaxPoints.size()) {
            return;
        }
        int worstMinViolatorIndex = this.findWorstMinViolatorIndex(startPoint, endPoint, startIndex, endIndex);
        if (worstMinViolatorIndex != -1) {
            Point2DBasics waypoint = this.minMaxPoints.get(worstMinViolatorIndex).getMinPoint();
            this.insertWaypointBeforeEndPoint(waypointsToPack, endPoint, waypoint);
            this.findWaypoints(waypointsToPack, startPoint, (Point2DReadOnly)waypoint, startIndex, worstMinViolatorIndex - 1);
            this.findWaypoints(waypointsToPack, (Point2DReadOnly)waypoint, endPoint, worstMinViolatorIndex + 1, endIndex);
        } else {
            int worstMaxViolatorIndex = this.findWorstMaxViolatorIndex(startPoint, endPoint, startIndex, endIndex);
            if (worstMaxViolatorIndex != -1) {
                Point2DBasics waypoint = this.minMaxPoints.get(worstMaxViolatorIndex).getMaxPoint();
                this.insertWaypointBeforeEndPoint(waypointsToPack, endPoint, waypoint);
                this.findWaypoints(waypointsToPack, startPoint, (Point2DReadOnly)waypoint, startIndex, worstMaxViolatorIndex - 1);
                this.findWaypoints(waypointsToPack, (Point2DReadOnly)waypoint, endPoint, worstMaxViolatorIndex + 1, endIndex);
            }
        }
    }

    private void insertWaypointBeforeEndPoint(List<Point2DBasics> waypointsToPack, Point2DReadOnly endPoint, Point2DBasics waypoint) {
        if (endPoint == this.endPoint) {
            waypointsToPack.add(waypoint);
        } else {
            waypointsToPack.add(waypointsToPack.indexOf(endPoint), waypoint);
        }
    }

    public void addMinMaxPoints(Point2DReadOnly minPoint, Point2DReadOnly maxPoint) {
        this.addMinMaxPoints(minPoint.getX(), minPoint.getY(), maxPoint.getX(), maxPoint.getY());
    }

    public void addMinMaxPoints(double minPointX, double minPointY, double maxPointX, double maxPointY) {
        int i;
        double x = minPointX;
        if (Math.abs(x - maxPointX) > 1.0E-7) {
            throw new RuntimeException("Min X " + x + " and Max X " + maxPointX + " aren't far enough apart.");
        }
        if (minPointY > maxPointY) {
            throw new RuntimeException("Min Y " + minPointY + " is greater than Max Y " + maxPointY + ".");
        }
        if (x < this.startPoint.getX()) {
            throw new RuntimeException("Min X " + x + "  is less than the start point " + this.startPoint.getX() + ".");
        }
        if (x > this.endPoint.getX()) {
            throw new RuntimeException("Min X " + x + "  is greater than the end point " + this.endPoint.getX() + ".");
        }
        for (i = 0; this.minMaxPoints.size() > i && x > this.minMaxPoints.get(i).getMinPoint().getX(); ++i) {
        }
        MinMaxPointHolder pointHolder = (MinMaxPointHolder)this.minMaxPool.add();
        pointHolder.setMaxPoint(maxPointX, maxPointY);
        pointHolder.setMinPoint(minPointX, minPointY);
        this.minMaxPoints.add(i, pointHolder);
    }

    public Point2DReadOnly findWorstMinViolator(Point2D startPoint, Point2D endPoint) {
        int worstViolatorIndex = this.findWorstMinViolatorIndex((Point2DReadOnly)startPoint, (Point2DReadOnly)endPoint, 0, this.minMaxPoints.size() - 1);
        if (worstViolatorIndex == -1) {
            return null;
        }
        MinMaxPointHolder minMaxPoint = this.getMinMaxPoint(worstViolatorIndex);
        return minMaxPoint.getMinPoint();
    }

    public Point2DReadOnly findWorstMaxViolator(Point2D startPoint, Point2D endPoint) {
        int worstViolatorIndex = this.findWorstMaxViolatorIndex((Point2DReadOnly)startPoint, (Point2DReadOnly)endPoint, 0, this.minMaxPoints.size() - 1);
        if (worstViolatorIndex == -1) {
            return null;
        }
        MinMaxPointHolder minMaxPoint = this.getMinMaxPoint(worstViolatorIndex);
        return minMaxPoint.getMaxPoint();
    }

    private int findWorstMinViolatorIndex(Point2DReadOnly startPoint, Point2DReadOnly endPoint, int startIndex, int endIndex) {
        int returnIndex = -1;
        double worstViolation = 0.0;
        for (int i = startIndex; i <= endIndex; ++i) {
            double minPointY;
            Point2DBasics minPoint = this.minMaxPoints.get(i).getMinPoint();
            double interpolatedHeightAtPoint = StringStretcher2d.interpolate(startPoint, endPoint, minPoint.getX());
            if (!(interpolatedHeightAtPoint - (minPointY = minPoint.getY()) < worstViolation)) continue;
            worstViolation = interpolatedHeightAtPoint - minPointY;
            returnIndex = i;
        }
        return returnIndex;
    }

    private int findWorstMaxViolatorIndex(Point2DReadOnly startPoint, Point2DReadOnly endPoint, int startIndex, int endIndex) {
        int returnIndex = -1;
        double worstViolation = 0.0;
        for (int i = startIndex; i <= endIndex; ++i) {
            Point2DBasics maxPoint = this.minMaxPoints.get(i).getMaxPoint();
            double interpolatedHeightAtPoint = StringStretcher2d.interpolate(startPoint, endPoint, maxPoint.getX());
            double maxPointY = maxPoint.getY();
            if (!(maxPointY - interpolatedHeightAtPoint < worstViolation)) continue;
            worstViolation = maxPointY - interpolatedHeightAtPoint;
            returnIndex = i;
        }
        return returnIndex;
    }

    public MinMaxPointHolder findMinMaxPoints(double x) {
        for (int i = 0; i < this.minMaxPoints.size(); ++i) {
            MinMaxPointHolder minMaxPoint = this.minMaxPoints.get(i);
            if (!(Math.abs(x - minMaxPoint.getMinPoint().getX()) < 1.0E-7)) continue;
            return minMaxPoint;
        }
        return null;
    }

    public void reset() {
        this.minMaxPoints.clear();
        this.minMaxPool.clear();
    }

    private static void interpolate(Point2DReadOnly startPoint, Point2DReadOnly endPoint, double x, Point2DBasics midPointToPack) {
        midPointToPack.set(x, StringStretcher2d.interpolate(startPoint, endPoint, x));
    }

    private static double interpolate(Point2DReadOnly startPoint, Point2DReadOnly endPoint, double x) {
        double startX = startPoint.getX();
        double endX = endPoint.getX();
        double percentX = (x - startX) / (endX - startX);
        return EuclidCoreTools.interpolate((double)startPoint.getY(), (double)endPoint.getY(), (double)percentX);
    }
}

