/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.Line3D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line3DBasics;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class GeometryTools {
    private static final ThreadLocal<Point2D> tempIntersection = new ThreadLocal<Point2D>(){

        @Override
        public Point2D initialValue() {
            return new Point2D();
        }
    };

    public static double angleFromXForwardToVector2D(Vector2DReadOnly vector) {
        return EuclidGeometryTools.angleFromFirstToSecondVector2D((double)1.0, (double)0.0, (double)vector.getX(), (double)vector.getY());
    }

    public static double distanceFromPointToLine2d(FramePoint3D point, FramePoint3D firstPointOnLine, FramePoint3D secondPointOnLine) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)firstPointOnLine);
        point.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnLine);
        double pointOnLineX = firstPointOnLine.getX();
        double pointOnLineY = firstPointOnLine.getY();
        double lineDirectionX = secondPointOnLine.getX() - firstPointOnLine.getX();
        double lineDirectionY = secondPointOnLine.getY() - firstPointOnLine.getY();
        return EuclidGeometryTools.distanceFromPoint2DToLine2D((double)point.getX(), (double)point.getY(), (double)pointOnLineX, (double)pointOnLineY, (double)lineDirectionX, (double)lineDirectionY);
    }

    public static double distanceFromPointToLineSegment(FramePoint3D point, FramePoint3D lineSegmentStart, FramePoint3D lineSegmentEnd) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentStart);
        point.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentEnd);
        return EuclidGeometryTools.distanceFromPoint3DToLineSegment3D((Point3DReadOnly)point, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static boolean isPointOnLeftSideOfLine(FramePoint3D point, FramePoint3D firstPointOnLine, FramePoint3D secondPointOnLine) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)firstPointOnLine);
        point.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnLine);
        Point2D lineStartPoint2d = new Point2D(firstPointOnLine.getX(), firstPointOnLine.getY());
        Point2D lineEndPoint2d = new Point2D(secondPointOnLine.getX(), secondPointOnLine.getY());
        Point2D checkPointPoint2d = new Point2D(point.getX(), point.getY());
        return EuclidGeometryTools.isPoint2DOnLeftSideOfLine2D((Point2DReadOnly)checkPointPoint2d, (Point2DReadOnly)lineStartPoint2d, (Point2DReadOnly)lineEndPoint2d);
    }

    public static FramePoint3D getOrthogonalProjectionOnPlane(FramePoint3D pointToProject, FramePoint3D pointOnPlane, FrameVector3D planeNormal) {
        FramePoint3D projection = new FramePoint3D();
        boolean success = GeometryTools.getOrthogonalProjectionOnPlane(pointToProject, pointOnPlane, planeNormal, projection);
        if (!success) {
            return null;
        }
        return projection;
    }

    public static boolean getOrthogonalProjectionOnPlane(FramePoint3D pointToProject, FramePoint3D pointOnPlane, FrameVector3D planeNormal, FramePoint3D projectionToPack) {
        pointToProject.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnPlane);
        pointToProject.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal);
        projectionToPack.setToZero(pointToProject.getReferenceFrame());
        return EuclidGeometryTools.orthogonalProjectionOnPlane3D((Point3DReadOnly)pointToProject, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DBasics)projectionToPack);
    }

    public static double getClosestPointsForTwoLines(FramePoint3D pointOnLine1, FrameVector3D lineDirection1, FramePoint3D pointOnLine2, FrameVector3D lineDirection2, FramePoint3D closestPointOnLine1ToPack, FramePoint3D closestPointOnLine2ToPack) {
        pointOnLine1.checkReferenceFrameMatch((ReferenceFrameHolder)lineDirection1);
        pointOnLine2.checkReferenceFrameMatch((ReferenceFrameHolder)lineDirection2);
        pointOnLine1.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine2);
        closestPointOnLine1ToPack.setToZero(pointOnLine1.getReferenceFrame());
        closestPointOnLine2ToPack.setToZero(pointOnLine1.getReferenceFrame());
        return EuclidGeometryTools.closestPoint3DsBetweenTwoLine3Ds((Point3DReadOnly)pointOnLine1, (Vector3DReadOnly)lineDirection1, (Point3DReadOnly)pointOnLine2, (Vector3DReadOnly)lineDirection2, (Point3DBasics)closestPointOnLine1ToPack, (Point3DBasics)closestPointOnLine2ToPack);
    }

    public static FramePoint3D getIntersectionBetweenLineAndPlane(FramePoint3D pointOnPlane, FrameVector3D planeNormal, FramePoint3D pointOnLine, FrameVector3D lineDirection) {
        pointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal);
        pointOnLine.checkReferenceFrameMatch((ReferenceFrameHolder)lineDirection);
        pointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine);
        Point3D intersection = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)pointOnLine, (Vector3DReadOnly)lineDirection);
        if (intersection == null) {
            return null;
        }
        return new FramePoint3D(pointOnPlane.getReferenceFrame(), (Tuple3DReadOnly)intersection);
    }

    public static FramePoint3D getIntersectionBetweenLineSegmentAndPlane(FramePoint3D pointOnPlane, FrameVector3D planeNormal, FramePoint3D lineSegmentStart, FramePoint3D lineSegmentEnd) {
        pointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal);
        lineSegmentStart.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentEnd);
        pointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentStart);
        Point3D intersection = EuclidGeometryTools.intersectionBetweenLineSegment3DAndPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
        if (intersection == null) {
            return null;
        }
        return new FramePoint3D(pointOnPlane.getReferenceFrame(), (Tuple3DReadOnly)intersection);
    }

    public static boolean isLineSegmentIntersectingPlane(FramePoint3D pointOnPlane, FrameVector3D planeNormal, FramePoint3D lineSegmentStart, FramePoint3D lineSegmentEnd) {
        pointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal);
        lineSegmentStart.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentEnd);
        pointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentStart);
        return EuclidGeometryTools.doesLineSegment3DIntersectPlane3D((Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal, (Point3DReadOnly)lineSegmentStart, (Point3DReadOnly)lineSegmentEnd);
    }

    public static double distanceFromPointToPlane(FramePoint3D point, FramePoint3D pointOnPlane, FrameVector3D planeNormal) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnPlane);
        point.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal);
        return EuclidGeometryTools.distanceFromPoint3DToPlane3D((Point3DReadOnly)point, (Point3DReadOnly)pointOnPlane, (Vector3DReadOnly)planeNormal);
    }

    public static boolean doLineSegmentsIntersect(FramePoint2D lineSegmentStart1, FramePoint2D lineSegmentEnd1, FramePoint2D lineSegmentStart2, FramePoint2D lineSegmentEnd2) {
        lineSegmentStart1.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentEnd1);
        lineSegmentStart2.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentEnd2);
        lineSegmentStart1.checkReferenceFrameMatch((ReferenceFrameHolder)lineSegmentStart2);
        return EuclidGeometryTools.doLineSegment2DsIntersect((Point2DReadOnly)lineSegmentStart1, (Point2DReadOnly)lineSegmentEnd1, (Point2DReadOnly)lineSegmentStart2, (Point2DReadOnly)lineSegmentEnd2);
    }

    public static boolean getIntersectionBetweenTwoLines2d(FramePoint3DReadOnly firstPointOnLine1, FramePoint3DReadOnly secondPointOnLine1, FramePoint3DReadOnly firstPointOnLine2, FramePoint3DReadOnly secondPointOnLine2, FramePoint3D intersectionToPack) {
        firstPointOnLine1.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnLine1);
        firstPointOnLine2.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnLine2);
        firstPointOnLine1.checkReferenceFrameMatch((ReferenceFrameHolder)firstPointOnLine2);
        intersectionToPack.changeFrame(firstPointOnLine1.getReferenceFrame());
        double pointOnLine1x = firstPointOnLine1.getX();
        double pointOnLine1y = firstPointOnLine1.getY();
        double lineDirection1x = secondPointOnLine1.getX() - firstPointOnLine1.getX();
        double lineDirection1y = secondPointOnLine1.getY() - firstPointOnLine1.getY();
        double pointOnLine2x = firstPointOnLine2.getX();
        double pointOnLine2y = firstPointOnLine2.getY();
        double lineDirection2x = secondPointOnLine2.getX() - firstPointOnLine2.getX();
        double lineDirection2y = secondPointOnLine2.getY() - firstPointOnLine2.getY();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((double)pointOnLine1x, (double)pointOnLine1y, (double)lineDirection1x, (double)lineDirection1y, (double)pointOnLine2x, (double)pointOnLine2y, (double)lineDirection2x, (double)lineDirection2y, (Point2DBasics)((Point2DBasics)tempIntersection.get()));
        if (!success) {
            intersectionToPack.setToNaN();
        } else {
            intersectionToPack.set(tempIntersection.get().getX(), tempIntersection.get().getY(), intersectionToPack.getZ());
        }
        return success;
    }

    public static boolean getIntersectionBetweenTwoLines2d(FramePoint3D pointOnLine1, FrameVector3D lineDirection1, FramePoint3D pointOnLine2, FrameVector3D lineDirection2, FramePoint3D intersectionToPack) {
        pointOnLine1.checkReferenceFrameMatch((ReferenceFrameHolder)lineDirection1);
        pointOnLine2.checkReferenceFrameMatch((ReferenceFrameHolder)lineDirection2);
        pointOnLine1.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnLine2);
        intersectionToPack.changeFrame(pointOnLine1.getReferenceFrame());
        double pointOnLine1x = pointOnLine1.getX();
        double pointOnLine1y = pointOnLine1.getY();
        double lineDirection1x = lineDirection1.getX();
        double lineDirection1y = lineDirection1.getY();
        double pointOnLine2x = pointOnLine2.getX();
        double pointOnLine2y = pointOnLine2.getY();
        double lineDirection2x = lineDirection2.getX();
        double lineDirection2y = lineDirection2.getY();
        boolean success = EuclidGeometryTools.intersectionBetweenTwoLine2Ds((double)pointOnLine1x, (double)pointOnLine1y, (double)lineDirection1x, (double)lineDirection1y, (double)pointOnLine2x, (double)pointOnLine2y, (double)lineDirection2x, (double)lineDirection2y, (Point2DBasics)((Point2DBasics)tempIntersection.get()));
        if (!success) {
            intersectionToPack.setToNaN();
        } else {
            intersectionToPack.set(tempIntersection.get().getX(), tempIntersection.get().getY(), intersectionToPack.getZ());
        }
        return success;
    }

    public static Line3D getIntersectionBetweenTwoPlanes(Plane3D plane1, Plane3D plane2) {
        boolean parallel;
        Line3D intersection = new Line3D();
        boolean bl = parallel = !GeometryTools.getIntersectionBetweenTwoPlanes(plane1, plane2, (Line3DBasics)intersection);
        if (parallel) {
            return null;
        }
        return intersection;
    }

    public static boolean getIntersectionBetweenTwoPlanes(Plane3D plane1, Plane3D plane2, Line3DBasics intersectionToPack) {
        return EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)plane1.getPoint(), (Vector3DReadOnly)plane1.getNormal(), (Point3DReadOnly)plane2.getPoint(), (Vector3DReadOnly)plane2.getNormal(), (double)1.0E-8, (Point3DBasics)intersectionToPack.getPoint(), (Vector3DBasics)intersectionToPack.getDirection());
    }

    public static boolean getIntersectionBetweenTwoPlanes(FramePoint3D pointOnPlane1, FrameVector3D planeNormal1, FramePoint3D pointOnPlane2, FrameVector3D planeNormal2, double angleThreshold, FramePoint3D pointOnIntersectionToPack, FrameVector3D intersectionDirectionToPack) {
        pointOnPlane1.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal1);
        pointOnPlane2.checkReferenceFrameMatch((ReferenceFrameHolder)planeNormal2);
        pointOnPlane1.checkReferenceFrameMatch((ReferenceFrameHolder)pointOnPlane2);
        pointOnIntersectionToPack.setToZero(pointOnPlane1.getReferenceFrame());
        intersectionDirectionToPack.setToZero(pointOnPlane1.getReferenceFrame());
        return EuclidGeometryTools.intersectionBetweenTwoPlane3Ds((Point3DReadOnly)pointOnPlane1, (Vector3DReadOnly)planeNormal1, (Point3DReadOnly)pointOnPlane2, (Vector3DReadOnly)planeNormal2, (double)angleThreshold, (Point3DBasics)pointOnIntersectionToPack, (Vector3DBasics)intersectionDirectionToPack);
    }

    public static FrameVector3D getPlaneNormalGivenThreePoints(FramePoint3D firstPointOnPlane, FramePoint3D secondPointOnPlane, FramePoint3D thirdPointOnPlane) {
        FrameVector3D normal = new FrameVector3D();
        boolean success = GeometryTools.getPlaneNormalGivenThreePoints(firstPointOnPlane, secondPointOnPlane, thirdPointOnPlane, normal);
        if (!success) {
            return null;
        }
        return normal;
    }

    public static boolean getPlaneNormalGivenThreePoints(FramePoint3D firstPointOnPlane, FramePoint3D secondPointOnPlane, FramePoint3D thirdPointOnPlane, FrameVector3D normalToPack) {
        firstPointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnPlane);
        firstPointOnPlane.checkReferenceFrameMatch((ReferenceFrameHolder)thirdPointOnPlane);
        normalToPack.setToZero(firstPointOnPlane.getReferenceFrame());
        return EuclidGeometryTools.normal3DFromThreePoint3Ds((Point3DReadOnly)firstPointOnPlane, (Point3DReadOnly)secondPointOnPlane, (Point3DReadOnly)thirdPointOnPlane, (Vector3DBasics)normalToPack);
    }

    public static FrameVector3D getPerpendicularVectorFromLineToPoint(FramePoint3D point, FramePoint3D firstPointOnLine, FramePoint3D secondPointOnLine, FramePoint3D orthogonalProjectionToPack) {
        FrameVector3D perpendicularVector = new FrameVector3D();
        boolean success = GeometryTools.getPerpendicularVectorFromLineToPoint(point, firstPointOnLine, secondPointOnLine, orthogonalProjectionToPack, perpendicularVector);
        if (!success) {
            return null;
        }
        return perpendicularVector;
    }

    public static boolean getPerpendicularVectorFromLineToPoint(FramePoint3D point, FramePoint3D firstPointOnLine, FramePoint3D secondPointOnLine, FramePoint3D orthogonalProjectionToPack, FrameVector3D perpendicularVectorToPack) {
        point.checkReferenceFrameMatch((ReferenceFrameHolder)firstPointOnLine);
        point.checkReferenceFrameMatch((ReferenceFrameHolder)secondPointOnLine);
        perpendicularVectorToPack.setToZero(point.getReferenceFrame());
        if (orthogonalProjectionToPack == null) {
            return EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, null, (Vector3DBasics)perpendicularVectorToPack);
        }
        orthogonalProjectionToPack.setToZero(point.getReferenceFrame());
        return EuclidGeometryTools.perpendicularVector3DFromLine3DToPoint3D((Point3DReadOnly)point, (Point3DReadOnly)firstPointOnLine, (Point3DReadOnly)secondPointOnLine, (Point3DBasics)orthogonalProjectionToPack, (Vector3DBasics)perpendicularVectorToPack);
    }

    public static void getPerpendicularVector2d(FrameVector3D vector, FrameVector3D perpendicularVectorToPack) {
        perpendicularVectorToPack.set(-vector.getY(), vector.getX(), perpendicularVectorToPack.getZ());
    }

    public static void getTopVertexOfIsoscelesTriangle(FramePoint3D baseVertexA, FramePoint3D baseVertexC, FrameVector3D trianglePlaneNormal, double ccwAngleAboutNormalAtTopVertex, FramePoint3D topVertexBToPack) {
        ReferenceFrame commonFrame = baseVertexA.getReferenceFrame();
        baseVertexC.checkReferenceFrameMatch(commonFrame);
        trianglePlaneNormal.checkReferenceFrameMatch(commonFrame);
        topVertexBToPack.setToZero(commonFrame);
        EuclidGeometryTools.topVertex3DOfIsoscelesTriangle3D((Point3DReadOnly)baseVertexA, (Point3DReadOnly)baseVertexC, (Vector3DReadOnly)trianglePlaneNormal, (double)ccwAngleAboutNormalAtTopVertex, (Point3DBasics)topVertexBToPack);
    }

    public static void clipToBoundingBox(Tuple3DBasics tupleToClip, double x1, double x2, double y1, double y2, double z1, double z2) {
        tupleToClip.setX(x1 < x2 ? MathTools.clamp((double)tupleToClip.getX(), (double)x1, (double)x2) : MathTools.clamp((double)tupleToClip.getX(), (double)x2, (double)x1));
        tupleToClip.setY(y1 < y2 ? MathTools.clamp((double)tupleToClip.getY(), (double)y1, (double)y2) : MathTools.clamp((double)tupleToClip.getY(), (double)y2, (double)y1));
        tupleToClip.setZ(z1 < z2 ? MathTools.clamp((double)tupleToClip.getZ(), (double)z1, (double)z2) : MathTools.clamp((double)tupleToClip.getZ(), (double)z2, (double)z1));
    }

    public static double distanceBetweenPoints(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new IllegalArgumentException("cannot find distance between points of different dimensions");
        }
        double distance = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double delta = a[i] - b[i];
            distance += delta * delta;
        }
        distance = Math.sqrt(distance);
        return distance;
    }

    public static void normalizeSafelyZUp(Vector3DBasics vector) {
        double distance = vector.length();
        if (distance > 1.0E-12) {
            vector.scale(1.0 / distance);
        } else {
            vector.set(0.0, 0.0, 1.0);
        }
    }

    public static double minimumDistance(FramePoint3D testPoint, List<FramePoint3D> points) {
        double minimumDistance = Double.POSITIVE_INFINITY;
        for (int i = 0; i < points.size(); ++i) {
            FramePoint3D point = points.get(i);
            minimumDistance = Math.min(minimumDistance, testPoint.distanceSquared((FramePoint3DReadOnly)point));
        }
        return Math.sqrt(minimumDistance);
    }

    public static List<FramePoint2D> changeFrameAndProjectToXYPlane(ReferenceFrame referenceFrame, List<FramePoint3D> points) {
        ArrayList<FramePoint2D> ret = new ArrayList<FramePoint2D>(points.size());
        for (int i = 0; i < points.size(); ++i) {
            FramePoint3D framePoint = new FramePoint3D((FrameTuple3DReadOnly)points.get(i));
            framePoint.changeFrame(referenceFrame);
            ret.add(new FramePoint2D((FrameTuple3DReadOnly)framePoint));
        }
        return ret;
    }

    public static List<FramePoint2D> projectOntoXYPlane(List<FramePoint3D> points) {
        ArrayList<FramePoint2D> ret = new ArrayList<FramePoint2D>(points.size());
        for (int i = 0; i < points.size(); ++i) {
            FramePoint3D point3d = points.get(i);
            ret.add(new FramePoint2D(point3d.getReferenceFrame(), point3d.getX(), point3d.getY()));
        }
        return ret;
    }

    public static boolean isZero(Tuple3DReadOnly tuple, double epsilon) {
        if (!MathTools.epsilonEquals((double)tuple.getX(), (double)0.0, (double)epsilon)) {
            return false;
        }
        if (!MathTools.epsilonEquals((double)tuple.getY(), (double)0.0, (double)epsilon)) {
            return false;
        }
        return MathTools.epsilonEquals((double)tuple.getZ(), (double)0.0, (double)epsilon);
    }

    public static boolean isZero(Tuple2DReadOnly tuple, double epsilon) {
        if (!MathTools.epsilonEquals((double)tuple.getX(), (double)0.0, (double)epsilon)) {
            return false;
        }
        return MathTools.epsilonEquals((double)tuple.getY(), (double)0.0, (double)epsilon);
    }

    public static ReferenceFrame constructReferenceFrameFromPointAndZAxis(String frameName, FramePoint3D point, FrameVector3D zAxis) {
        return GeometryTools.constructReferenceFrameFromPointAndAxis(frameName, (FramePoint3DReadOnly)point, Axis3D.Z, (FrameVector3DReadOnly)zAxis);
    }

    public static ReferenceFrame constructReferenceFrameFromPointAndAxis(String frameName, FramePoint3DReadOnly point, Axis3D axisToAlign, FrameVector3DReadOnly alignAxisWithThis) {
        ReferenceFrame parentFrame = point.getReferenceFrame();
        alignAxisWithThis.checkReferenceFrameMatch(point.getReferenceFrame());
        RigidBodyTransform transformToDesired = new RigidBodyTransform();
        transformToDesired.getTranslation().set((Tuple3DReadOnly)point);
        EuclidGeometryTools.orientation3DFromFirstToSecondVector3D((Vector3DReadOnly)axisToAlign, (Vector3DReadOnly)alignAxisWithThis, (Orientation3DBasics)transformToDesired.getRotation());
        return ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)frameName, (ReferenceFrame)parentFrame, (RigidBodyTransformReadOnly)transformToDesired);
    }

    public static void pitchAboutPoint(FramePoint3DReadOnly pointToTransform, FramePoint3DReadOnly pointToPitchAbout, double pitch, FramePoint3D resultToPack) {
        pointToTransform.checkReferenceFrameMatch((ReferenceFrameHolder)pointToPitchAbout);
        double tempX = pointToTransform.getX() - pointToPitchAbout.getX();
        double tempY = pointToTransform.getY() - pointToPitchAbout.getY();
        double tempZ = pointToTransform.getZ() - pointToPitchAbout.getZ();
        double cosAngle = Math.cos(pitch);
        double sinAngle = Math.sin(pitch);
        double x = cosAngle * tempX + sinAngle * tempZ;
        tempZ = -sinAngle * tempX + cosAngle * tempZ;
        tempX = x;
        resultToPack.setIncludingFrame((FrameTuple3DReadOnly)pointToPitchAbout);
        resultToPack.add(tempX, tempY, tempZ);
    }

    public static void yawAboutPoint(FramePoint3DReadOnly pointToTransform, FramePoint3DReadOnly pointToYawAbout, double yaw, FramePoint3D resultToPack) {
        pointToTransform.checkReferenceFrameMatch((ReferenceFrameHolder)pointToYawAbout);
        double tempX = pointToTransform.getX() - pointToYawAbout.getX();
        double tempY = pointToTransform.getY() - pointToYawAbout.getY();
        double tempZ = pointToTransform.getZ() - pointToYawAbout.getZ();
        double cosAngle = Math.cos(yaw);
        double sinAngle = Math.sin(yaw);
        double x = cosAngle * tempX + -sinAngle * tempY;
        tempY = sinAngle * tempX + cosAngle * tempY;
        tempX = x;
        resultToPack.setIncludingFrame((FrameTuple3DReadOnly)pointToYawAbout);
        resultToPack.add(tempX, tempY, tempZ);
    }

    public static void yawAboutPoint(FramePoint2DReadOnly pointToTransform, FramePoint2DReadOnly pointToYawAbout, double yaw, FramePoint2D resultToPack) {
        pointToTransform.checkReferenceFrameMatch((ReferenceFrameHolder)pointToYawAbout);
        double tempX = pointToTransform.getX() - pointToYawAbout.getX();
        double tempY = pointToTransform.getY() - pointToYawAbout.getY();
        double cosAngle = Math.cos(yaw);
        double sinAngle = Math.sin(yaw);
        double x = cosAngle * tempX + -sinAngle * tempY;
        tempY = sinAngle * tempX + cosAngle * tempY;
        tempX = x;
        resultToPack.setIncludingFrame((FrameTuple2DReadOnly)pointToYawAbout);
        resultToPack.add(tempX, tempY);
    }

    public static void rotatePoseAboutAxis(ReferenceFrame rotationAxisFrame, Axis3D rotationAxis, double angle, FramePose3D framePoseToPack) {
        GeometryTools.rotatePoseAboutAxis(rotationAxisFrame, rotationAxis, angle, false, false, framePoseToPack);
    }

    public static void rotatePoseAboutAxis(ReferenceFrame rotationAxisFrame, Axis3D rotationAxis, double angle, boolean lockPosition, boolean lockOrientation, FramePose3D framePoseToPack) {
        ReferenceFrame initialFrame = framePoseToPack.getReferenceFrame();
        framePoseToPack.changeFrame(rotationAxisFrame);
        AxisAngle axisAngle = new AxisAngle(0.0, 0.0, 0.0, angle);
        axisAngle.setElement(rotationAxis.ordinal(), 1.0);
        if (!lockPosition) {
            Point3D newPosition = new Point3D((Tuple3DReadOnly)framePoseToPack.getPosition());
            axisAngle.transform((Tuple3DBasics)newPosition);
            framePoseToPack.getPosition().set((Tuple3DReadOnly)newPosition);
        }
        if (!lockOrientation) {
            Quaternion newOrientation = new Quaternion((QuaternionReadOnly)framePoseToPack.getOrientation());
            axisAngle.transform((Orientation3DBasics)newOrientation);
            framePoseToPack.getOrientation().set((QuaternionReadOnly)newOrientation);
        }
        framePoseToPack.changeFrame(initialFrame);
    }

    public static void rotatePoseAboutAxis(FrameVector3D rotatationAxis, FramePoint3D rotationAxisOrigin, double angle, FramePose3D framePoseToPack) {
        ReferenceFrame frameWhoseZAxisIsRotationAxis = GeometryTools.constructReferenceFrameFromPointAndZAxis("rotationAxisFrame", rotationAxisOrigin, rotatationAxis);
        GeometryTools.rotatePoseAboutAxis(frameWhoseZAxisIsRotationAxis, Axis3D.Z, angle, framePoseToPack);
    }

    public static Box3D convertBoundingBox3DToBox3D(BoundingBox3DReadOnly boundingBox) {
        Point3DReadOnly minPoint = boundingBox.getMinPoint();
        Point3DReadOnly maxPoint = boundingBox.getMaxPoint();
        Point3D boxCenter = new Point3D();
        boxCenter.interpolate((Tuple3DReadOnly)minPoint, (Tuple3DReadOnly)maxPoint, 0.5);
        Vector3D size = new Vector3D();
        size.sub((Tuple3DReadOnly)maxPoint, (Tuple3DReadOnly)minPoint);
        return new Box3D((Point3DReadOnly)boxCenter, (Orientation3DReadOnly)new Quaternion(), size.getX(), size.getY(), size.getZ());
    }

    public static BoundingBox2D getIntersectionOfTwoBoundingBoxes(BoundingBox2D a, BoundingBox2D b) {
        double maxX = Math.min(a.getMaxX(), b.getMaxX());
        double maxY = Math.min(a.getMaxY(), b.getMaxY());
        double minX = Math.max(a.getMinX(), b.getMinX());
        double minY = Math.max(a.getMinY(), b.getMinY());
        if (maxX <= minX || maxY <= minY) {
            return null;
        }
        BoundingBox2D intersection = new BoundingBox2D(minX, minY, maxX, maxY);
        return intersection;
    }

    public static boolean arePoint3DsSameSideOfPlane3D(Point3DReadOnly firstQuery, Point3DReadOnly secondQuery, Point3DReadOnly firstPointOnPlane, Point3DReadOnly secondPointOnPlane, Vector3DReadOnly planeTangent) {
        double firstQueryX = firstQuery.getX();
        double firstQueryY = firstQuery.getY();
        double firstQueryZ = firstQuery.getZ();
        double secondQueryX = secondQuery.getX();
        double secondQueryY = secondQuery.getY();
        double secondQueryZ = secondQuery.getZ();
        double firstPointOnPlaneX = firstPointOnPlane.getX();
        double firstPointOnPlaneY = firstPointOnPlane.getY();
        double firstPointOnPlaneZ = firstPointOnPlane.getZ();
        double planeFirstTangentX = planeTangent.getX();
        double planeFirstTangentY = planeTangent.getY();
        double planeFirstTangentZ = planeTangent.getZ();
        double planeSecondTangentX = firstPointOnPlane.getX() - secondPointOnPlane.getX();
        double planeSecondTangentY = firstPointOnPlane.getY() - secondPointOnPlane.getY();
        double planeSecondTangentZ = firstPointOnPlane.getZ() - secondPointOnPlane.getZ();
        return GeometryTools.arePoint3DsSameSideOfPlane3D(firstQueryX, firstQueryY, firstQueryZ, secondQueryX, secondQueryY, secondQueryZ, firstPointOnPlaneX, firstPointOnPlaneY, firstPointOnPlaneZ, planeFirstTangentX, planeFirstTangentY, planeFirstTangentZ, planeSecondTangentX, planeSecondTangentY, planeSecondTangentZ);
    }

    public static boolean arePoint3DsSameSideOfPlane3D(double firstQueryX, double firstQueryY, double firstQueryZ, double secondQueryX, double secondQueryY, double secondQueryZ, double pointOnPlaneX, double pointOnPlaneY, double pointOnPlaneZ, double planeFirstTangentX, double planeFirstTangentY, double planeFirstTangentZ, double planeSecondTangentX, double planeSecondTangentY, double planeSecondTangentZ) {
        boolean isSecondQueryAbovePlane;
        double planeNormalX = planeFirstTangentY * planeSecondTangentZ - planeFirstTangentZ * planeSecondTangentY;
        double planeNormalY = planeFirstTangentZ * planeSecondTangentX - planeFirstTangentX * planeSecondTangentZ;
        double planeNormalZ = planeFirstTangentX * planeSecondTangentY - planeFirstTangentY * planeSecondTangentX;
        boolean isFirstQueryAbovePlane = EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)firstQueryX, (double)firstQueryY, (double)firstQueryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)true);
        return isFirstQueryAbovePlane == (isSecondQueryAbovePlane = EuclidGeometryTools.isPoint3DAboveOrBelowPlane3D((double)secondQueryX, (double)secondQueryY, (double)secondQueryZ, (double)pointOnPlaneX, (double)pointOnPlaneY, (double)pointOnPlaneZ, (double)planeNormalX, (double)planeNormalY, (double)planeNormalZ, (boolean)true));
    }
}

