/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import us.ihmc.euclid.geometry.Bound;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.geometry.ConvexPolygonConstructorFromInteriorOfRays;

public class ConvexPolygonScaler {
    private final LineSegment2D polygonAsLineSegment = new LineSegment2D();
    private final Point2D newVertex0 = new Point2D();
    private final Point2D newVertex1 = new Point2D();
    private final ArrayList<Line2D> rays = new ArrayList();
    private final Line2D edgeOnQ = new Line2D();
    private final Vector2D vectorPerpendicularToEdgeOnQ = new Vector2D();
    private final Line2D linePerpendicularToEdgeOnQ = new Line2D();
    private final Point2D referencePoint = new Point2D();
    private final Vector2D normalizedVector = new Vector2D();
    private final ConvexPolygon2D tempPolygon = new ConvexPolygon2D();
    private final ArrayList<Line2D> edgePool = new ArrayList();
    private final ConvexPolygonConstructorFromInteriorOfRays convexPolygonConstructorFromInteriorOfRays = new ConvexPolygonConstructorFromInteriorOfRays();
    private final Vector2D vectorToInteriorPolygonVertex = new Vector2D();

    public ConvexPolygonScaler() {
        for (int i = 0; i < 16; ++i) {
            this.edgePool.add(new Line2D());
        }
    }

    private Line2D getARay(int index) {
        if (this.edgePool.size() <= index) {
            for (int i = 0; i < index - this.edgePool.size() + 1; ++i) {
                this.edgePool.add(new Line2D());
            }
        }
        return this.edgePool.get(index);
    }

    public boolean scaleConvexPolygon(ConvexPolygon2DReadOnly polygonQ, double distance, ConvexPolygon2DBasics polygonToPack) {
        return this.scaleConvexPolygon(polygonQ, distance, polygonToPack, null);
    }

    public boolean scaleConvexPolygon(ConvexPolygon2DReadOnly polygonQ, double distance, ConvexPolygon2DBasics polygonToPack, int ... vertexStartIndicesToNotScale) {
        if (Math.abs(distance) < 1.0E-10) {
            polygonToPack.set((Vertex2DSupplier)polygonQ);
            return true;
        }
        if (polygonQ.getNumberOfVertices() == 2) {
            Point2DReadOnly vertex0 = polygonQ.getVertex(0);
            Point2DReadOnly vertex1 = polygonQ.getVertex(1);
            this.polygonAsLineSegment.set(vertex0, vertex1);
            if (distance < 0.0) {
                polygonToPack.clear();
                this.polygonAsLineSegment.direction(true, (Vector2DBasics)this.normalizedVector);
                this.normalizedVector.scale(-distance);
                polygonToPack.addVertex(vertex0.getX() - this.normalizedVector.getX(), vertex0.getY() - this.normalizedVector.getY());
                polygonToPack.addVertex(vertex1.getX() + this.normalizedVector.getX(), vertex1.getY() + this.normalizedVector.getY());
                this.polygonAsLineSegment.perpendicular(true, (Vector2DBasics)this.normalizedVector);
                this.normalizedVector.scale(distance);
                polygonToPack.addVertex(vertex0.getX() + this.normalizedVector.getX(), vertex0.getY() + this.normalizedVector.getY());
                polygonToPack.addVertex(vertex0.getX() - this.normalizedVector.getX(), vertex0.getY() - this.normalizedVector.getY());
                polygonToPack.addVertex(vertex1.getX() + this.normalizedVector.getX(), vertex1.getY() + this.normalizedVector.getY());
                polygonToPack.addVertex(vertex1.getX() - this.normalizedVector.getX(), vertex1.getY() - this.normalizedVector.getY());
                polygonToPack.update();
                return true;
            }
            if (vertex0.distance(vertex1) < 2.0 * distance) {
                polygonToPack.clear();
                polygonToPack.addVertex(0.5 * (vertex0.getX() + vertex1.getX()), 0.5 * (vertex0.getY() + vertex1.getY()));
                polygonToPack.update();
                return false;
            }
            double percentageAlongSegment = distance / this.polygonAsLineSegment.length();
            this.polygonAsLineSegment.pointBetweenEndpointsGivenPercentage(percentageAlongSegment, (Point2DBasics)this.newVertex0);
            this.polygonAsLineSegment.pointBetweenEndpointsGivenPercentage(1.0 - percentageAlongSegment, (Point2DBasics)this.newVertex1);
            polygonToPack.clear();
            polygonToPack.addVertex((Point2DReadOnly)this.newVertex0);
            polygonToPack.addVertex((Point2DReadOnly)this.newVertex1);
            polygonToPack.update();
            return true;
        }
        if (polygonQ.getNumberOfVertices() == 1) {
            if (distance < 0.0) {
                Point2DReadOnly vertex0 = polygonQ.getVertex(0);
                polygonToPack.addVertex(vertex0.getX() + distance, vertex0.getY() + distance);
                polygonToPack.addVertex(vertex0.getX() + distance, vertex0.getY() - distance);
                polygonToPack.addVertex(vertex0.getX() - distance, vertex0.getY() + distance);
                polygonToPack.addVertex(vertex0.getX() - distance, vertex0.getY() - distance);
                polygonToPack.update();
                return true;
            }
            polygonToPack.set((Vertex2DSupplier)polygonQ);
            return false;
        }
        this.rays.clear();
        int leftMostIndexOnPolygonQ = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)polygonQ, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly vertexQ = polygonQ.getVertex(leftMostIndexOnPolygonQ);
        int vertexQIndex = leftMostIndexOnPolygonQ;
        int nextVertexQIndex = polygonQ.getNextVertexIndex(leftMostIndexOnPolygonQ);
        Point2DReadOnly nextVertexQ = polygonQ.getVertex(nextVertexQIndex);
        for (int i = 0; i < polygonQ.getNumberOfVertices(); ++i) {
            this.edgeOnQ.set(vertexQ, nextVertexQ);
            this.normalizedVector.set((Tuple2DReadOnly)this.edgeOnQ.getDirection());
            if (!ConvexPolygonScaler.containsIndex(vertexQIndex, vertexStartIndicesToNotScale)) {
                this.edgeOnQ.perpendicularVector((Vector2DBasics)this.vectorPerpendicularToEdgeOnQ);
                this.vectorPerpendicularToEdgeOnQ.negate();
                this.linePerpendicularToEdgeOnQ.set(vertexQ, (Vector2DReadOnly)this.vectorPerpendicularToEdgeOnQ);
                this.linePerpendicularToEdgeOnQ.pointOnLineGivenParameter(distance, (Point2DBasics)this.referencePoint);
            } else {
                this.referencePoint.set((Tuple2DReadOnly)vertexQ);
            }
            Line2D newEdge = this.getARay(this.rays.size());
            newEdge.set((Point2DReadOnly)this.referencePoint, (Vector2DReadOnly)this.normalizedVector);
            this.rays.add(newEdge);
            vertexQIndex = nextVertexQIndex;
            nextVertexQIndex = polygonQ.getNextVertexIndex(nextVertexQIndex);
            vertexQ = nextVertexQ;
            nextVertexQ = polygonQ.getVertex(nextVertexQIndex);
        }
        boolean foundSolution = this.convexPolygonConstructorFromInteriorOfRays.constructFromInteriorOfRays(this.rays, polygonToPack);
        if (!foundSolution) {
            polygonToPack.clear();
            polygonToPack.addVertex(polygonQ.getCentroid());
            polygonToPack.update();
        }
        return foundSolution;
    }

    private static boolean containsIndex(int indexToCheck, int ... indicesToCheck) {
        if (indicesToCheck == null || indexToCheck <= 0) {
            return false;
        }
        for (int i = 0; i < indicesToCheck.length; ++i) {
            if (indexToCheck != indicesToCheck[i]) continue;
            return true;
        }
        return false;
    }

    public boolean scaleConvexPolygonToContainInteriorPolygon(ConvexPolygon2DReadOnly exteriorPolygon, ConvexPolygon2DReadOnly interiorPolygon, double distanceInside, ConvexPolygon2DBasics scaledPolygonToPack) {
        if (Math.abs(distanceInside) < 1.0E-10 && interiorPolygon.getArea() <= 1.0E-10) {
            scaledPolygonToPack.set((Vertex2DSupplier)exteriorPolygon);
            return true;
        }
        if (exteriorPolygon.getNumberOfVertices() == 2) {
            Point2DReadOnly exteriorVertex1 = exteriorPolygon.getVertex(0);
            Point2DReadOnly exteriorVertex2 = exteriorPolygon.getVertex(1);
            this.edgeOnQ.set(exteriorVertex1, exteriorVertex2);
            this.polygonAsLineSegment.set(exteriorVertex1, exteriorVertex2);
            if (distanceInside < 0.0) {
                this.scaleConvexPolygon(exteriorPolygon, distanceInside, (ConvexPolygon2DBasics)this.tempPolygon);
                return this.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)this.tempPolygon, interiorPolygon, 0.0, scaledPolygonToPack);
            }
            double extraDistanceToPoint1 = 0.0;
            int leftMostIndexOnInteriorPolygon = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)interiorPolygon, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
            Point2DReadOnly interiorVertex = interiorPolygon.getVertex(leftMostIndexOnInteriorPolygon);
            int nextInteriorVertexIndex = interiorPolygon.getNextVertexIndex(leftMostIndexOnInteriorPolygon);
            Point2DReadOnly nextInteriorVertex = interiorPolygon.getVertex(nextInteriorVertexIndex);
            for (int j = 0; j < interiorPolygon.getNumberOfVertices(); ++j) {
                this.vectorToInteriorPolygonVertex.set((Tuple2DReadOnly)interiorVertex);
                double projectedDistanceToPoint = this.edgeOnQ.getDirectionX() * this.vectorToInteriorPolygonVertex.getX() + this.edgeOnQ.getDirectionY() * this.vectorToInteriorPolygonVertex.getY();
                extraDistanceToPoint1 = Math.max(extraDistanceToPoint1, -projectedDistanceToPoint);
                interiorVertex = nextInteriorVertex;
                nextInteriorVertexIndex = interiorPolygon.getNextVertexIndex(nextInteriorVertexIndex);
                nextInteriorVertex = interiorPolygon.getVertex(nextInteriorVertexIndex);
            }
            this.edgeOnQ.getDirection().negate();
            double extraDistanceToPoint2 = 0.0;
            leftMostIndexOnInteriorPolygon = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)interiorPolygon, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
            interiorVertex = interiorPolygon.getVertex(leftMostIndexOnInteriorPolygon);
            nextInteriorVertexIndex = interiorPolygon.getNextVertexIndex(leftMostIndexOnInteriorPolygon);
            nextInteriorVertex = interiorPolygon.getVertex(nextInteriorVertexIndex);
            for (int j = 0; j < interiorPolygon.getNumberOfVertices(); ++j) {
                this.vectorToInteriorPolygonVertex.set((Tuple2DReadOnly)interiorVertex);
                double projectedDistanceToPoint = this.edgeOnQ.getDirectionX() * this.vectorToInteriorPolygonVertex.getX() + this.edgeOnQ.getDirectionY() * this.vectorToInteriorPolygonVertex.getY();
                extraDistanceToPoint2 = Math.max(extraDistanceToPoint2, -projectedDistanceToPoint);
                interiorVertex = nextInteriorVertex;
                nextInteriorVertexIndex = interiorPolygon.getNextVertexIndex(nextInteriorVertexIndex);
                nextInteriorVertex = interiorPolygon.getVertex(nextInteriorVertexIndex);
            }
            double percentAlongSegmentVertex1 = (distanceInside + extraDistanceToPoint1) / this.polygonAsLineSegment.length();
            double percentAlongSegmentVertex2 = (distanceInside + extraDistanceToPoint2) / this.polygonAsLineSegment.length();
            if (percentAlongSegmentVertex1 >= 0.5 && percentAlongSegmentVertex2 >= 0.5) {
                this.polygonAsLineSegment.pointBetweenEndpointsGivenPercentage(0.5, (Point2DBasics)this.newVertex0);
                scaledPolygonToPack.clear();
                scaledPolygonToPack.addVertex((Point2DReadOnly)this.newVertex0);
                scaledPolygonToPack.update();
                return false;
            }
            this.polygonAsLineSegment.pointBetweenEndpointsGivenPercentage(Math.min(percentAlongSegmentVertex1, 0.5), (Point2DBasics)this.newVertex0);
            this.polygonAsLineSegment.pointBetweenEndpointsGivenPercentage(1.0 - Math.min(percentAlongSegmentVertex2, 0.5), (Point2DBasics)this.newVertex1);
            scaledPolygonToPack.clear();
            scaledPolygonToPack.addVertex((Point2DReadOnly)this.newVertex0);
            scaledPolygonToPack.addVertex((Point2DReadOnly)this.newVertex1);
            scaledPolygonToPack.update();
            return true;
        }
        if (exteriorPolygon.getNumberOfVertices() == 1) {
            if (distanceInside < 0.0) {
                this.scaleConvexPolygon(exteriorPolygon, distanceInside, (ConvexPolygon2DBasics)this.tempPolygon);
                return this.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)this.tempPolygon, interiorPolygon, 0.0, scaledPolygonToPack);
            }
            scaledPolygonToPack.set((Vertex2DSupplier)exteriorPolygon);
            return false;
        }
        this.rays.clear();
        int leftMostIndexOnExteriorPolygon = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)exteriorPolygon, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
        Point2DReadOnly exteriorVertex = exteriorPolygon.getVertex(leftMostIndexOnExteriorPolygon);
        int nextExteriorVertexIndex = exteriorPolygon.getNextVertexIndex(leftMostIndexOnExteriorPolygon);
        Point2DReadOnly nextExteriorVertex = exteriorPolygon.getVertex(nextExteriorVertexIndex);
        for (int i = 0; i < exteriorPolygon.getNumberOfVertices(); ++i) {
            this.edgeOnQ.set(exteriorVertex, nextExteriorVertex);
            this.edgeOnQ.perpendicularVector((Vector2DBasics)this.vectorPerpendicularToEdgeOnQ);
            this.vectorPerpendicularToEdgeOnQ.negate();
            this.linePerpendicularToEdgeOnQ.set(exteriorVertex, (Vector2DReadOnly)this.vectorPerpendicularToEdgeOnQ);
            double extraDistance = 0.0;
            int leftMostIndexOnInteriorPolygon = EuclidGeometryPolygonTools.findVertexIndex((Vertex2DSupplier)interiorPolygon, (boolean)true, (Bound)Bound.MIN, (Bound)Bound.MIN);
            Point2DReadOnly interiorVertex = interiorPolygon.getVertex(leftMostIndexOnInteriorPolygon);
            int nextInteriorVertexIndex = interiorPolygon.getNextVertexIndex(leftMostIndexOnInteriorPolygon);
            Point2DReadOnly nextInteriorVertex = interiorPolygon.getVertex(nextInteriorVertexIndex);
            for (int j = 0; j < interiorPolygon.getNumberOfVertices(); ++j) {
                this.vectorToInteriorPolygonVertex.set((Tuple2DReadOnly)interiorVertex);
                double distancePerpendicularToEdge = this.linePerpendicularToEdgeOnQ.getDirectionX() * this.vectorToInteriorPolygonVertex.getX() + this.linePerpendicularToEdgeOnQ.getDirectionY() * this.vectorToInteriorPolygonVertex.getY();
                extraDistance = Math.max(extraDistance, -distancePerpendicularToEdge);
                interiorVertex = nextInteriorVertex;
                nextInteriorVertexIndex = interiorPolygon.getNextVertexIndex(nextInteriorVertexIndex);
                nextInteriorVertex = interiorPolygon.getVertex(nextInteriorVertexIndex);
            }
            this.linePerpendicularToEdgeOnQ.pointOnLineGivenParameter(distanceInside + extraDistance, (Point2DBasics)this.referencePoint);
            this.normalizedVector.set((Tuple2DReadOnly)this.edgeOnQ.getDirection());
            Line2D newEdge = this.getARay(this.rays.size());
            newEdge.set((Point2DReadOnly)this.referencePoint, (Vector2DReadOnly)this.normalizedVector);
            this.rays.add(newEdge);
            exteriorVertex = nextExteriorVertex;
            nextExteriorVertexIndex = exteriorPolygon.getNextVertexIndex(nextExteriorVertexIndex);
            nextExteriorVertex = exteriorPolygon.getVertex(nextExteriorVertexIndex);
        }
        boolean foundSolution = this.convexPolygonConstructorFromInteriorOfRays.constructFromInteriorOfRays(this.rays, scaledPolygonToPack);
        if (!foundSolution) {
            scaledPolygonToPack.clear();
            scaledPolygonToPack.addVertex(exteriorPolygon.getCentroid());
            scaledPolygonToPack.update();
        }
        return foundSolution;
    }

    public void scaleConvexPolygon(FrameConvexPolygon2DReadOnly polygonQ, double distance, FrameConvexPolygon2D framePolygonToPack) {
        if (Math.abs(distance) < 1.0E-10) {
            framePolygonToPack.setIncludingFrame((FrameVertex2DSupplier)polygonQ);
            return;
        }
        framePolygonToPack.clear(polygonQ.getReferenceFrame());
        framePolygonToPack.update();
        this.scaleConvexPolygon((ConvexPolygon2DReadOnly)polygonQ, distance, (ConvexPolygon2DBasics)framePolygonToPack);
        framePolygonToPack.update();
    }

    public double computeMaximumScaleDistance(ConvexPolygon2DReadOnly regionToScale, double projectionDistanceLowerBound, double projectionDistanceUpperBound, double precision, int ... vertexStartIndicesToNotScale) {
        int iterations = 0;
        int maxIterations = 50;
        if (projectionDistanceUpperBound < 0.0) {
            BoundingBox2DReadOnly boundingBox = regionToScale.getBoundingBox();
            projectionDistanceUpperBound = Math.max(boundingBox.getMaxX() - boundingBox.getMinX(), boundingBox.getMaxY() - boundingBox.getMinY());
        }
        if (projectionDistanceLowerBound > projectionDistanceUpperBound) {
            LogTools.error((String)"Received lower bound that's greater than upper bound");
            return 0.0;
        }
        while (projectionDistanceUpperBound - projectionDistanceLowerBound > precision && iterations < maxIterations) {
            double projectionQuery = 0.5 * (projectionDistanceUpperBound + projectionDistanceLowerBound);
            boolean success = this.scaleConvexPolygon(regionToScale, projectionQuery, (ConvexPolygon2DBasics)this.tempPolygon, vertexStartIndicesToNotScale);
            if (success) {
                projectionDistanceLowerBound = projectionQuery;
            } else {
                projectionDistanceUpperBound = projectionQuery;
            }
            ++iterations;
        }
        return projectionDistanceLowerBound;
    }
}

