/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.filters;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import us.ihmc.commons.MathTools;

public class ZeroLagLowPassFilter {
    private static final int numberFactor = 3;

    public static ArrayList<Double> getFilteredArray(ArrayList<Double> arrayToFilter, double alpha) {
        double[] filteredArray = ZeroLagLowPassFilter.getFilteredArray(ArrayUtils.toPrimitive((Double[])arrayToFilter.toArray(new Double[arrayToFilter.size()])), alpha);
        return new ArrayList<Double>(Arrays.asList(ArrayUtils.toObject((double[])filteredArray)));
    }

    public static double[] getFilteredArray(double[] arrayToFilter, double alpha) {
        if (arrayToFilter.length < 3) {
            return Arrays.copyOf(arrayToFilter, arrayToFilter.length);
        }
        alpha = MathTools.clamp((double)alpha, (double)0.0, (double)1.0);
        ArrayList<Double> arrayListToFilter = new ArrayList<Double>(Arrays.asList(ArrayUtils.toObject((double[])arrayToFilter)));
        int originalArrayLength = arrayListToFilter.size();
        ZeroLagLowPassFilter.preAndPostPendedToList(arrayListToFilter);
        double[] listToFilter = new double[arrayListToFilter.size()];
        for (int i = 0; i < listToFilter.length; ++i) {
            listToFilter[i] = arrayListToFilter.get(i);
        }
        double[] filteredList = new double[listToFilter.length];
        filteredList[0] = listToFilter[0];
        for (int i = 1; i < filteredList.length; ++i) {
            filteredList[i] = alpha * filteredList[i - 1] + (1.0 - alpha) * listToFilter[i];
        }
        double[] reverseOrderFilteredList = ZeroLagLowPassFilter.getReserveredOrderedArrayCopy(filteredList);
        filteredList[0] = reverseOrderFilteredList[0];
        for (int i = 1; i < filteredList.length; ++i) {
            filteredList[i] = alpha * filteredList[i - 1] + (1.0 - alpha) * reverseOrderFilteredList[i];
        }
        filteredList = ZeroLagLowPassFilter.getReserveredOrderedArrayCopy(filteredList);
        double[] ret = Arrays.copyOfRange(filteredList, 3, originalArrayLength + 3);
        return ret;
    }

    private static void preAndPostPendedToList(ArrayList<Double> list) {
        double startValue = list.get(0);
        for (int i = 0; i < 3; ++i) {
            double value = 2.0 * startValue - list.get(3);
            list.add(i, value);
        }
        double endValue = list.get(list.size() - 1);
        int startingIndex = list.size() - 2;
        for (int i = 0; i < 3; ++i) {
            double value = 2.0 * endValue - list.get(startingIndex - i);
            list.add(value);
        }
    }

    public static void main(String[] args) {
        ArrayList<Double> list = new ArrayList<Double>();
        double[] newList = new double[10];
        for (int i = 0; i < 10; ++i) {
            list.add((double)i + 1.0);
            newList[i] = i + 1;
        }
        double[] filteredList = ZeroLagLowPassFilter.getFilteredArray(newList, 0.5);
        System.out.println(Arrays.toString(filteredList));
    }

    private static double[] getReserveredOrderedArrayCopy(double[] arrayToReverseAndCopy) {
        int length = arrayToReverseAndCopy.length;
        double[] ret = new double[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = arrayToReverseAndCopy[length - i - 1];
        }
        return ret;
    }
}

