/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.ArrayUtils;

public class GlitchFilterForDataSet {
    private ArrayList<Double> fractionOfPointsFilteredList = new ArrayList();
    private ArrayList<Integer> numberOfPointsFilteredList = new ArrayList();
    private final int maximumNumberOfIterations;
    private final double accelerationThreshold;
    private int numberOfPointsFiltered = Integer.MAX_VALUE;

    public GlitchFilterForDataSet(int maximumNumberOfIterations, double accelerationThreshold) {
        this.maximumNumberOfIterations = maximumNumberOfIterations;
        this.accelerationThreshold = accelerationThreshold;
    }

    public ArrayList<Double> getGlitchFilteredSet(ArrayList<Double> dataSetToFilter) {
        double[] filteredArray = this.getGlitchFilteredSet(ArrayUtils.toPrimitive((Double[])dataSetToFilter.toArray(new Double[dataSetToFilter.size()])));
        return new ArrayList<Double>(Arrays.asList(ArrayUtils.toObject((double[])filteredArray)));
    }

    public double[] getGlitchFilteredSet(double[] dataSetToFilter) {
        this.fractionOfPointsFilteredList = new ArrayList();
        this.numberOfPointsFilteredList = new ArrayList();
        double[] ret = Arrays.copyOf(dataSetToFilter, dataSetToFilter.length);
        int totalNumberOfPoints = ret.length;
        for (int numberOfRuns = 0; numberOfRuns < this.maximumNumberOfIterations && this.numberOfPointsFiltered > 0; ++numberOfRuns) {
            ret = this.getFilteredSet(ret);
            this.numberOfPointsFilteredList.add(this.numberOfPointsFiltered);
            this.fractionOfPointsFilteredList.add((double)this.numberOfPointsFiltered / (double)totalNumberOfPoints);
        }
        return ret;
    }

    public ArrayList<Double> getFractionOfPointsFiltered() {
        return this.fractionOfPointsFilteredList;
    }

    public ArrayList<Integer> getNumberOfPointsFiltered() {
        return this.numberOfPointsFilteredList;
    }

    private double[] getFilteredSet(double[] dataToFilter) {
        int sizeOfAccelerationWindow;
        int sizeOfWindow = Math.min(20, (int)Math.floor((double)(dataToFilter.length + 1) / 2.0));
        int numberOfPoints = dataToFilter.length;
        double[] acceleration = new double[numberOfPoints];
        for (int i = sizeOfAccelerationWindow = 1; i < numberOfPoints - sizeOfAccelerationWindow; ++i) {
            acceleration[i] = (dataToFilter[i + sizeOfAccelerationWindow] - 2.0 * dataToFilter[i] + dataToFilter[i - sizeOfAccelerationWindow]) / (double)(sizeOfAccelerationWindow * sizeOfAccelerationWindow);
        }
        ArrayList<Integer> listOfHighAccelIndecies = new ArrayList<Integer>();
        for (int i = 0; i < acceleration.length; ++i) {
            if (!(Math.abs(acceleration[i]) > this.accelerationThreshold)) continue;
            listOfHighAccelIndecies.add(i);
        }
        double[] averagedData = GlitchFilterForDataSet.getSetFilteredWithWindowedAverage(dataToFilter, sizeOfWindow);
        listOfHighAccelIndecies = this.getListWithFalsePositivesRemoved(listOfHighAccelIndecies, dataToFilter, averagedData);
        this.numberOfPointsFiltered = listOfHighAccelIndecies.size();
        double[] ret = Arrays.copyOf(dataToFilter, dataToFilter.length);
        this.replaceGlitchesWithSmoothedData(ret, listOfHighAccelIndecies);
        return ret;
    }

    private void replaceGlitchesWithSmoothedData(double[] data, ArrayList<Integer> listOfHighAccelIndecies) {
        for (int i = 0; i < listOfHighAccelIndecies.size(); ++i) {
            double newValue;
            int indexToReplace = listOfHighAccelIndecies.get(i);
            int indexBelow = indexToReplace - 1;
            while (listOfHighAccelIndecies.contains(indexBelow)) {
                --indexBelow;
            }
            int indexAbove = indexToReplace + 1;
            while (listOfHighAccelIndecies.contains(indexAbove)) {
                ++indexAbove;
            }
            data[indexToReplace] = newValue = (data[indexBelow] + data[indexAbove]) / 2.0;
        }
    }

    private ArrayList<Integer> getListWithFalsePositivesRemoved(ArrayList<Integer> listOfHighAccelIndecies, double[] dataToFilter, double[] averagedData) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        int foundCount = 1;
        for (int i = 1; i < listOfHighAccelIndecies.size(); ++i) {
            List<Integer> indeciesToCheck;
            if (listOfHighAccelIndecies.get(i) - listOfHighAccelIndecies.get(i - 1) == 1) {
                ++foundCount;
            } else if (foundCount != 1) {
                indeciesToCheck = listOfHighAccelIndecies.subList(i - foundCount, i);
                ret.addAll(this.getBadIndecies(indeciesToCheck, dataToFilter, averagedData));
                foundCount = 1;
            }
            if (i != listOfHighAccelIndecies.size() - 1 || foundCount <= 1) continue;
            indeciesToCheck = listOfHighAccelIndecies.subList(i - foundCount + 1, i + 1);
            ret.addAll(this.getBadIndecies(indeciesToCheck, dataToFilter, averagedData));
        }
        return ret;
    }

    private ArrayList<Integer> getBadIndecies(List<Integer> indeciesToCheck, double[] dataToFilter, double[] averagedData) {
        int numberOfElements = indeciesToCheck.size();
        double total = 0.0;
        double[] difference = new double[numberOfElements];
        for (int i = 0; i < numberOfElements; ++i) {
            difference[i] = Math.abs(dataToFilter[indeciesToCheck.get(i)] - averagedData[indeciesToCheck.get(i)]);
            total += difference[i];
        }
        double averageDifference = total / (double)numberOfElements;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < numberOfElements; ++i) {
            if (!(difference[i] > averageDifference)) continue;
            ret.add(indeciesToCheck.get(i));
        }
        return ret;
    }

    public static double[] getSetFilteredWithWindowedAverage(double[] dataSetToFilter, int numberOfPointsOnEitherSideFormingWindow) {
        if (dataSetToFilter == null || 2 * numberOfPointsOnEitherSideFormingWindow + 1 > dataSetToFilter.length) {
            return dataSetToFilter;
        }
        double[] ret = Arrays.copyOf(dataSetToFilter, dataSetToFilter.length);
        for (int i = 0; i < dataSetToFilter.length; ++i) {
            int endingIndex;
            double total = 0.0;
            int startingIndex = i - numberOfPointsOnEitherSideFormingWindow;
            if (startingIndex < 0) {
                startingIndex = 0;
            }
            if ((endingIndex = i + numberOfPointsOnEitherSideFormingWindow) > dataSetToFilter.length - 1) {
                endingIndex = dataSetToFilter.length - 1;
            }
            for (int j = startingIndex; j <= endingIndex; ++j) {
                total += dataSetToFilter[j];
            }
            int pointsInSample = endingIndex - startingIndex + 1;
            ret[i] = total / (double)pointsInSample;
        }
        return ret;
    }

    public static void main(String[] args) {
        GlitchFilterForDataSet glitchFilterForDataSet = new GlitchFilterForDataSet(10, 4.0);
        double stepSize = 0.01;
        int numberOfPoints = 1000;
        double[] data = new double[numberOfPoints];
        Random random = new Random(100L);
        int glitchConter = 0;
        for (int i = 0; i < numberOfPoints; ++i) {
            if (random.nextDouble() > 0.95 && i > 40 && i < numberOfPoints - 40) {
                data[i] = 10.0;
                ++glitchConter;
                continue;
            }
            data[i] = Math.sin((double)i * stepSize * 2.0 * Math.PI);
        }
        double[] filteredFata = glitchFilterForDataSet.getGlitchFilteredSet(data);
        System.out.println("Actual number of glitches = " + glitchConter);
        System.out.println(glitchFilterForDataSet.getNumberOfPointsFiltered());
        System.out.print("dataFromJava=[");
        for (double value : data) {
            System.out.println(value);
        }
        System.out.println("];");
        System.out.print("\nfilteredFromJava=[");
        for (double value : filteredFata) {
            System.out.println(value);
        }
        System.out.println("];");
    }
}

