/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.stiction;

import us.ihmc.robotics.controllers.stiction.StictionModel;
import us.ihmc.robotics.math.filters.GlitchFilteredYoInteger;
import us.ihmc.robotics.math.filters.RateLimitedYoVariable;
import us.ihmc.yoVariables.parameters.DoubleParameter;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.providers.IntegerProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;

public class StictionCompensator {
    private final DoubleProvider desiredTorqueStictionLimitFactor;
    private final YoDouble stictionCompensationLimit;
    private final DoubleProvider movingVelocityThreshold;
    private final DoubleProvider movingAccelerationThreshold;
    private final DoubleProvider acceleratingThreshold;
    private final DoubleProvider stictionCompensationRate;
    private final RateLimitedYoVariable stictionCompensation;
    private final StictionModel stictionModel;
    private double currentPosition;
    private double desiredPosition;
    private double currentVelocity;
    private double desiredVelocity;
    private double desiredAcceleration;
    private double desiredTorque;
    private final YoEnum<StictionActionMode> stictionActionMode;
    private final GlitchFilteredYoInteger stictionActionModeIndex;
    private final YoInteger windowSize;
    private final DoubleProvider minTimeInMode;
    private final YoDouble timeInCurrentMode;
    private final double controlDt;

    public StictionCompensator(String prefix, StictionModel stictionModel, double controlDT, YoRegistry parentRegistry) {
        this.stictionModel = stictionModel;
        this.controlDt = controlDT;
        YoRegistry registry = new YoRegistry(prefix + this.getClass().getSimpleName());
        this.movingVelocityThreshold = new DoubleParameter(prefix + "_MovingVelocityThreshold", registry, 0.01);
        this.movingAccelerationThreshold = new DoubleParameter(prefix + "_MovingAccelerationThreshold", registry, 0.1);
        this.acceleratingThreshold = new DoubleParameter(prefix + "_AcceleratingThreshold", registry, 1.0);
        this.desiredTorqueStictionLimitFactor = new DoubleParameter(prefix + "_DesiredTorqueStictionLimitFactor", registry, 2.0);
        this.stictionCompensationLimit = new YoDouble(prefix + "_StictionCompensationLimit", registry);
        this.stictionCompensationRate = new DoubleParameter(prefix + "_StictionCompensationRate", registry, 10.0);
        this.stictionCompensation = new RateLimitedYoVariable(prefix + "_StictionCompensation", registry, this.stictionCompensationRate, controlDT);
        this.stictionActionMode = new YoEnum(prefix + "_StictionActionMode", registry, StictionActionMode.class);
        this.windowSize = new YoInteger(prefix + "_StictionActionModeWindowSize", registry);
        this.stictionActionModeIndex = new GlitchFilteredYoInteger(prefix + "_StictionActionModeIndex", (IntegerProvider)this.windowSize, registry);
        this.minTimeInMode = new DoubleParameter(prefix + "_MinTimeInMode", registry, 0.05);
        this.timeInCurrentMode = new YoDouble(prefix + "_TimeInCurrentMode", registry);
        this.stictionActionModeIndex.set(StictionActionMode.Stopped.index());
        this.stictionActionMode.set((Enum)StictionActionMode.Stopped);
        parentRegistry.addChild(registry);
    }

    public void setPositions(double currentPosition, double desiredPosition) {
        this.currentPosition = currentPosition;
        this.desiredPosition = desiredPosition;
    }

    public void setVelocities(double currentVelocity, double desiredVelocity) {
        this.currentVelocity = currentVelocity;
        this.desiredVelocity = desiredVelocity;
    }

    public void setDesiredAcceleration(double desiredAcceleration) {
        this.desiredAcceleration = desiredAcceleration;
    }

    public void setDesiredTorque(double desiredTorque) {
        this.desiredTorque = desiredTorque;
    }

    public void resetStictionCompensation() {
        this.stictionCompensationLimit.set(0.0);
        this.stictionCompensation.set(0.0);
    }

    public double computeStictionCompensation() {
        this.updateActionMode();
        if (((StictionActionMode)this.stictionActionMode.getEnumValue()).active()) {
            double torqueSign = Math.signum(this.desiredTorque);
            double stictionMagnitude = this.stictionModel.getStictionMagnitude();
            this.stictionCompensationLimit.set(Math.min(torqueSign * this.desiredTorque * this.desiredTorqueStictionLimitFactor.getValue(), stictionMagnitude));
            this.stictionCompensation.update(torqueSign * this.stictionCompensationLimit.getDoubleValue());
        } else {
            this.stictionCompensationLimit.set(0.0);
            this.stictionCompensation.update(this.stictionCompensationLimit.getDoubleValue());
        }
        return this.stictionCompensation.getDoubleValue();
    }

    private void updateActionMode() {
        this.timeInCurrentMode.add(this.controlDt);
        this.updateWindowSize();
        StictionActionMode estimatedCurrentMode = this.estimateCurrentActionMode();
        if (this.timeInCurrentMode.getDoubleValue() > this.minTimeInMode.getValue() && estimatedCurrentMode != this.stictionActionMode.getEnumValue()) {
            this.stictionActionMode.set((Enum)estimatedCurrentMode);
            this.timeInCurrentMode.set(0.0);
        }
    }

    private void updateWindowSize() {
        this.windowSize.set((int)(0.25 * this.minTimeInMode.getValue() / this.controlDt));
    }

    private StictionActionMode estimateCurrentActionMode() {
        this.stictionActionModeIndex.update(this.estimateCurrentActionModeIndex());
        return StictionActionMode.getMode(this.stictionActionModeIndex.getValue());
    }

    private int estimateCurrentActionModeIndex() {
        if (Math.abs(this.desiredVelocity) < this.movingVelocityThreshold.getValue() && Math.abs(this.desiredAcceleration) < this.movingAccelerationThreshold.getValue()) {
            return StictionActionMode.Stopped.index();
        }
        if (Math.abs(this.desiredAcceleration) > this.acceleratingThreshold.getValue()) {
            double accelerationSign;
            double velocitySign = Math.signum(this.desiredVelocity);
            if (velocitySign * (accelerationSign = Math.signum(this.desiredAcceleration)) > 0.0) {
                return StictionActionMode.Accelerating.index();
            }
            return StictionActionMode.Braking.index();
        }
        return StictionActionMode.Moving.index();
    }

    public double getStictionCompensation() {
        return this.stictionCompensation.getDoubleValue();
    }

    public double getDesiredTorque() {
        return this.desiredTorque;
    }

    static enum StictionActionMode {
        Moving(0),
        Accelerating(1),
        Braking(2),
        Stopped(3);

        private final int index;
        public static StictionActionMode[] values;

        private StictionActionMode(int index) {
            this.index = index;
        }

        public static StictionActionMode getMode(int index) {
            return values[index];
        }

        public int index() {
            return this.index;
        }

        public boolean active() {
            switch (this) {
                case Moving: 
                case Accelerating: {
                    return true;
                }
            }
            return false;
        }

        static {
            values = StictionActionMode.values();
        }
    }
}

