/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers.pidGains.implementations;

import java.util.Arrays;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.robotics.controllers.pidGains.GainCalculator;
import us.ihmc.robotics.controllers.pidGains.PID3DGains;
import us.ihmc.robotics.controllers.pidGains.PID3DGainsReadOnly;

public class DefaultPID3DGains
implements PID3DGains,
Settable<DefaultPID3DGains> {
    private double[] proportionalGains = new double[3];
    private double[] derivativeGains = new double[3];
    private double[] integralGains = new double[3];
    private double[] dampingRatios = new double[3];
    private double maxIntegralError = 0.0;
    private double maxDerivativeError = Double.POSITIVE_INFINITY;
    private double maxProportionalError = Double.POSITIVE_INFINITY;
    private double maxFeedback = Double.POSITIVE_INFINITY;
    private double maxFeedbackRate = Double.POSITIVE_INFINITY;

    public DefaultPID3DGains() {
    }

    public DefaultPID3DGains(PID3DGainsReadOnly other) {
        this.set(other);
    }

    public void set(DefaultPID3DGains other) {
        PID3DGains.super.set(other);
    }

    @Override
    public double[] getProportionalGains() {
        return this.proportionalGains;
    }

    @Override
    public double[] getDerivativeGains() {
        return this.derivativeGains;
    }

    @Override
    public double[] getIntegralGains() {
        return this.integralGains;
    }

    @Override
    public double getMaximumIntegralError() {
        return this.maxIntegralError;
    }

    @Override
    public double getMaximumDerivativeError() {
        return this.maxDerivativeError;
    }

    @Override
    public double getMaximumProportionalError() {
        return this.maxProportionalError;
    }

    @Override
    public double getMaximumFeedback() {
        return this.maxFeedback;
    }

    @Override
    public double getMaximumFeedbackRate() {
        return this.maxFeedbackRate;
    }

    @Override
    public void setProportionalGains(double proportionalGainX, double proportionalGainY, double proportionalGainZ) {
        this.proportionalGains[0] = proportionalGainX;
        this.proportionalGains[1] = proportionalGainY;
        this.proportionalGains[2] = proportionalGainZ;
        this.updateDerivativeGains();
    }

    @Override
    public void setDerivativeGains(double derivativeGainX, double derivativeGainY, double derivativeGainZ) {
        this.derivativeGains[0] = derivativeGainX;
        this.derivativeGains[1] = derivativeGainY;
        this.derivativeGains[2] = derivativeGainZ;
        this.updateDampingRatios();
    }

    public void setDampingRatios(double dampingRatioX, double dampingRatioY, double dampingRatioZ) {
        this.dampingRatios[0] = dampingRatioX;
        this.dampingRatios[1] = dampingRatioY;
        this.dampingRatios[2] = dampingRatioZ;
        this.updateDerivativeGains();
    }

    public void setDampingRatios(double dampingRatio) {
        this.setDampingRatios(dampingRatio, dampingRatio, dampingRatio);
    }

    private void updateDerivativeGains() {
        for (int i = 0; i < 3; ++i) {
            this.derivativeGains[i] = GainCalculator.computeDerivativeGain(this.proportionalGains[i], this.dampingRatios[i]);
        }
    }

    private void updateDampingRatios() {
        for (int i = 0; i < 3; ++i) {
            this.dampingRatios[i] = GainCalculator.computeDampingRatio(this.proportionalGains[i], this.derivativeGains[i]);
        }
    }

    @Override
    public void setIntegralGains(double integralGainX, double integralGainY, double integralGainZ, double maxIntegralError) {
        this.integralGains[0] = integralGainX;
        this.integralGains[1] = integralGainY;
        this.integralGains[2] = integralGainZ;
        this.maxIntegralError = maxIntegralError;
    }

    @Override
    public void setMaxFeedbackAndFeedbackRate(double maxFeedback, double maxFeedbackRate) {
        this.maxFeedback = maxFeedback;
        this.maxFeedbackRate = maxFeedbackRate;
    }

    @Override
    public void setMaxDerivativeError(double maxDerivativeError) {
        this.maxDerivativeError = maxDerivativeError;
    }

    @Override
    public void setMaxProportionalError(double maxProportionalError) {
        this.maxProportionalError = maxProportionalError;
    }

    public boolean equals(Object object) {
        if (object instanceof DefaultPID3DGains) {
            DefaultPID3DGains other = (DefaultPID3DGains)object;
            if (!Arrays.equals(this.dampingRatios, other.dampingRatios)) {
                return false;
            }
            return PID3DGains.super.equals(other);
        }
        if (object instanceof PID3DGainsReadOnly) {
            return PID3DGains.super.equals((PID3DGainsReadOnly)object);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": kp: " + Arrays.toString(this.proportionalGains) + ", kd: " + Arrays.toString(this.derivativeGains) + ", ki: " + Arrays.toString(this.integralGains);
    }
}

