/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import us.ihmc.robotics.alphaToAlpha.AlphaToAlphaFunction;

public class SmearedSinusoidalTransformation
implements AlphaToAlphaFunction {
    private boolean zeroVelAtStart;
    private double exponent;

    public SmearedSinusoidalTransformation(int originalListSize, int finalListSize, boolean zeroVelAtStart) {
        double scaleFactor = (double)finalListSize / (double)originalListSize;
        double fudgeFactor = 0.8;
        this.exponent = Math.pow(scaleFactor / 1.5707963267948966, fudgeFactor);
        this.zeroVelAtStart = zeroVelAtStart;
    }

    @Override
    public double getAlphaPrime(double alpha) {
        alpha = alpha > 1.0 ? 1.0 : alpha;
        alpha = alpha < 0.0 ? 0.0 : alpha;
        alpha = Math.pow(alpha, this.exponent);
        double alphaPrime = this.zeroVelAtStart ? 1.0 - Math.cos(1.5707963267948966 * alpha) : Math.sin(1.5707963267948966 * alpha);
        return alphaPrime;
    }

    @Override
    public double getDerivativeAtAlpha(double alpha) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public double getSecondDerivativeAtAlpha(double alpha) {
        throw new RuntimeException("Not implemented yet!");
    }

    @Override
    public double getMaxAlpha() {
        return 1.0;
    }

    public static void main(String[] args) {
        new SmearedSinusoidalTransformation(300, 100, true);
    }
}

