/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories.providers;

import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;

public class CurrentRigidBodyStateProvider {
    private final MovingReferenceFrame frameOfInterest;
    private final Twist twist = new Twist();

    public CurrentRigidBodyStateProvider(MovingReferenceFrame frameOfInterest) {
        this.frameOfInterest = frameOfInterest;
    }

    public void getPosition(FixedFramePoint3DBasics positionToPack) {
        positionToPack.setFromReferenceFrame((ReferenceFrame)this.frameOfInterest);
    }

    public void getLinearVelocity(FixedFrameVector3DBasics linearVelocityToPack) {
        this.frameOfInterest.getTwistOfFrame((TwistBasics)this.twist);
        linearVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.twist.getLinearPart());
    }

    public void getOrientation(FixedFrameQuaternionBasics orientationToPack) {
        orientationToPack.setFromReferenceFrame((ReferenceFrame)this.frameOfInterest);
    }

    public void getAngularVelocity(FixedFrameVector3DBasics angularVelocityToPack) {
        this.frameOfInterest.getTwistOfFrame((TwistBasics)this.twist);
        angularVelocityToPack.setMatchingFrame((FrameTuple3DReadOnly)this.twist.getAngularPart());
    }
}

