/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import java.util.ArrayList;

public class TrapezoidalVelocityTrajectory {
    private final double epsilon = 1.0E-7;
    private final double t0;
    private final double dT1;
    private final double dT2;
    private final double dTF;
    private final double x0;
    private final double v0;
    private final double vMax;
    private final double a;

    public TrapezoidalVelocityTrajectory(TrapezoidalVelocityTrajectory trapezoidalVelocityTrajectory) {
        this.t0 = trapezoidalVelocityTrajectory.t0;
        this.dT1 = trapezoidalVelocityTrajectory.dT1;
        this.dT2 = trapezoidalVelocityTrajectory.dT2;
        this.dTF = trapezoidalVelocityTrajectory.dTF;
        this.x0 = trapezoidalVelocityTrajectory.x0;
        this.v0 = trapezoidalVelocityTrajectory.v0;
        this.vMax = trapezoidalVelocityTrajectory.vMax;
        this.a = trapezoidalVelocityTrajectory.a;
    }

    public TrapezoidalVelocityTrajectory(double t0, double x0, double xF, double v0, double vF, double vMax, double aMax) {
        this(t0, x0, xF, v0, vF, vMax, aMax, true);
    }

    public TrapezoidalVelocityTrajectory(double t0, double x0, double xF, double v0, double vF, double vMax, double aMax, boolean enforceFinalVelocity) {
        double dT1;
        TrapezoidalVelocityTrajectory.checkPreconditions(v0, vF, vMax, aMax);
        if (Math.abs(v0) > vMax) {
            vMax = Math.abs(v0) + 1.0E-7;
        }
        if (Math.abs(vF) > vMax) {
            vF = (vMax - 1.0E-7) * Math.signum(vF);
        }
        this.t0 = t0;
        this.x0 = x0;
        this.v0 = v0;
        this.vMax = vMax;
        double a = xF - x0 > 0.0 ? aMax : -aMax;
        if (Math.abs(v0 + a * (dT1 = -v0 / a + Math.sqrt(v0 / a * (v0 / a) + v0 * (vF - v0) / (a * a) + (xF - x0) / a + (vF - v0) * (vF - v0) / (2.0 * a * a)))) > vMax) {
            dT1 = (vMax * Math.signum(a) - v0) / a;
        }
        double dTF = (xF - x0 + a * dT1 * dT1 - (vF - v0) * dT1 + (vF - v0) * (vF - v0) / (2.0 * a)) / (a * dT1 + v0);
        if (a * dT1 + v0 == 0.0) {
            dTF = dT1;
        }
        double dT2 = dTF - dT1 + (vF - v0) / a;
        if (dT1 < -1.0E-7 || dTF < dT2 - 1.0E-7) {
            if (enforceFinalVelocity) {
                a = xF - x0 > 0.0 ? -aMax : aMax;
                if (Math.abs(v0 + a * (dT1 = -v0 / a + Math.sqrt(v0 / a * (v0 / a) + v0 * (vF - v0) / (a * a) + (xF - x0) / a + (vF - v0) * (vF - v0) / (2.0 * a * a)))) > vMax) {
                    dT1 = (vMax * Math.signum(a) - v0) / a;
                }
                if (Double.isNaN(dTF = (xF - x0 + a * dT1 * dT1 - (vF - v0) * dT1 + (vF - v0) * (vF - v0) / (2.0 * a)) / (a * dT1 + v0))) {
                    dTF = dT1;
                }
                dT2 = dTF - dT1 + (vF - v0) / a;
            } else {
                a = xF > x0 && v0 > vF ? -aMax : aMax;
                if (Math.abs(v0 + a * (dT1 = (-v0 + Math.sqrt(v0 * v0 - 2.0 * a * (x0 - xF))) / a)) > vMax && Math.abs(v0 + (a = xF > x0 ? -aMax : aMax) * (dT1 = (-v0 + Math.sqrt(v0 * v0 - 2.0 * a * (x0 - xF))) / a)) > vMax) {
                    System.err.println("Should never get here: t0=" + t0 + ", x0=" + x0 + ", xF=" + xF + ", v0=" + v0 + ", vF=" + vF + ", vMax=" + vMax + " aMax=" + aMax + ", enforceFinalVelocity=" + enforceFinalVelocity);
                    throw new RuntimeException("Should never get here");
                }
                dT2 = dT1;
                dTF = dT1;
            }
        }
        this.dT1 = dT1;
        this.dT2 = dT2;
        this.dTF = dTF;
        this.a = a;
        if (Double.isNaN(dT1) || Double.isNaN(dT2) || Double.isNaN(dTF)) {
            System.err.println("Time contain NaN: t0=" + t0 + ", x0=" + x0 + ", xF=" + xF + ", v0=" + v0 + ", vF=" + vF + ", vMax=" + vMax + " aMax=" + aMax + ", enforceFinalVelocity=" + enforceFinalVelocity);
            throw new RuntimeException("Times contain NaN. \ndT1 = " + dT1 + ", dT2 = " + dT2 + ", dTF = " + dTF);
        }
    }

    public double getPosition(double t) {
        double dT = t - this.t0;
        double x = dT < 0.0 ? this.x0 : (dT < this.dT1 ? 0.5 * this.a * dT * dT + this.v0 * dT + this.x0 : (dT < this.dT2 ? this.a * (-0.5 * this.dT1 * this.dT1 + dT * this.dT1) + this.v0 * dT + this.x0 : (dT < this.dTF ? this.a * (-0.5 * (dT * dT + this.dT1 * this.dT1 + this.dT2 * this.dT2) + dT * (this.dT1 + this.dT2)) + this.v0 * dT + this.x0 : this.a * (-0.5 * (this.dTF * this.dTF + this.dT1 * this.dT1 + this.dT2 * this.dT2) + this.dTF * (this.dT1 + this.dT2)) + this.v0 * this.dTF + this.x0)));
        return x;
    }

    public double getVelocity(double t) {
        double dT = t - this.t0;
        if (dT < -1.0E-6) {
            throw new RuntimeException("Time out of range, time=" + t);
        }
        double v = dT < this.dT1 ? this.a * dT + this.v0 : (dT < this.dT2 ? this.a * this.dT1 + this.v0 : (dT < this.dTF ? this.a * (this.dT1 + this.dT2 - dT) + this.v0 : this.a * (this.dT1 + this.dT2 - this.dTF) + this.v0));
        double epsilonVelocityLimit = 1.0E-7;
        if (Math.abs(v) > this.vMax + epsilonVelocityLimit) {
            throw new RuntimeException("Velocity limit exceeded. v = " + v + ", vMax = " + this.vMax);
        }
        return v;
    }

    public double getAcceleration(double t) {
        double dT = t - this.t0;
        if (dT < 0.0) {
            throw new RuntimeException("Time out of range");
        }
        double a = dT < this.dT1 ? this.a : (dT < this.dT2 ? 0.0 : (dT < this.dTF ? -this.a : 0.0));
        return a;
    }

    public double[] getState(double t) {
        return new double[]{this.getPosition(t), this.getVelocity(t)};
    }

    public double getDT1() {
        return this.dT1;
    }

    public double getDT2() {
        return this.dT2;
    }

    public double getMoveDuration() {
        return this.dTF;
    }

    public double getMaximumVelocity() {
        return this.vMax;
    }

    public double getMaximumAcceleration() {
        return Math.abs(this.a);
    }

    public double getT0() {
        return this.t0;
    }

    public double getT1() {
        return this.t0 + this.dT1;
    }

    public double getT2() {
        return this.t0 + this.dT2;
    }

    public double getFinalTime() {
        return this.t0 + this.dTF;
    }

    public double getX0() {
        return this.x0;
    }

    public double getV0() {
        return this.v0;
    }

    public double getVMax() {
        return this.vMax;
    }

    public double getAMax() {
        return Math.abs(this.a);
    }

    public double getEpsilon() {
        return 1.0E-7;
    }

    public static double getTFMax(TrapezoidalVelocityTrajectory[] trajectories) {
        double tFMax = Double.NEGATIVE_INFINITY;
        for (TrapezoidalVelocityTrajectory trajectory : trajectories) {
            double tF = trajectory.getFinalTime();
            if (!(tF > tFMax)) continue;
            tFMax = tF;
        }
        return tFMax;
    }

    private static void checkPreconditions(double v0, double vF, double vMax, double aMax) {
        if (Double.isNaN(vMax)) {
            throw new RuntimeException("Double.isNaN(vMax)");
        }
        if (Double.isNaN(aMax)) {
            throw new RuntimeException("Double.isNaN(aMax)");
        }
        if (Double.isNaN(v0)) {
            throw new RuntimeException("Double.isNaN(v0)");
        }
        if (Double.isNaN(vF)) {
            throw new RuntimeException("Double.isNaN(vF)");
        }
        double epsilonInitialVelocityCheck = 1.0E-7;
        if (Math.abs(v0) - vMax < epsilonInitialVelocityCheck) {
            // empty if block
        }
        v0 = vMax * Math.signum(v0);
        if (vMax < 0.0) {
            throw new RuntimeException("vMax < 0.0");
        }
        if (aMax < 0.0) {
            throw new RuntimeException("aMax < 0.0");
        }
        if (Math.abs(v0) > vMax) {
            throw new RuntimeException("v0 > vMax. v0 = " + v0 + ", vMax = " + vMax);
        }
        if (Math.abs(vF) > vMax) {
            throw new RuntimeException("vF > vMax. vF = " + vF + ", vMax = " + vMax);
        }
    }

    public String toString() {
        return "t0 = " + this.t0 + "\ndT1 = " + this.dT1 + "\ndT2 = " + this.dT2 + "\ndTF = " + this.dTF + "\nx0 = " + this.x0 + "\nv0 = " + this.v0 + "\nvMax = " + this.vMax + "\na = " + this.a + "\nepsilon = " + 1.0E-7 + "\n";
    }

    public static void findErrorConditions() {
        double maxInitialVelocity = 0.2;
        double velocityStep = 0.001;
        double maxEndVelocity = 0.15;
        double maxAcceleration = maxInitialVelocity * 5.0;
        double accelerationStep = maxAcceleration / 20.0;
        double maxMoveDistance = 0.2;
        double moveDistanceStep = 0.005;
        int counter = 0;
        for (double initialVelocity = 0.0; initialVelocity < maxInitialVelocity; initialVelocity += velocityStep) {
            for (double endVelocity = 0.0; endVelocity < maxEndVelocity; endVelocity += velocityStep) {
                for (double acceleration = maxAcceleration; acceleration > 0.1 * maxAcceleration; acceleration -= accelerationStep) {
                    for (double moveDistance = 0.001; moveDistance < maxMoveDistance; moveDistance += moveDistanceStep) {
                        try {
                            TrapezoidalVelocityTrajectory trapezoidalVelocityTrajectory = new TrapezoidalVelocityTrajectory(0.0, 0.0, moveDistance, initialVelocity, endVelocity, maxInitialVelocity, acceleration, false);
                            boolean checkSolution = true;
                            if (checkSolution) {
                                double endSpeed;
                                double endPosition;
                                double endTime = trapezoidalVelocityTrajectory.getFinalTime();
                                if (endTime < 0.0) {
                                    System.err.println("endTime < 0.0: t0=0.0, x0=0.0, xF=" + moveDistance + ", v0=" + initialVelocity + ", vF=" + endVelocity + ", vMax=" + maxInitialVelocity + " aMax=" + acceleration + ", enforceFinalVelocity=" + false);
                                }
                                if (Math.abs((endPosition = trapezoidalVelocityTrajectory.getPosition(endTime)) - moveDistance) > 0.01 * moveDistance) {
                                    double moveDistanceError = Math.abs(endPosition - moveDistance);
                                    System.err.println("moveDistanceError=" + moveDistanceError + ", : t0=" + 0.0 + ", x0=" + 0.0 + ", xF=" + moveDistance + ", v0=" + initialVelocity + ", vF=" + endVelocity + ", vMax=" + maxInitialVelocity + " aMax=" + acceleration + ", enforceFinalVelocity=" + false);
                                }
                                if ((endSpeed = trapezoidalVelocityTrajectory.getVelocity(endTime)) < -1.0E-6 || endSpeed > maxInitialVelocity) {
                                    System.err.println("endSpeed=" + endSpeed + ", : t0=" + 0.0 + ", x0=" + 0.0 + ", xF=" + moveDistance + ", v0=" + initialVelocity + ", vF=" + endVelocity + ", vMax=" + maxInitialVelocity + " aMax=" + acceleration + ", enforceFinalVelocity=" + false);
                                }
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                        ++counter;
                    }
                }
            }
        }
        System.out.println("Done ");
        System.exit(-1);
    }

    public static void testZeroMoveCase() {
        double t0 = 0.0;
        double x0 = 0.0;
        double xF = 0.0;
        double v0 = 0.0;
        double vF = 0.0;
        double vMax = 1.0;
        double aMax = 1.0;
        TrapezoidalVelocityTrajectory trapezoidalVelocityTrajectory = new TrapezoidalVelocityTrajectory(t0, x0, xF, v0, vF, vMax, aMax);
        double endTime = trapezoidalVelocityTrajectory.getFinalTime();
        System.out.println("Move time = " + endTime);
    }

    public static void testBadCase() {
        double t0 = 0.0;
        double x0 = 0.0;
        double xF = 0.053;
        double v0 = 0.107;
        double vF = 0.0;
        double vMax = 0.2;
        double aMax = 0.4;
        boolean enforceFinalVelocity = false;
        double minDistance = v0 * v0 / (2.0 * aMax);
        if (minDistance < xF) {
            System.err.println("The move distance is too small. MinDistance to stop in time=" + minDistance);
        }
        TrapezoidalVelocityTrajectory trapezoidalVelocityTrajectory = new TrapezoidalVelocityTrajectory(t0, x0, xF, v0, vF, vMax, aMax, enforceFinalVelocity);
        double endTime = trapezoidalVelocityTrajectory.getFinalTime();
        double deltaT = 0.01;
        ArrayList<Double> timeArray = new ArrayList<Double>();
        ArrayList<Double> positionArray = new ArrayList<Double>();
        ArrayList<Double> velocityArray = new ArrayList<Double>();
        for (double time = t0; time <= endTime; time += deltaT) {
            timeArray.add(time);
            double position = trapezoidalVelocityTrajectory.getPosition(time);
            positionArray.add(position);
            velocityArray.add(trapezoidalVelocityTrajectory.getVelocity(time));
        }
        System.out.println("Done ");
    }

    public static void main(String[] args) {
        TrapezoidalVelocityTrajectory.testZeroMoveCase();
    }
}

