/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

@Deprecated
public class MinimumJerkTrajectory {
    private double C0;
    private double C1;
    private double C2;
    private double C3;
    private double C4;
    private double C5;
    private double moveDuration;
    private double timeInMove;
    private double position;
    private double velocity;
    private double acceleration;
    private boolean moveInitialized = false;

    public double getPosition() {
        return this.position;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getAcceleration() {
        return this.acceleration;
    }

    public double getMoveDuration() {
        return this.moveDuration;
    }

    public double getTimeInMove() {
        return this.timeInMove;
    }

    public void setMoveParameters(double X0, double Xf, double moveDuration) {
        this.setMoveParameters(X0, 0.0, 0.0, Xf, 0.0, 0.0, moveDuration);
    }

    public void setMoveParameters(double X0, double V0, double Xf, double Vf, double moveDuration) {
        this.setMoveParameters(X0, V0, 0.0, Xf, Vf, 0.0, moveDuration);
    }

    public void setMoveParameters(double X0, double V0, double A0, double Xf, double Vf, double Af, double moveDuration) {
        if (moveDuration <= 0.0) {
            throw new RuntimeException("move Duration must be greater than 0.0");
        }
        this.moveDuration = moveDuration;
        double DT = moveDuration;
        double DT2 = DT * DT;
        this.C0 = 1.0 * X0;
        this.C1 = 1.0 * V0 * DT;
        this.C2 = 0.5 * A0 * DT2;
        this.C3 = -10.0 * X0 - 6.0 * V0 * DT - 1.5 * A0 * DT2 + 10.0 * Xf - 4.0 * Vf * DT + 0.5 * Af * DT2;
        this.C4 = 15.0 * X0 + 8.0 * V0 * DT + 1.5 * A0 * DT2 - 15.0 * Xf + 7.0 * Vf * DT - 1.0 * Af * DT2;
        this.C5 = -6.0 * X0 - 3.0 * V0 * DT - 0.5 * A0 * DT2 + 6.0 * Xf - 3.0 * Vf * DT + 0.5 * Af * DT2;
        this.timeInMove = 0.0;
        this.moveInitialized = true;
    }

    public void computeTrajectory(double timeInMove) {
        if (!this.moveInitialized) {
            throw new RuntimeException("move must be initialized before computing trajectory");
        }
        if (timeInMove < 0.0) {
            timeInMove = 0.0;
        } else if (timeInMove > this.moveDuration) {
            timeInMove = this.moveDuration;
        }
        double DT = this.moveDuration;
        double DT2 = DT * DT;
        double tau = DT > 0.0 ? timeInMove / this.moveDuration : 0.0;
        double tau2 = tau * tau;
        double tau3 = tau * tau2;
        double tau4 = tau * tau3;
        double tau5 = tau * tau4;
        this.position = this.C0 + this.C1 * tau + this.C2 * tau2 + this.C3 * tau3 + this.C4 * tau4 + this.C5 * tau5;
        this.velocity = (this.C1 + 2.0 * this.C2 * tau + 3.0 * this.C3 * tau2 + 4.0 * this.C4 * tau3 + 5.0 * this.C5 * tau4) / DT;
        this.acceleration = (2.0 * this.C2 + 6.0 * this.C3 * tau + 12.0 * this.C4 * tau2 + 20.0 * this.C5 * tau3) / DT2;
        this.timeInMove = timeInMove;
    }
}

