/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.trajectories;

import java.util.ArrayList;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.robotics.trajectories.LinearInterpolater;

public class ListOfPointsTrajectory {
    private ArrayList<FramePoint3D> listOfPoints;
    private double lengthOfPath;
    private LinearInterpolater linearInterpolater;
    private double[] alpha;

    public ListOfPointsTrajectory(ArrayList<FramePoint3D> listOfPointsForSegment) {
        if (listOfPointsForSegment == null || listOfPointsForSegment.size() < 2) {
            throw new RuntimeException("listOfPoints must have at least 2 elements.");
        }
        this.listOfPoints = new ArrayList();
        this.listOfPoints.add(new FramePoint3D((FrameTuple3DReadOnly)listOfPointsForSegment.get(0)));
        for (int i = 1; i < listOfPointsForSegment.size(); ++i) {
            double distanceToPreviousPoint = listOfPointsForSegment.get(i).distance((FramePoint3DReadOnly)listOfPointsForSegment.get(i - 1));
            if (!(distanceToPreviousPoint > 0.0)) continue;
            this.listOfPoints.add(new FramePoint3D((FrameTuple3DReadOnly)listOfPointsForSegment.get(i)));
        }
        this.setupAlphaArrayAndLinearInterpolator();
    }

    public static ListOfPointsTrajectory createListOfPointsTrajectory(ArrayList<Point2D> points, ReferenceFrame referenceFrame) {
        ArrayList<FramePoint3D> framePoints = new ArrayList<FramePoint3D>(points.size());
        for (Point2D point : points) {
            FramePoint3D framePoint = new FramePoint3D(referenceFrame, point.getX(), point.getY(), 0.0);
            framePoints.add(framePoint);
        }
        return new ListOfPointsTrajectory(framePoints);
    }

    private void setupAlphaArrayAndLinearInterpolator() {
        int numberOfPoints = this.listOfPoints.size();
        this.alpha = new double[numberOfPoints];
        double[] index = new double[numberOfPoints];
        double[] distanceOnPath = this.calculateLengthOfPath(this.listOfPoints);
        this.lengthOfPath = distanceOnPath[distanceOnPath.length - 1];
        if (numberOfPoints > 1 && this.lengthOfPath == 0.0) {
            throw new RuntimeException("If more than one point, the length of the path must be greater than zero");
        }
        this.alpha[0] = 0.0;
        index[0] = 0.0;
        for (int i = 1; i < numberOfPoints; ++i) {
            this.alpha[i] = distanceOnPath[i] / this.lengthOfPath;
            index[i] = i;
        }
        try {
            this.linearInterpolater = new LinearInterpolater(this.alpha, index);
        }
        catch (Exception ex) {
            this.linearInterpolater = null;
        }
    }

    public ListOfPointsTrajectory(ListOfPointsTrajectory listOfPointsTrajectory) {
        this(listOfPointsTrajectory.getOriginalList());
    }

    public double getPathLength() {
        return this.lengthOfPath;
    }

    public double getAlphaGivenIndexInOriginalList(int index) {
        if (index > this.alpha.length - 1) {
            index = this.alpha.length - 1;
        }
        return this.alpha[index];
    }

    public int getSizeOfInternalList() {
        return this.listOfPoints.size();
    }

    public ArrayList<FramePoint3D> getOriginalList() {
        return new ArrayList<FramePoint3D>(this.listOfPoints);
    }

    public ArrayList<FramePointAndAlpha> getOriginalListAndAlphas() {
        ArrayList<FramePointAndAlpha> ret = new ArrayList<FramePointAndAlpha>();
        for (int i = 0; i < this.listOfPoints.size(); ++i) {
            ret.add(new FramePointAndAlpha(this.listOfPoints.get(i), this.alpha[i]));
        }
        return ret;
    }

    private double[] calculateLengthOfPath(ArrayList<FramePoint3D> pointsOnPath) {
        double[] distanceOnPath = new double[pointsOnPath.size()];
        distanceOnPath[0] = 0.0;
        for (int i = 1; i < pointsOnPath.size(); ++i) {
            distanceOnPath[i] = distanceOnPath[i - 1] + pointsOnPath.get(i).distance((FramePoint3DReadOnly)pointsOnPath.get(i - 1));
        }
        return distanceOnPath;
    }

    public double getAlpha(FramePoint3D pointToCheck) {
        double minimumDistance = Double.POSITIVE_INFINITY;
        double alphaToReturn = 1.0;
        double deltaAlpha = 0.01;
        for (double alpha = 0.0; alpha <= 1.0 + deltaAlpha / 2.0; alpha += deltaAlpha) {
            FramePoint3D testPoint;
            double distance;
            if (alpha > 1.0) {
                alpha = 1.0;
            }
            if (!((distance = (testPoint = this.getPointOnPath(alpha)).distance((FramePoint3DReadOnly)pointToCheck)) < minimumDistance)) continue;
            minimumDistance = distance;
            alphaToReturn = alpha;
        }
        return alphaToReturn;
    }

    public int getIndexOfClosestPoint(FramePoint3D pointToCheck) {
        double alpha = this.getAlpha(pointToCheck);
        return (int)Math.round(this.getIndexOfClosestAlpha(alpha));
    }

    public double getIndexOfClosestAlpha(double alpha) {
        double index = this.linearInterpolater != null ? this.linearInterpolater.getPoint(alpha) : 0.0;
        if (index > (double)(this.listOfPoints.size() - 1)) {
            index = this.listOfPoints.size() - 1;
        }
        if (index < 0.0) {
            index = 0.0;
        }
        return index;
    }

    public FramePoint3D getPointOnPath(double alpha) {
        return this.getPointOnPath(alpha, false);
    }

    public FramePoint3D getPointOnPathAndAddToInternalList(double alpha) {
        return this.getPointOnPath(alpha, true);
    }

    private FramePoint3D getPointOnPath(double alpha, boolean addToInternalRepresentation) {
        if (alpha < 0.0) {
            alpha = 0.0;
        }
        if (alpha > 1.0) {
            alpha = 1.0;
        }
        double indexDouble = this.linearInterpolater != null ? this.linearInterpolater.getPoint(alpha) : 0.0;
        int indexBefore = (int)Math.floor(indexDouble);
        int indexAfter = (int)Math.ceil(indexDouble);
        double fractionBetweenPoints = indexDouble - (double)indexBefore;
        FramePoint3D beforePoint = new FramePoint3D((FrameTuple3DReadOnly)this.listOfPoints.get(indexBefore));
        FramePoint3D afterPoint = new FramePoint3D((FrameTuple3DReadOnly)this.listOfPoints.get(indexAfter));
        FrameVector3D vectorBetweenPoints = new FrameVector3D(beforePoint.getReferenceFrame());
        vectorBetweenPoints.sub((FrameTuple3DReadOnly)afterPoint, (FrameTuple3DReadOnly)beforePoint);
        if (fractionBetweenPoints == 0.0) {
            vectorBetweenPoints.set(0.0, 0.0, 0.0);
        } else {
            vectorBetweenPoints.scale(fractionBetweenPoints);
        }
        FramePoint3D returnPoint = new FramePoint3D((FrameTuple3DReadOnly)beforePoint);
        returnPoint.add((FrameTuple3DReadOnly)vectorBetweenPoints);
        if (addToInternalRepresentation && beforePoint.distance((FramePoint3DReadOnly)returnPoint) > 1.0E-7 && afterPoint.distance((FramePoint3DReadOnly)returnPoint) > 1.0E-7) {
            int i;
            ArrayList<FramePoint3D> newListOfPoints = new ArrayList<FramePoint3D>();
            for (i = 0; i <= indexBefore; ++i) {
                newListOfPoints.add(this.listOfPoints.get(i));
            }
            newListOfPoints.add(returnPoint);
            for (i = indexAfter; i < this.listOfPoints.size(); ++i) {
                newListOfPoints.add(this.listOfPoints.get(i));
            }
            this.listOfPoints = newListOfPoints;
            this.setupAlphaArrayAndLinearInterpolator();
        }
        return returnPoint;
    }

    public FramePoint3D getPointOnPathDistanceFromStart(double distanceFromStart) {
        double pathLength = this.getPathLength();
        if (pathLength < 1.0E-12) {
            return this.listOfPoints.get(0);
        }
        double alpha = distanceFromStart / pathLength;
        return this.getPointOnPath(alpha);
    }

    public FramePoint3D getPointOnPathDistanceFromStartAndAddToInternalList(double distanceFromStart) {
        double pathLength = this.getPathLength();
        if (pathLength < 1.0E-12) {
            return this.listOfPoints.get(0);
        }
        double alpha = distanceFromStart / pathLength;
        return this.getPointOnPathAndAddToInternalList(alpha);
    }

    public static ArrayList<FramePoint3D> expandList(ArrayList<FramePoint3D> listOfPoints, int numberOfPoints) {
        ListOfPointsTrajectory listOfPointsTrajectory = new ListOfPointsTrajectory(listOfPoints);
        double percentStepSize = 1.0 / ((double)numberOfPoints - 1.0);
        ArrayList<FramePoint3D> ret = new ArrayList<FramePoint3D>();
        for (double alpha = 0.0; alpha <= 1.0; alpha += percentStepSize) {
            ret.add(listOfPointsTrajectory.getPointOnPath(alpha));
        }
        return ret;
    }

    public static void main(String[] args) {
        ArrayList<FramePoint3D> list = new ArrayList<FramePoint3D>();
        ReferenceFrame referenceFrame = ReferenceFrame.getWorldFrame();
        FramePoint3D framePoint = new FramePoint3D(referenceFrame, 0.0, 0.0, 0.0);
        list.add(framePoint);
        ListOfPointsTrajectory listOfPointsTrajectory = null;
        try {
            listOfPointsTrajectory = new ListOfPointsTrajectory(list);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (double alpha = 0.0; alpha <= 1.0; alpha += 0.1) {
            FramePoint3D testPoint = listOfPointsTrajectory.getPointOnPath(alpha);
            System.out.println("testPoint=" + testPoint);
        }
    }

    public class FramePointAndAlpha {
        private final FramePoint3D framePoint;
        private final double alpha;

        FramePointAndAlpha(FramePoint3D framePoint, double alpha) {
            this.framePoint = framePoint;
            this.alpha = alpha;
        }

        public FramePoint3D getFramePoint() {
            return this.framePoint;
        }

        public double getAlpha() {
            return this.alpha;
        }
    }
}

