/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import us.ihmc.commons.Conversions;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class ThreadTimer {
    private static final int REALTIME_RATE_SAMPLES = 100;
    private final long expectedDTNanos;
    private final YoLong tick;
    private final YoDouble dt;
    private final YoDouble timer;
    private final YoLong jitter;
    private final YoDouble realtimeRate;
    private final YoDouble elapsedSystemTime;
    private long lastStartTime;
    private long realtimeRateCounter;
    private long systemInitialTime;

    public ThreadTimer(String name, double expectedDt, YoRegistry registry) {
        this.expectedDTNanos = Conversions.secondsToNanoseconds((double)expectedDt);
        this.tick = new YoLong(name + "Tick", registry);
        this.dt = new YoDouble(name + "DT", registry);
        this.timer = new YoDouble(name + "Timer", registry);
        this.jitter = new YoLong(name + "JitterInNanos", registry);
        this.realtimeRate = new YoDouble(name + "RealtimeRate", registry);
        this.elapsedSystemTime = new YoDouble(name + "ElapsedSystemTime", registry);
        this.tick.set(-1L);
    }

    public ThreadTimer(String name, YoRegistry registry) {
        this.expectedDTNanos = 0L;
        this.jitter = null;
        this.realtimeRate = null;
        this.elapsedSystemTime = null;
        this.tick = new YoLong(name + "Tick", registry);
        this.dt = new YoDouble(name + "DT", registry);
        this.timer = new YoDouble(name + "Timer", registry);
        this.tick.set(-1L);
    }

    public void start() {
        long startTime = System.nanoTime();
        this.computeClockBasedRealtimeRate(startTime);
        if (this.lastStartTime != 0L) {
            this.computeJitter(startTime);
            double dtInNanos = startTime - this.lastStartTime;
            this.dt.set(Conversions.nanosecondsToMilliseconds((double)dtInNanos));
        }
        this.lastStartTime = startTime;
        this.tick.increment();
    }

    private void computeClockBasedRealtimeRate(long startTime) {
        if (this.realtimeRateCounter == 0L) {
            if (this.systemInitialTime != 0L && this.elapsedSystemTime != null) {
                this.elapsedSystemTime.set(Conversions.nanosecondsToSeconds((long)(startTime - this.systemInitialTime)));
                this.realtimeRate.set(Conversions.nanosecondsToSeconds((long)(100L * this.expectedDTNanos)) / this.elapsedSystemTime.getValue());
            }
            this.realtimeRateCounter = 100L;
            this.systemInitialTime = startTime;
        }
        --this.realtimeRateCounter;
    }

    private void computeJitter(long startTime) {
        if (this.jitter == null) {
            return;
        }
        long delta = startTime - this.lastStartTime - this.expectedDTNanos;
        if (delta < 0L) {
            delta = -delta;
        }
        this.jitter.add((delta - this.jitter.getValue()) / 16L);
    }

    public long getTickCount() {
        return this.tick.getValue();
    }

    public void stop() {
        this.timer.set(Conversions.nanosecondsToMilliseconds((double)(System.nanoTime() - this.lastStartTime)));
    }

    public void clear() {
        this.tick.set(0L);
        this.dt.set(0.0);
        this.timer.set(0.0);
        this.jitter.set(0L);
        this.realtimeRate.set(0.0);
        this.elapsedSystemTime.set(0.0);
        this.lastStartTime = 0L;
        this.realtimeRateCounter = 0L;
        this.systemInitialTime = 0L;
    }
}

