/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import us.ihmc.commons.Conversions;
import us.ihmc.commons.MathTools;
import us.ihmc.robotics.math.filters.SimpleMovingAverageFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoLong;

public class ExecutionTimer {
    private final long measurementDelay;
    private long timeOfFirstMeasurement = Long.MAX_VALUE;
    private final YoDouble current;
    private final YoDouble average;
    private final YoDouble standardDeviation;
    private final YoDouble maximum;
    private final SimpleMovingAverageFilteredYoVariable movingAverage;
    private final YoLong count;
    private long startTime;

    public ExecutionTimer(String name, YoRegistry registry) {
        this(name, 0.0, registry);
    }

    public ExecutionTimer(String name, double measurementDelayInSeconds, YoRegistry registry) {
        this.measurementDelay = Conversions.secondsToNanoseconds((double)measurementDelayInSeconds);
        this.current = new YoDouble(name + "Current", registry);
        this.average = new YoDouble(name + "Average", registry);
        this.movingAverage = new SimpleMovingAverageFilteredYoVariable(name + "MovingAverage", 100, this.current, registry);
        this.standardDeviation = new YoDouble(name + "StandardDeviation", registry);
        this.maximum = new YoDouble(name + "Maximum", registry);
        this.count = new YoLong(name + "Count", registry);
    }

    public void startMeasurement() {
        this.startTime = System.nanoTime();
        if (this.timeOfFirstMeasurement == Long.MAX_VALUE) {
            this.timeOfFirstMeasurement = this.startTime;
        }
    }

    public void stopMeasurement() {
        long currentNanoTime = System.nanoTime();
        if (currentNanoTime - this.timeOfFirstMeasurement > this.measurementDelay) {
            double timeTaken = Conversions.nanosecondsToSeconds((long)(currentNanoTime - this.startTime));
            double previousAverage = this.average.getDoubleValue();
            double previousSumOfSquares = MathTools.square((double)this.standardDeviation.getDoubleValue()) * (double)this.count.getLongValue();
            this.count.increment();
            this.current.set(timeTaken);
            this.average.set(previousAverage + (timeTaken - previousAverage) / (double)this.count.getLongValue());
            this.movingAverage.update();
            double sumOfSquares = previousSumOfSquares + (timeTaken - previousAverage) * (timeTaken - this.average.getDoubleValue());
            this.standardDeviation.set(Math.sqrt(sumOfSquares / (double)this.count.getLongValue()));
            if (timeTaken > this.maximum.getDoubleValue()) {
                this.maximum.set(timeTaken);
            }
        }
    }

    public YoDouble getCurrentTime() {
        return this.current;
    }

    public YoDouble getAverageTime() {
        return this.average;
    }

    public YoDouble getMovingAverage() {
        return this.movingAverage;
    }

    public YoDouble getStandardDeviation() {
        return this.standardDeviation;
    }

    public YoDouble getMaxTime() {
        return this.maximum;
    }
}

