/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class CallFrequencyCalculator {
    private YoDouble yoCallFrequency;
    private YoDouble yoRequestDeltaTInMilliseconds;
    private int counter;
    private double lastTimeCalled = 0.0;
    private double currentTime = 0.0;
    private int numberOfSamples = 10;
    private double frequencyAddition = 0.0;

    public CallFrequencyCalculator(YoRegistry registry, String prefix) {
        this.yoCallFrequency = new YoDouble(prefix + "_Freq", registry);
        this.yoRequestDeltaTInMilliseconds = new YoDouble(prefix + "_DeltaT", registry);
    }

    public void setNumberOfSamples(int numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public double determineCallFrequency() {
        this.currentTime = System.nanoTime();
        double frequency = 1.0 / ((this.currentTime - this.lastTimeCalled) / 1.0E9);
        this.yoRequestDeltaTInMilliseconds.set((this.currentTime - this.lastTimeCalled) / 1000000.0);
        this.frequencyAddition += frequency;
        this.lastTimeCalled = this.currentTime;
        if (this.counter > this.numberOfSamples) {
            this.yoCallFrequency.set(this.frequencyAddition / (double)this.counter);
            this.counter = 1;
            this.frequencyAddition = 0.0;
        } else {
            ++this.counter;
        }
        return this.yoCallFrequency.getDoubleValue();
    }
}

