/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.factories;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import us.ihmc.commons.PrintTools;
import us.ihmc.robotics.stateMachine.core.StateChangedListener;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.core.StateMachineClock;
import us.ihmc.robotics.stateMachine.core.StateTransition;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;
import us.ihmc.robotics.stateMachine.extra.EventState;
import us.ihmc.robotics.stateMachine.extra.EventTrigger;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoVariable;

public class EventBasedStateMachineFactory<K extends Enum<K>, S extends EventState> {
    private String namePrefix;
    private YoRegistry registry;
    private final Map<K, S> states;
    private final Map<K, StateTransition<K>> stateTransitions;
    private final Map<K, StateEventCallback> stateCallbacks;
    private final StateEventTriggers<K> stateEventTriggers;
    private final List<StateChangedListener<K>> stateChangedListeners = new ArrayList<StateChangedListener<K>>();
    private final AtomicReference<Object> eventFired = new AtomicReference<Object>(null);
    private StateMachine<K, S> stateMachine;
    private StateMachineClock clock = StateMachineClock.dummyClock();
    private final Class<K> keyType;

    public EventBasedStateMachineFactory(Class<K> keyType) {
        this.keyType = keyType;
        this.states = new EnumMap<K, S>(keyType);
        this.stateTransitions = new EnumMap<K, StateTransition<K>>(keyType);
        this.stateCallbacks = new EnumMap<K, StateEventCallback>(keyType);
        this.stateEventTriggers = new StateEventTriggers<K>(keyType);
    }

    public EventBasedStateMachineFactory<K, S> setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
        return this;
    }

    public EventBasedStateMachineFactory<K, S> setRegistry(YoRegistry registry) {
        this.registry = registry;
        return this;
    }

    public EventBasedStateMachineFactory<K, S> buildClock(DoubleProvider timeProvider) {
        this.clock = StateMachineClock.clock(timeProvider);
        return this;
    }

    public EventBasedStateMachineFactory<K, S> buildYoClock(DoubleProvider timeProvider) {
        if (this.namePrefix == null || this.registry == null) {
            throw new RuntimeException("The namePrefix and registry fields have to be set in order to create yo-variables.");
        }
        this.clock = StateMachineClock.yoClock(timeProvider, this.namePrefix, this.registry);
        return this;
    }

    public EventBasedStateMachineFactory<K, S> addState(K key, S state) {
        EventState oldState = (EventState)this.states.put(key, state);
        if (oldState != null) {
            PrintTools.warn((String)("The state " + oldState.getClass().getSimpleName() + " at the key " + key + " has been replaced with " + state.getClass().getSimpleName()));
        }
        this.stateEventTriggers.addState(key, (EventState)state);
        return this;
    }

    public boolean isStateRegistered(K stateKey) {
        return this.states.containsKey(stateKey);
    }

    public Set<K> getRegisteredStateKeys() {
        return this.states.keySet();
    }

    public <E extends Enum<E>> EventBasedStateMachineFactory<K, S> addTransition(E event, K from, K to) {
        this.addTransition(from, to, time -> this.eventFired.get() == event);
        return this;
    }

    public <E extends Enum<E>> EventBasedStateMachineFactory<K, S> addCallback(E event, K stateKey, Runnable callback) {
        StateEventCallback callbacks = this.stateCallbacks.get(stateKey);
        if (callbacks == null) {
            callbacks = new StateEventCallback();
            this.stateCallbacks.put(stateKey, callbacks);
        }
        callbacks.registerCallback(event, callback);
        return this;
    }

    private EventBasedStateMachineFactory<K, S> addTransition(K from, K to, StateTransitionCondition condition) {
        StateTransition<K> stateTransition = this.stateTransitions.get(from);
        if (stateTransition == null) {
            stateTransition = new StateTransition<K>(this.keyType);
            this.stateTransitions.put(from, stateTransition);
        }
        stateTransition.addCondition(to, condition);
        return this;
    }

    public EventBasedStateMachineFactory<K, S> addStateChangedListener(StateChangedListener<K> stateChangeListener) {
        this.stateChangedListeners.add(stateChangeListener);
        return this;
    }

    public StateMachine<K, S> build(K initialStateKey) {
        this.stateMachine = new StateMachine<K, S>(initialStateKey, this.states, this.stateTransitions, this.stateChangedListeners, this.clock, this.namePrefix, this.registry);
        this.stateMachine.addPreTransitionCallback(() -> {
            Object newEvent;
            K currentStateKey = this.stateMachine.getCurrentStateKey();
            if (currentStateKey != null && (newEvent = this.stateEventTriggers.fireEvent(currentStateKey, this.stateMachine.getTimeInCurrentState())) != null && this.eventFired.get() == null) {
                this.eventFired.set(newEvent);
            }
        });
        this.stateMachine.addPreTransitionCallback(() -> {
            StateEventCallback callbacks = this.stateCallbacks.get(this.stateMachine.getCurrentStateKey());
            if (callbacks != null) {
                callbacks.processEvent(this.eventFired.get());
            }
        });
        this.stateMachine.addPostTransitionCallback(() -> this.eventFired.set(null));
        return this.stateMachine;
    }

    public EventTrigger buildEventTrigger() {
        return this.eventFired::set;
    }

    public <E extends Enum<E>> EventBasedStateMachineFactory<K, S> buildYoEventTrigger(String triggerName, Class<E> eventType) {
        if (this.registry == null) {
            throw new RuntimeException("The registry field has to be set in order to create yo-variables.");
        }
        YoEnum yoTrigger = new YoEnum(triggerName, this.registry, eventType, true);
        yoTrigger.set(null);
        return this.buildYoEventTrigger(yoTrigger);
    }

    public <E extends Enum<E>> EventBasedStateMachineFactory<K, S> buildYoEventTrigger(final YoEnum<E> yoTrigger) {
        final EventTrigger eventTrigger = this.buildEventTrigger();
        yoTrigger.addListener(new YoVariableChangedListener(){

            public void changed(YoVariable v) {
                Enum newEvent = yoTrigger.getEnumValue();
                if (newEvent != null) {
                    eventTrigger.fireEvent(yoTrigger.getEnumValue());
                    yoTrigger.set(null);
                }
            }
        });
        return this;
    }

    private static class StateEventTriggers<K extends Enum<K>> {
        private final Map<K, EventState> states;

        public StateEventTriggers(Class<K> keyType) {
            this.states = new EnumMap<K, EventState>(keyType);
        }

        public void addState(K stateKey, EventState state) {
            this.states.put(stateKey, state);
        }

        public Object fireEvent(K currentStateKey, double timeInState) {
            return this.states.get(currentStateKey).fireEvent(timeInState);
        }
    }

    private static class StateEventCallback {
        private final Map<Object, List<Runnable>> eventToCallbacksMap = new HashMap<Object, List<Runnable>>();

        private StateEventCallback() {
        }

        public void registerCallback(Object event, Runnable callback) {
            List<Runnable> callbacks = this.eventToCallbacksMap.get(event);
            if (callbacks == null) {
                callbacks = new ArrayList<Runnable>();
                this.eventToCallbacksMap.put(event, callbacks);
            }
            callbacks.add(callback);
        }

        public void processEvent(Object event) {
            List<Runnable> callbacks = this.eventToCallbacksMap.get(event);
            if (callbacks == null) {
                return;
            }
            for (int i = 0; i < callbacks.size(); ++i) {
                callbacks.get(i).run();
            }
        }
    }
}

