/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.extra;

import com.jgraph.layout.JGraphFacade;
import com.jgraph.layout.tree.JGraphTreeLayout;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.jgraph.JGraph;
import org.jgraph.graph.CellViewFactory;
import org.jgraph.graph.DefaultCellViewFactory;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphLayoutCache;
import org.jgraph.graph.GraphModel;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateChangedListener;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.core.StateTransition;

public class StateMachinesJPanel<K extends Enum<K>>
extends JPanel
implements StateChangedListener<K> {
    private static final long serialVersionUID = 2453853798153829891L;
    private final StateMachine<K, ? extends State> stateMachine;
    private boolean oldStateDiagram;
    private final Map<K, DefaultGraphCell> stateCells;
    private final Set<K> stateKeys;
    private final Map<K, State> states;
    private final Map<K, StateTransition<K>> stateTransitions;
    private final Class<K> keyType;
    private final Map<K, Set<K>> arrows;
    private JGraph graph;
    private final int numberOfStates;
    private K currentStateKey = null;
    private Dimension dimension = new Dimension();
    static final BasicStroke wideStroke = new BasicStroke(3.0f);
    private boolean initiate;
    private double tempHeight = 0.0;
    private double tempWidth = 0.0;

    public StateMachinesJPanel(StateMachine<K, ? extends State> stateMachine) {
        this(stateMachine, false);
    }

    public StateMachinesJPanel(final StateMachine<K, ? extends State> stateMachine, boolean oldStateDiagram) {
        this.stateMachine = stateMachine;
        this.currentStateKey = stateMachine.getCurrentStateKey();
        this.keyType = stateMachine.getStateKeyType();
        this.states = StateMachinesJPanel.extractActiveStates(stateMachine);
        this.stateTransitions = StateMachinesJPanel.extractActiveStateTransitions(stateMachine);
        this.stateKeys = this.states.keySet();
        this.numberOfStates = this.states.size();
        this.oldStateDiagram = oldStateDiagram;
        this.stateCells = new EnumMap<K, DefaultGraphCell>(this.keyType);
        this.arrows = new EnumMap<K, Set<K>>(this.keyType);
        if (!oldStateDiagram) {
            this.graph = new JGraph();
            this.initializeJPanel();
        }
        Thread repaintWhenStateChange = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    if (StateMachinesJPanel.this.currentStateKey == stateMachine.getCurrentStateKey()) continue;
                    StateMachinesJPanel.this.currentStateKey = stateMachine.getCurrentStateKey();
                    StateMachinesJPanel.this.updateStateMachine();
                }
            }
        }, "IHMC-StateMachinesPanelUpdater");
        repaintWhenStateChange.start();
    }

    private static <K extends Enum<K>> Map<K, StateTransition<K>> extractActiveStateTransitions(StateMachine<K, ? extends State> stateMachine) {
        Class<K> keyType = stateMachine.getStateKeyType();
        Enum[] allKeys = (Enum[])keyType.getEnumConstants();
        EnumMap<Enum, StateTransition<Enum>> states = new EnumMap<Enum, StateTransition<Enum>>(keyType);
        for (Enum key : allKeys) {
            StateTransition<Enum> state = stateMachine.getStateTransition(key);
            if (state == null) continue;
            states.put(key, state);
        }
        return states;
    }

    private static <K extends Enum<K>> Map<K, State> extractActiveStates(StateMachine<K, ? extends State> stateMachine) {
        Class<K> keyType = stateMachine.getStateKeyType();
        Enum[] allKeys = (Enum[])keyType.getEnumConstants();
        EnumMap<Enum, State> states = new EnumMap<Enum, State>(keyType);
        for (Enum key : allKeys) {
            State state = stateMachine.getState(key);
            if (state == null) continue;
            states.put(key, state);
        }
        return states;
    }

    private void updateStateMachine() {
        if (this.oldStateDiagram) {
            this.repaint();
        } else {
            K currentStateKey = this.stateMachine.getCurrentStateKey();
            DefaultGraphCell currentStateCell = this.stateCells.get(currentStateKey);
            GraphConstants.setBackground((Map)this.graph.getAttributes((Object)currentStateCell), (Color)Color.RED);
            currentStateCell.setAttributes(this.graph.getAttributes((Object)currentStateCell));
            for (Map.Entry<K, DefaultGraphCell> entry : this.stateCells.entrySet()) {
                if (entry.getKey() == currentStateKey) continue;
                DefaultGraphCell stateCell = entry.getValue();
                GraphConstants.setBackground((Map)this.graph.getAttributes((Object)stateCell), (Color)Color.CYAN);
                stateCell.setAttributes(this.graph.getAttributes((Object)stateCell));
            }
            this.graph.repaint();
            this.graph.refresh();
        }
    }

    @Override
    public void stateChanged(K oldState, K newState) {
        if (this.oldStateDiagram) {
            this.repaint();
        } else {
            if (oldState != null) {
                DefaultGraphCell oldStateCell = this.stateCells.get(oldState);
                GraphConstants.setBackground((Map)this.graph.getAttributes((Object)oldStateCell), (Color)Color.CYAN);
                oldStateCell.setAttributes(this.graph.getAttributes((Object)oldStateCell));
            }
            DefaultGraphCell newStateCell = this.stateCells.get(newState);
            GraphConstants.setBackground((Map)this.graph.getAttributes((Object)newStateCell), (Color)Color.RED);
            newStateCell.setAttributes(this.graph.getAttributes((Object)newStateCell));
            this.graph.repaint();
            this.repaint();
            this.graph.refresh();
        }
    }

    private void createArrow(K source, K target) {
        if (!this.arrowAlreadyExist(source, target)) {
            Object[] arrowCell = new DefaultGraphCell[1];
            DefaultEdge edge = new DefaultEdge();
            edge.setSource((Object)this.stateCells.get(source).getChildAt(0));
            edge.setTarget((Object)this.stateCells.get(target).getChildAt(0));
            arrowCell[0] = edge;
            int arrow = 2;
            GraphConstants.setLineEnd((Map)edge.getAttributes(), (int)arrow);
            GraphConstants.setEndFill((Map)edge.getAttributes(), (boolean)true);
            this.graph.getGraphLayoutCache().insert(arrowCell);
            Set<K> targetSet = this.arrows.get(source);
            if (targetSet == null) {
                targetSet = EnumSet.noneOf(this.keyType);
                this.arrows.put(source, targetSet);
            }
            targetSet.add(target);
        }
    }

    private boolean arrowAlreadyExist(K source, K target) {
        return this.arrows.containsKey(source) && this.arrows.get(source).contains(target);
    }

    private DefaultGraphCell createCell(K stateKey, Point2D placement) {
        String cellName = ((Enum)stateKey).toString();
        DefaultGraphCell stateCell = new DefaultGraphCell((Object)new String(cellName));
        Font font = new Font("Arial", 0, 12);
        GraphConstants.setFont((Map)stateCell.getAttributes(), (Font)font);
        GraphConstants.setAutoSize((Map)stateCell.getAttributes(), (boolean)true);
        GraphConstants.setOpaque((Map)stateCell.getAttributes(), (boolean)true);
        Color color = this.colorStateCell(stateKey);
        GraphConstants.setBackground((Map)stateCell.getAttributes(), (Color)color);
        GraphConstants.setBounds((Map)stateCell.getAttributes(), (Rectangle2D)new Rectangle2D.Double(placement.getX(), placement.getY(), 0.0, 0.0));
        stateCell.addPort();
        return stateCell;
    }

    private void createStateTransitionDiagram(K sourceStateKey) {
        StateTransition<K> parentStateTransition = this.stateTransitions.get(sourceStateKey);
        for (Enum endStateKey : parentStateTransition) {
            this.createArrow(sourceStateKey, endStateKey);
        }
    }

    private Color colorStateCell(K stateKey) {
        if (stateKey == this.stateMachine.getCurrentStateKey()) {
            return Color.RED;
        }
        return Color.CYAN;
    }

    private void initializeJPanel() {
        this.initiate = true;
        this.graph.setGraphLayoutCache(new GraphLayoutCache((GraphModel)new DefaultGraphModel(), (CellViewFactory)new DefaultCellViewFactory(), true));
        this.graph.setEditable(false);
        for (Enum key : this.stateKeys) {
            this.stateCells.put(key, this.createCell(key, new Point2D(0.0, 0.0)));
        }
        for (Enum key : this.stateKeys) {
            this.createStateTransitionDiagram(key);
        }
        this.graph.getGraphLayoutCache().insert(this.stateCells.values().toArray());
        JGraphFacade facade = new JGraphFacade(this.graph.getGraphLayoutCache());
        facade.setEdgePromotion(false);
        JGraphTreeLayout layout = new JGraphTreeLayout();
        layout.run(facade);
        Map map = facade.createNestedMap(true, true);
        this.graph.getGraphLayoutCache().edit(map);
    }

    private void oldStateMachineDiagram(Graphics graphics, double width, double height) {
        Graphics2D graphic2D = (Graphics2D)graphics;
        graphic2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphic2D.setStroke(wideStroke);
        double Ry = 0.25 * height;
        double Rx = 0.25 * width;
        double circumference = StateMachinesJPanel.approximateElipseCircumference(Rx, Ry);
        int circleRadiusBasedOnSpacing = (int)(circumference / (2.5 * (double)this.numberOfStates));
        int circleRadiusBasedOnPanelSize = (int)(0.9 * Math.min(Rx, Ry));
        int circleRadius = Math.min(circleRadiusBasedOnSpacing, circleRadiusBasedOnPanelSize);
        K currentStateKey = this.stateMachine.getCurrentStateKey();
        int stateIndex = 0;
        EnumMap<Enum, Point2D> stateCenters = new EnumMap<Enum, Point2D>(this.keyType);
        for (Enum stateKey : this.stateKeys) {
            Point2D stateCenter = new Point2D();
            if (stateKey == currentStateKey) {
                graphics.setColor(Color.RED);
            } else {
                graphic2D.setColor(Color.BLACK);
            }
            double angle = Math.PI * 2 * (double)stateIndex / (double)this.numberOfStates;
            stateCenter.setX(Rx * Math.cos(angle) + width / 2.0);
            stateCenter.setY(Ry * Math.sin(angle) + height / 2.0);
            graphic2D.draw(new Ellipse2D.Double(stateCenter.getX() - (double)circleRadius, stateCenter.getY() - (double)circleRadius, circleRadius * 2, circleRadius * 2));
            String stateString = stateKey.toString();
            graphic2D.drawString(stateString, (int)stateCenter.getX() - 8 * stateString.length() / 2, (int)stateCenter.getY());
            ++stateIndex;
            stateCenters.put(stateKey, stateCenter);
        }
        graphic2D.setColor(Color.BLACK);
        for (Enum startKey : this.stateKeys) {
            StateTransition<K> stateTransition = this.stateTransitions.get(startKey);
            for (Enum endKey : stateTransition) {
                this.stateMachine.getState(endKey);
                Vector2D direction = new Vector2D();
                Point2D startCenter = (Point2D)stateCenters.get(startKey);
                Point2D endCenter = (Point2D)stateCenters.get(endKey);
                direction.sub((Tuple2DReadOnly)endCenter, (Tuple2DReadOnly)startCenter);
                direction.normalize();
                direction.scale((double)circleRadius);
                double x1 = startCenter.getX() + direction.getX();
                double y1 = startCenter.getY() + direction.getY();
                double x2 = endCenter.getX() - direction.getX();
                double y2 = endCenter.getY() - direction.getY();
                graphic2D.draw(new Line2D.Double(x1, y1, x2, y2));
            }
        }
    }

    private void reScalingStateMachine(double width, double height) {
        if (this.initiate) {
            this.tempWidth = width;
            this.tempHeight = height;
            this.initiate = false;
        }
        if (this.tempWidth > width) {
            this.graph.setScale(this.graph.getScale() + (width - this.tempWidth) / 3000.0);
            this.tempWidth = width;
        }
        if (this.tempWidth < width) {
            this.graph.setScale(this.graph.getScale() + (width - this.tempWidth) / 3000.0);
            this.tempWidth = width;
        }
        if (this.tempHeight > height) {
            this.graph.setScale(this.graph.getScale() - (this.tempHeight - height) / 3000.0);
            this.tempHeight = height;
        }
        if (this.tempHeight < height) {
            this.graph.setScale(this.graph.getScale() + (height - this.tempHeight) / 3000.0);
            this.tempHeight = height;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.getSize(this.dimension);
        double width = this.dimension.getWidth();
        double height = this.dimension.getHeight();
        if (this.oldStateDiagram) {
            this.oldStateMachineDiagram(g, width, height);
        } else {
            this.graph.setBounds(0, 0, (int)width, (int)height);
            this.graph.setAlignmentX(0.5f);
            this.reScalingStateMachine(width, height);
            this.add((Component)this.graph);
        }
    }

    private static double approximateElipseCircumference(double a, double b) {
        double x = (a - b) / (a + b);
        return Math.PI * (a + b) * (1.0 + 3.0 * x * x / (10.0 + Math.sqrt(4.0 - 3.0 * x * x)));
    }
}

