/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.extra;

import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import us.ihmc.robotics.stateMachine.core.State;

public class MutableState
implements State {
    private Runnable onEntry;
    private DoubleConsumer doAction;
    private Runnable onExit;
    private DoublePredicate isDone;

    @Override
    public void onEntry() {
        if (this.onEntry != null) {
            this.onEntry.run();
        }
    }

    @Override
    public void doAction(double timeInState) {
        if (this.doAction != null) {
            this.doAction.accept(timeInState);
        }
    }

    @Override
    public void onExit() {
        if (this.onExit != null) {
            this.onExit.run();
        }
    }

    @Override
    public boolean isDone(double timeInState) {
        if (this.isDone != null) {
            return this.isDone.test(timeInState);
        }
        return false;
    }

    public void setOnEntry(Runnable onEntry) {
        this.onEntry = onEntry;
    }

    public void setDoAction(DoubleConsumer doAction) {
        this.doAction = doAction;
    }

    public void setOnExit(Runnable onExit) {
        this.onExit = onExit;
    }

    public void setIsDone(DoublePredicate isDone) {
        this.isDone = isDone;
    }
}

