/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.core;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import us.ihmc.robotics.stateMachine.core.StateTransitionCondition;

public final class StateTransition<K extends Enum<K>>
implements Iterable<K> {
    private final List<K> toStateKeys = new ArrayList<K>();
    private final Map<K, List<StateTransitionCondition>> allConditions;

    public StateTransition(Class<K> keyType) {
        this.allConditions = new EnumMap<K, List<StateTransitionCondition>>(keyType);
    }

    public StateTransition(K to, StateTransitionCondition condition) {
        this.allConditions = new EnumMap(((Enum)to).getDeclaringClass());
        this.addCondition(to, condition);
    }

    public void completeWith(StateTransition<K> other) {
        other.allConditions.entrySet().forEach(e -> this.addConditions((Enum)e.getKey(), (Iterable)e.getValue()));
    }

    public void addConditions(K to, Iterable<? extends StateTransitionCondition> conditions) {
        conditions.forEach(condition -> this.addCondition(to, (StateTransitionCondition)condition));
    }

    public void addCondition(K to, StateTransitionCondition condition) {
        if (!this.allConditions.containsKey(to)) {
            this.toStateKeys.add(to);
            this.allConditions.put(to, new ArrayList());
        }
        this.allConditions.get(to).add(condition);
    }

    TransitionRequest isTransitionRequested(double timeInCurrentState) {
        for (int i = 0; i < this.toStateKeys.size(); ++i) {
            Enum to = (Enum)this.toStateKeys.get(i);
            List<StateTransitionCondition> toStateConditions = this.allConditions.get(to);
            for (int j = 0; j < toStateConditions.size(); ++j) {
                StateTransitionCondition toStateCondition = toStateConditions.get(j);
                if (!toStateCondition.testCondition(timeInCurrentState)) continue;
                return new TransitionRequest(this, to, toStateCondition.performOnExit(), toStateCondition.performOnEntry());
            }
        }
        return null;
    }

    public int getNumberOfTargetStates() {
        return this.toStateKeys.size();
    }

    @Override
    public Iterator<K> iterator() {
        return this.toStateKeys.iterator();
    }

    class TransitionRequest {
        private final K destinationKey;
        private final boolean performOnExit;
        private final boolean performOnEntry;
        final /* synthetic */ StateTransition this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public TransitionRequest(K destinationKey, boolean performOnExit, boolean performOnEntry) {
            this.this$0 = (StateTransition)this$0;
            this.destinationKey = destinationKey;
            this.performOnExit = performOnExit;
            this.performOnEntry = performOnEntry;
        }

        public K getDestinationKey() {
            return this.destinationKey;
        }

        public boolean isPerformOnExit() {
            return this.performOnExit;
        }

        public boolean isPerformOnEntry() {
            return this.performOnEntry;
        }
    }
}

