/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateChangedListener;
import us.ihmc.robotics.stateMachine.core.StateMachineClock;
import us.ihmc.robotics.stateMachine.core.StateTransition;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;

public class StateMachine<K extends Enum<K>, S extends State> {
    private final K initialStateKey;
    private final Map<K, S> states;
    private final Map<K, StateTransition<K>> stateTransitions;
    private final List<Runnable> preTransitionCallbacks = new ArrayList<Runnable>();
    private final List<Runnable> postTransitionCallbacks = new ArrayList<Runnable>();
    private final List<StateChangedListener<K>> stateChangedListeners;
    private final StateMachineClock clock;
    private final YoEnum<K> currentStateKey;
    private final YoEnum<K> previousStateKey;

    public StateMachine(K initialStateKey, Map<K, S> states, Map<K, StateTransition<K>> stateTransitions, List<StateChangedListener<K>> stateChangedListeners, StateMachineClock clock, String namePrefix, YoRegistry registry) {
        this.initialStateKey = initialStateKey;
        this.states = states;
        this.stateTransitions = stateTransitions;
        this.stateChangedListeners = stateChangedListeners;
        this.clock = clock;
        this.currentStateKey = new YoEnum(namePrefix + "CurrentState", "", registry, ((Enum)initialStateKey).getDeclaringClass(), true);
        this.currentStateKey.set(null);
        this.previousStateKey = new YoEnum(namePrefix + "PreviousState", "", registry, ((Enum)initialStateKey).getDeclaringClass(), true);
        this.previousStateKey.set(null);
        this.addStateChangedListener((oldKey, newKey) -> this.previousStateKey.set(oldKey));
    }

    public void addStateChangedListener(StateChangedListener<K> listener) {
        this.stateChangedListeners.add(listener);
    }

    public void addPreTransitionCallback(Runnable callback) {
        this.preTransitionCallbacks.add(callback);
    }

    public void addPostTransitionCallback(Runnable callback) {
        this.postTransitionCallbacks.add(callback);
    }

    public void resetToInitialState() {
        this.performTransition(this.initialStateKey);
    }

    public void resetCurrentState() {
        this.performTransition(this.currentStateKey.getEnumValue());
    }

    public void doActionAndTransition() {
        this.doTransitions();
        this.doAction();
    }

    public void doAction() {
        if (this.currentStateKey.getEnumValue() == null) {
            this.resetToInitialState();
        }
        S currentState = this.getState(this.currentStateKey.getEnumValue());
        StateMachine.assertStateNotNull(this.currentStateKey.getEnumValue(), currentState);
        currentState.doAction(this.clock.getTimeInCurrentState());
    }

    public boolean doTransitions() {
        if (this.currentStateKey.getEnumValue() == null) {
            this.resetToInitialState();
        }
        this.callPreTransitionCallbacks();
        StateTransition<K> stateTransition = this.stateTransitions.get(this.currentStateKey.getEnumValue());
        if (stateTransition == null) {
            this.callPostTransitionCallbacks();
            return false;
        }
        StateTransition.TransitionRequest transitionRequest = stateTransition.isTransitionRequested(this.clock.getTimeInCurrentState());
        if (transitionRequest == null) {
            this.callPostTransitionCallbacks();
            return false;
        }
        this.performTransition(transitionRequest);
        this.callPostTransitionCallbacks();
        return true;
    }

    void performTransition(StateTransition.TransitionRequest transitionRequest) {
        Object nextStateKey = transitionRequest.getDestinationKey();
        boolean performOnExit = transitionRequest.isPerformOnExit();
        boolean performOnEntry = transitionRequest.isPerformOnEntry();
        this.performTransition(nextStateKey, performOnExit, performOnEntry);
    }

    public void performTransition(K nextStateKey) {
        this.performTransition(nextStateKey, true, true);
    }

    public void performTransition(K nextStateKey, boolean performOnExit, boolean performOnEntry) {
        State currentState;
        if (this.currentStateKey.getEnumValue() != null && (currentState = (State)this.states.get(this.currentStateKey.getEnumValue())) != null && performOnExit) {
            currentState.onExit(this.clock.getTimeInCurrentState());
        }
        S nextState = this.getState(nextStateKey);
        StateMachine.assertStateNotNull(nextStateKey, nextState);
        if (this.stateChangedListeners != null) {
            for (int i = 0; i < this.stateChangedListeners.size(); ++i) {
                this.stateChangedListeners.get(i).stateChanged(this.currentStateKey.getEnumValue(), (Enum)nextStateKey);
            }
        }
        this.clock.notifyStateChanged();
        if (performOnEntry) {
            nextState.onEntry();
        }
        this.currentStateKey.set(nextStateKey);
    }

    private void callPreTransitionCallbacks() {
        for (int i = 0; i < this.preTransitionCallbacks.size(); ++i) {
            this.preTransitionCallbacks.get(i).run();
        }
    }

    private void callPostTransitionCallbacks() {
        for (int i = 0; i < this.postTransitionCallbacks.size(); ++i) {
            this.postTransitionCallbacks.get(i).run();
        }
    }

    public Class<K> getStateKeyType() {
        return ((Enum)this.initialStateKey).getDeclaringClass();
    }

    public K getInitialStateKey() {
        return this.initialStateKey;
    }

    public K getCurrentStateKey() {
        return (K)this.currentStateKey.getEnumValue();
    }

    public K getPreviousStateKey() {
        return (K)this.previousStateKey.getEnumValue();
    }

    public S getCurrentState() {
        if (this.currentStateKey.getEnumValue() == null) {
            throw new RuntimeException("StateMachine.reset() or doControl() has to be called before the current state key is initialized.");
        }
        return this.getState(this.currentStateKey.getEnumValue());
    }

    public S getPreviousState() {
        return this.getState(this.getPreviousStateKey());
    }

    public S getState(K stateKey) {
        return (S)((State)this.states.get(stateKey));
    }

    public StateTransition<K> getStateTransition(K stateKey) {
        return this.stateTransitions.get(stateKey);
    }

    public double getTimeInCurrentState() {
        return this.clock.getTimeInCurrentState();
    }

    public double getTimeOfLastStateChange() {
        return this.clock.getTimeOfLastStateChange();
    }

    public boolean isCurrentStateTerminal() {
        return !this.stateTransitions.containsKey(this.currentStateKey.getEnumValue());
    }

    private static void assertStateNotNull(Object stateKey, State state) {
        if (state == null) {
            throw new RuntimeException("There is no state associated with the key: " + stateKey);
        }
    }
}

