/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sliderboard.boards;

import us.ihmc.robotics.sliderboard.MidiControlMap;

public class BCF2000ControlMap
implements MidiControlMap {
    @Override
    public int getSliderChannel(int sliderIndex) {
        if (MidiControlMap.isInRange(sliderIndex, 1, 8)) {
            return sliderIndex + 80;
        }
        if (MidiControlMap.isInRange(sliderIndex, 9, 16)) {
            return sliderIndex - 8;
        }
        return -1;
    }

    @Override
    public int getSliderIndex(int sliderChannel) {
        if (MidiControlMap.isInRange(sliderChannel, 81, 88)) {
            return sliderChannel - 80;
        }
        if (MidiControlMap.isInRange(sliderChannel, 1, 8)) {
            return sliderChannel + 8;
        }
        return -1;
    }

    @Override
    public int getButtonChannel(int buttonIndex) {
        if (MidiControlMap.isInRange(buttonIndex, 1, 16)) {
            return buttonIndex + 64;
        }
        if (MidiControlMap.isInRange(buttonIndex, 17, 20)) {
            return buttonIndex + 72;
        }
        if (MidiControlMap.isInRange(buttonIndex, 21, 28)) {
            return buttonIndex + 12;
        }
        return -1;
    }

    @Override
    public int getButtonIndex(int buttonChannel) {
        if (MidiControlMap.isInRange(buttonChannel, 65, 80)) {
            return buttonChannel - 64;
        }
        if (MidiControlMap.isInRange(buttonChannel, 89, 92)) {
            return buttonChannel - 72;
        }
        if (MidiControlMap.isInRange(buttonChannel, 33, 40)) {
            return buttonChannel - 12;
        }
        return -1;
    }

    @Override
    public int getDelayVariationChannel() {
        return 94;
    }
}

