/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.sensors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.interfaces.Settable;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.robotics.screwTheory.GenericCRC32;
import us.ihmc.robotics.sensors.ForceSensorData;
import us.ihmc.robotics.sensors.ForceSensorDataHolderReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDataReadOnly;
import us.ihmc.robotics.sensors.ForceSensorDefinition;

public class ForceSensorDataHolder
implements ForceSensorDataHolderReadOnly,
Settable<ForceSensorDataHolder> {
    private final List<ForceSensorDefinition> forceSensorDefinitions = new ArrayList<ForceSensorDefinition>();
    private final List<ForceSensorData> forceSensorDatas = new ArrayList<ForceSensorData>();
    private final transient Map<ForceSensorDefinition, ForceSensorData> forceSensorMap = new HashMap<ForceSensorDefinition, ForceSensorData>();
    private final transient Map<String, ForceSensorDefinition> sensorNameToDefintionMap = new HashMap<String, ForceSensorDefinition>();
    private final transient DMatrixRMaj tempWrench = new DMatrixRMaj(6, 1);

    public ForceSensorDataHolder() {
    }

    public ForceSensorDataHolder(ForceSensorDefinition[] forceSensors) {
        for (ForceSensorDefinition forceSensorDefinition : forceSensors) {
            this.registerForceSensor(forceSensorDefinition);
        }
    }

    public ForceSensorDataHolder(List<ForceSensorDefinition> forceSensors) {
        for (ForceSensorDefinition forceSensorDefinition : forceSensors) {
            this.registerForceSensor(forceSensorDefinition);
        }
    }

    public ForceSensorData registerForceSensor(ForceSensorDefinition forceSensorDefinition) {
        ForceSensorDefinition definition = this.sensorNameToDefintionMap.get(forceSensorDefinition.getSensorName());
        if (definition == null) {
            definition = new ForceSensorDefinition();
            this.sensorNameToDefintionMap.put(forceSensorDefinition.getSensorName(), definition);
        }
        this.forceSensorDefinitions.add(definition);
        definition.set(forceSensorDefinition);
        ForceSensorData forceSensorData = this.forceSensorMap.get(definition);
        if (forceSensorData == null) {
            forceSensorData = new ForceSensorData();
            this.forceSensorMap.put(definition, forceSensorData);
        }
        this.forceSensorDatas.add(forceSensorData);
        forceSensorData.setDefinition(forceSensorDefinition);
        return forceSensorData;
    }

    public void registerForceSensor(ForceSensorDefinition forceSensorDefinition, ForceSensorDataReadOnly forceSensorData) {
        this.registerForceSensor(forceSensorDefinition).set(forceSensorData);
    }

    public void clear() {
        this.forceSensorDefinitions.clear();
        this.forceSensorDatas.clear();
    }

    @Override
    public ForceSensorData get(ForceSensorDefinition forceSensor) {
        return this.forceSensorMap.get(forceSensor);
    }

    @Override
    public List<ForceSensorDefinition> getForceSensorDefinitions() {
        return this.forceSensorDefinitions;
    }

    @Override
    public ForceSensorData getByName(String sensorName) {
        ForceSensorDefinition forceSensorDefinition = this.findForceSensorDefinition(sensorName);
        if (forceSensorDefinition == null) {
            throw new RuntimeException("Force sensor not found " + sensorName);
        }
        return this.get(forceSensorDefinition);
    }

    @Override
    public ForceSensorDefinition findForceSensorDefinition(String sensorName) {
        return this.sensorNameToDefintionMap.get(sensorName);
    }

    public int getNumberOfForceSensors() {
        return this.forceSensorDefinitions.size();
    }

    public void set(ForceSensorDataHolder other) {
        this.set((ForceSensorDataHolderReadOnly)other);
    }

    public void set(ForceSensorDataHolderReadOnly other) {
        this.clear();
        for (int i = 0; i < other.getForceSensorDefinitions().size(); ++i) {
            ForceSensorDefinition forceSensorDefinition = other.getForceSensorDefinitions().get(i);
            this.registerForceSensor(forceSensorDefinition, other.get(forceSensorDefinition));
        }
    }

    @Deprecated
    public void setDataOnly(ForceSensorDataHolder other) {
        for (int i = 0; i < other.getForceSensorDefinitions().size(); ++i) {
            ForceSensorDefinition forceSensorDefinition = other.getForceSensorDefinitions().get(i);
            ForceSensorData thisData = this.getByName(forceSensorDefinition.getSensorName());
            ForceSensorData otherData = other.getByName(forceSensorDefinition.getSensorName());
            otherData.getWrench(this.tempWrench);
            thisData.setWrench(this.tempWrench);
        }
    }

    public void setForceSensorValue(ForceSensorDefinition key, DMatrixRMaj data) {
        this.forceSensorMap.get(key).setWrench(data);
    }

    public void setForceSensorValue(ForceSensorDefinition key, WrenchReadOnly wrench) {
        this.forceSensorMap.get(key).setWrench(wrench);
    }

    @Override
    public void getForceSensorValue(ForceSensorDefinition key, Wrench wrenchToPack) {
        this.forceSensorMap.get(key).getWrench(wrenchToPack);
    }

    @Override
    public void getForceSensorValue(ForceSensorDefinition key, DMatrixRMaj wrenchToPack) {
        this.forceSensorMap.get(key).getWrench(wrenchToPack);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ForceSensorDataHolder) {
            ForceSensorDataHolder other = (ForceSensorDataHolder)obj;
            if (this.forceSensorDefinitions.size() != other.forceSensorDefinitions.size()) {
                return false;
            }
            for (int i = 0; i < this.forceSensorDefinitions.size(); ++i) {
                if (!this.forceSensorDefinitions.get(i).equals(other.forceSensorDefinitions.get(i))) {
                    return false;
                }
                if (this.forceSensorDatas.get(i).equals(other.forceSensorDatas.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void calculateChecksum(GenericCRC32 checksum) {
        for (int i = 0; i < this.forceSensorDefinitions.size(); ++i) {
            ForceSensorDefinition forceSensorDefinition = this.forceSensorDefinitions.get(i);
            this.forceSensorMap.get(forceSensorDefinition).calculateChecksum(checksum);
        }
    }
}

