/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.referenceFrame.FrameOrientation2D;
import us.ihmc.euclid.referenceFrame.FramePose2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;

public class PlanarJointReferenceFrame
extends ReferenceFrame {
    private double rotation = 0.0;
    private final Vector3D translation = new Vector3D();

    public PlanarJointReferenceFrame(String frameName, ReferenceFrame parentFrame) {
        super(frameName, parentFrame);
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        transformToParent.setRotationYawAndZeroTranslation(this.rotation);
        transformToParent.getTranslation().set((Tuple3DReadOnly)this.translation);
    }

    public void setRotationAndUpdate(double rotation) {
        this.rotation = rotation;
        this.update();
    }

    public void setOrientationAndUpdate(FrameOrientation2D orientation) {
        orientation.checkReferenceFrameMatch(this.getParent());
        this.rotation = orientation.getYaw();
        this.update();
    }

    public void setTranslationAndUpdate(FrameVector2D translation) {
        translation.checkReferenceFrameMatch(this.getParent());
        this.translation.setX(translation.getX());
        this.translation.setY(translation.getY());
        this.update();
    }

    public void setFramePose2DAndUpdate(FramePose2D framePose2d) {
        framePose2d.checkReferenceFrameMatch(this.getParent());
        this.rotation = framePose2d.getYaw();
        this.translation.setX(framePose2d.getX());
        this.translation.setY(framePose2d.getY());
        this.update();
    }

    public double getRotation() {
        return this.rotation;
    }
}

