/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;

public class NumericalMovingReferenceFrame
extends MovingReferenceFrame {
    private final ReferenceFrame originalFrame;
    private final Quaternion previousRotation = new Quaternion();
    private final Vector3D previousTranslation = new Vector3D();
    private final Quaternion rotation = new Quaternion();
    private final Vector3D translation = new Vector3D();
    private final Vector3D angularVelocity = new Vector3D();
    private final Vector3D linearVelocity = new Vector3D();
    private final double updateDT;

    public NumericalMovingReferenceFrame(ReferenceFrame originalFrame, double updateDT) {
        this("", originalFrame, updateDT);
    }

    public NumericalMovingReferenceFrame(String nameSuffix, ReferenceFrame originalFrame, double updateDT) {
        super(originalFrame.getName() + nameSuffix, originalFrame.getRootFrame());
        this.originalFrame = originalFrame;
        this.updateDT = updateDT;
        this.previousRotation.setToNaN();
        this.previousTranslation.setToNaN();
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        transformToParent.set(this.originalFrame.getTransformToRoot());
    }

    protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
        RigidBodyTransform transformToRoot = this.originalFrame.getTransformToRoot();
        if (this.previousRotation.containsNaN() || this.previousTranslation.containsNaN()) {
            transformToRoot.get((Orientation3DBasics)this.previousRotation, (Tuple3DBasics)this.previousTranslation);
            this.angularVelocity.setToZero();
            this.linearVelocity.setToZero();
        } else {
            transformToRoot.get((Orientation3DBasics)this.rotation, (Tuple3DBasics)this.translation);
            this.rotation.multiplyConjugateOther((QuaternionReadOnly)this.previousRotation);
            this.rotation.getRotationVector((Vector3DBasics)this.angularVelocity);
            this.angularVelocity.scale(1.0 / this.updateDT);
            this.linearVelocity.sub((Tuple3DReadOnly)this.translation, (Tuple3DReadOnly)this.previousTranslation);
            this.linearVelocity.scale(1.0 / this.updateDT);
            transformToRoot.get((Orientation3DBasics)this.previousRotation, (Tuple3DBasics)this.previousTranslation);
            transformToRoot.inverseTransform((Vector3DBasics)this.angularVelocity);
            transformToRoot.inverseTransform((Vector3DBasics)this.linearVelocity);
        }
        twistRelativeToParentToPack.setIncludingFrame((ReferenceFrame)this, this.getParent(), (ReferenceFrame)this, (Vector3DReadOnly)this.angularVelocity, (Vector3DReadOnly)this.linearVelocity);
    }
}

