/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class MovingMidFrame
extends MovingReferenceFrame {
    private final MovingReferenceFrame frameOne;
    private final MovingReferenceFrame frameTwo;
    private final FramePose3D pose = new FramePose3D();
    private final FramePose3D poseOne = new FramePose3D();
    private final FramePose3D poseTwo = new FramePose3D();
    private final FrameVector3D linearVelocity = new FrameVector3D();
    private final FrameVector3D linearVelocityOne = new FrameVector3D();
    private final FrameVector3D linearVelocityTwo = new FrameVector3D();
    private final FrameVector3D angularVelocity = new FrameVector3D();
    private final FrameVector3D angularVelocityOne = new FrameVector3D();
    private final FrameVector3D angularVelocityTwo = new FrameVector3D();
    private final Quaternion difference = new Quaternion();
    private final Quaternion quaternionFuture = new Quaternion();
    private final Quaternion quaternionFutureOne = new Quaternion();
    private final Quaternion quaternionFutureTwo = new Quaternion();

    public MovingMidFrame(String name, MovingReferenceFrame frameOne, MovingReferenceFrame frameTwo) {
        super(name, frameOne.getRootFrame());
        if (frameOne == frameTwo) {
            throw new IllegalArgumentException("The frames have to be different.");
        }
        frameOne.verifySameRoots((ReferenceFrame)frameTwo);
        this.frameOne = frameOne;
        this.frameTwo = frameTwo;
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.poseOne.setToZero((ReferenceFrame)this.frameOne);
        this.poseTwo.setToZero((ReferenceFrame)this.frameTwo);
        this.poseOne.changeFrame(this.getParent());
        this.poseTwo.changeFrame(this.getParent());
        this.pose.setToZero(this.getParent());
        this.pose.interpolate((FramePose3DReadOnly)this.poseOne, (FramePose3DReadOnly)this.poseTwo, 0.5);
        this.pose.get((RigidBodyTransformBasics)transformToParent);
    }

    protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
        twistRelativeToParentToPack.setToZero((ReferenceFrame)this, this.getParent(), (ReferenceFrame)this);
        TwistReadOnly twistOfFrameOne = this.frameOne.getTwistOfFrame();
        TwistReadOnly twistOfFrameTwo = this.frameTwo.getTwistOfFrame();
        this.linearVelocityOne.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameOne.getLinearPart());
        this.linearVelocityTwo.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameTwo.getLinearPart());
        this.linearVelocityOne.changeFrame((ReferenceFrame)this);
        this.linearVelocityTwo.changeFrame((ReferenceFrame)this);
        this.linearVelocity.setToZero((ReferenceFrame)this);
        this.linearVelocity.interpolate((FrameTuple3DReadOnly)this.linearVelocityOne, (FrameTuple3DReadOnly)this.linearVelocityTwo, 0.5);
        twistRelativeToParentToPack.getLinearPart().set((FrameTuple3DReadOnly)this.linearVelocity);
        this.angularVelocityOne.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameOne.getAngularPart());
        this.angularVelocityTwo.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameTwo.getAngularPart());
        this.computeAngularVelocityNumeric();
        twistRelativeToParentToPack.getAngularPart().set((FrameTuple3DReadOnly)this.angularVelocity);
    }

    public void computeAngularVelocityNumeric() {
        double integrationDT = 1.0E-5;
        this.angularVelocityOne.scale(integrationDT);
        this.angularVelocityTwo.scale(integrationDT);
        this.quaternionFutureOne.setRotationVector((Vector3DReadOnly)this.angularVelocityOne);
        this.quaternionFutureTwo.setRotationVector((Vector3DReadOnly)this.angularVelocityTwo);
        this.quaternionFutureOne.preMultiply((QuaternionReadOnly)this.poseOne.getOrientation());
        this.quaternionFutureTwo.preMultiply((QuaternionReadOnly)this.poseTwo.getOrientation());
        this.quaternionFuture.interpolate((QuaternionReadOnly)this.quaternionFutureOne, (QuaternionReadOnly)this.quaternionFutureTwo, 0.5);
        this.difference.difference((QuaternionReadOnly)this.pose.getOrientation(), (QuaternionReadOnly)this.quaternionFuture);
        this.angularVelocity.setToZero((ReferenceFrame)this);
        this.difference.getRotationVector((Vector3DBasics)this.angularVelocity);
        this.angularVelocity.scale(1.0 / integrationDT);
    }
}

