/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.robotics.screwTheory.MovingZUpFrame;

public class MovingMidFootZUpGroundFrame
extends MovingReferenceFrame {
    private final MovingZUpFrame frameOne;
    private final MovingZUpFrame frameTwo;
    private final FramePose3D pose = new FramePose3D();
    private final FramePose3D poseOne = new FramePose3D();
    private final FramePose3D poseTwo = new FramePose3D();
    private final FrameVector3D linearVelocity = new FrameVector3D();
    private final FrameVector3D linearVelocityOne = new FrameVector3D();
    private final FrameVector3D linearVelocityTwo = new FrameVector3D();

    public MovingMidFootZUpGroundFrame(String name, MovingZUpFrame frameOne, MovingZUpFrame frameTwo) {
        super(name, frameOne.getRootFrame(), true);
        if (frameOne == frameTwo) {
            throw new IllegalArgumentException("The frames have to be different.");
        }
        frameOne.verifySameRoots((ReferenceFrame)frameTwo);
        this.frameOne = frameOne;
        this.frameTwo = frameTwo;
    }

    protected void updateTransformToParent(RigidBodyTransform transformToParent) {
        this.poseOne.setToZero((ReferenceFrame)this.frameOne);
        this.poseTwo.setToZero((ReferenceFrame)this.frameTwo);
        this.poseOne.changeFrame(this.getParent());
        this.poseTwo.changeFrame(this.getParent());
        this.pose.setToZero(this.getParent());
        this.pose.interpolate((FramePose3DReadOnly)this.poseOne, (FramePose3DReadOnly)this.poseTwo, 0.5);
        this.pose.setZ(Math.min(this.poseOne.getZ(), this.poseTwo.getZ()));
        this.pose.get((RigidBodyTransformBasics)transformToParent);
    }

    protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
        TwistReadOnly twistOfFrameOne = this.frameOne.getTwistOfFrame();
        TwistReadOnly twistOfFrameTwo = this.frameTwo.getTwistOfFrame();
        this.linearVelocityOne.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameOne.getLinearPart());
        this.linearVelocityTwo.setIncludingFrame((FrameTuple3DReadOnly)twistOfFrameTwo.getLinearPart());
        this.linearVelocityOne.changeFrame((ReferenceFrame)this);
        this.linearVelocityTwo.changeFrame((ReferenceFrame)this);
        this.linearVelocity.setToZero((ReferenceFrame)this);
        this.linearVelocity.interpolate((FrameTuple3DReadOnly)this.linearVelocityOne, (FrameTuple3DReadOnly)this.linearVelocityTwo, 0.5);
        twistRelativeToParentToPack.setToZero((ReferenceFrame)this, this.getParent(), (ReferenceFrame)this);
        twistRelativeToParentToPack.getLinearPart().set((FrameTuple3DReadOnly)this.linearVelocity);
        if (this.poseOne.getZ() < this.poseTwo.getZ()) {
            twistRelativeToParentToPack.setLinearPartZ(this.linearVelocityOne.getZ());
        } else {
            twistRelativeToParentToPack.setLinearPartZ(this.linearVelocityTwo.getZ());
        }
        double wz = 0.5 * (twistOfFrameOne.getAngularPartZ() + twistOfFrameTwo.getAngularPartZ());
        twistRelativeToParentToPack.setAngularPartZ(wz);
    }
}

