/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.stream.Stream;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.spatial.Momentum;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;

public class MomentumCalculator {
    private final Twist tempTwist = new Twist();
    private final Momentum tempMomentum = new Momentum();
    private final Vector3D zero = new Vector3D();
    private final RigidBodyBasics[] rigidBodiesInOrders;

    public MomentumCalculator(RigidBodyBasics ... rigidBodies) {
        this.rigidBodiesInOrders = (RigidBodyBasics[])Stream.of(rigidBodies).filter(body -> body.getInertia() != null).toArray(RigidBodyBasics[]::new);
    }

    public MomentumCalculator(RigidBodyBasics rootBody) {
        this(rootBody.subtreeArray());
    }

    public void computeAndPack(Momentum momentum) {
        momentum.getAngularPart().set((Tuple3DReadOnly)this.zero);
        momentum.getLinearPart().set((Tuple3DReadOnly)this.zero);
        for (RigidBodyBasics rigidBody : this.rigidBodiesInOrders) {
            SpatialInertiaBasics inertia = rigidBody.getInertia();
            rigidBody.getBodyFixedFrame().getTwistOfFrame((TwistBasics)this.tempTwist);
            this.tempMomentum.setReferenceFrame(inertia.getReferenceFrame());
            this.tempMomentum.compute((SpatialInertiaReadOnly)inertia, (TwistReadOnly)this.tempTwist);
            this.tempMomentum.changeFrame(momentum.getReferenceFrame());
            momentum.add((SpatialVectorReadOnly)this.tempMomentum);
        }
    }
}

