/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Random;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.algorithms.CompositeRigidBodyMassMatrixCalculator;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.robotics.screwTheory.DifferentialIDMassMatrixCalculator;
import us.ihmc.robotics.screwTheory.MassMatrixCalculator;

public class MassMatrixCalculatorComparer {
    private static final Vector3D X = new Vector3D(1.0, 0.0, 0.0);
    private static final Vector3D Y = new Vector3D(0.0, 1.0, 0.0);
    private static final Vector3D Z = new Vector3D(0.0, 0.0, 1.0);
    private final Random random = new Random(1776L);
    private final ArrayList<MassMatrixCalculator> massMatrixCalculators = new ArrayList();
    private final MassMatrixCalculator diffIdMassMatricCalculator;
    private final CompositeRigidBodyMassMatrixCalculator compositeMassMatricCalculator;
    private final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final ArrayList<RevoluteJoint> joints = new ArrayList();
    private final RigidBodyBasics elevator = new RigidBody("elevator", this.worldFrame);

    public MassMatrixCalculatorComparer() {
        Vector3D[] jointAxes = new Vector3D[]{X, Y, Z, Z, X, Z, Z, X, Y, Y};
        this.joints.addAll(MultiBodySystemRandomTools.nextRevoluteJointChain((Random)this.random, (String)"", (RigidBodyBasics)this.elevator, (Vector3DReadOnly[])jointAxes));
        this.diffIdMassMatricCalculator = new DifferentialIDMassMatrixCalculator(this.worldFrame, this.elevator);
        this.compositeMassMatricCalculator = new CompositeRigidBodyMassMatrixCalculator((RigidBodyReadOnly)this.elevator);
        this.massMatrixCalculators.add(this.diffIdMassMatricCalculator);
        this.massMatrixCalculators.add(new MassMatrixCalculator(){

            @Override
            public void getMassMatrix(DMatrixRMaj massMatrixToPack) {
                massMatrixToPack.set((DMatrixD1)MassMatrixCalculatorComparer.this.compositeMassMatricCalculator.getMassMatrix());
            }

            @Override
            public DMatrixRMaj getMassMatrix() {
                return MassMatrixCalculatorComparer.this.compositeMassMatricCalculator.getMassMatrix();
            }

            @Override
            public JointBasics[] getJointsInOrder() {
                return MassMatrixCalculatorComparer.this.compositeMassMatricCalculator.getInput().getJointsToConsider().toArray(new JointBasics[0]);
            }

            @Override
            public void compute() {
                MassMatrixCalculatorComparer.this.compositeMassMatricCalculator.reset();
            }
        });
    }

    public void altCompare() {
        double diffIdTimeTaken = 0.0;
        double compositeTimeTaken = 0.0;
        int nIterations = 10000;
        for (int i = 0; i < nIterations; ++i) {
            MultiBodySystemRandomTools.nextState((Random)this.random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, this.joints);
            this.elevator.updateFramesRecursively();
            long startTime = System.nanoTime();
            this.diffIdMassMatricCalculator.compute();
            long endTime = System.nanoTime();
            diffIdTimeTaken += (double)(endTime - startTime) / 1.0E9;
            startTime = System.nanoTime();
            this.compositeMassMatricCalculator.reset();
            endTime = System.nanoTime();
            compositeTimeTaken += (double)(endTime - startTime) / 1.0E9;
        }
        double diffIdTimeTakenPerIteration = diffIdTimeTaken / (double)nIterations;
        double compositeTimeTakenPerIteration = compositeTimeTaken / (double)nIterations;
        System.out.println("Diff ID time taken per iteration: " + diffIdTimeTakenPerIteration + " s");
        System.out.println("Composite RBM time taken per iteration: " + compositeTimeTakenPerIteration + " s");
    }

    public void compare() {
        for (MassMatrixCalculator massMatrixCalculator : this.massMatrixCalculators) {
            long startTime = System.nanoTime();
            int nIterations = 10000;
            for (int i = 0; i < nIterations; ++i) {
                MultiBodySystemRandomTools.nextState((Random)this.random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, this.joints);
                this.elevator.updateFramesRecursively();
                massMatrixCalculator.compute();
            }
            long endTime = System.nanoTime();
            double timeTaken = (double)(endTime - startTime) / 1.0E9;
            double timeTakenPerIteration = timeTaken / (double)nIterations;
            System.out.println("Time taken per iteration: " + timeTakenPerIteration + " s");
        }
    }

    public static void main(String[] args) {
        new MassMatrixCalculatorComparer().altCompare();
    }
}

