/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.kinematics.fourbar.FourBar;
import us.ihmc.robotics.kinematics.fourbar.FourBarAngle;
import us.ihmc.robotics.kinematics.fourbar.FourBarEdge;
import us.ihmc.robotics.kinematics.fourbar.FourBarTools;
import us.ihmc.robotics.kinematics.fourbar.FourBarVertex;
import us.ihmc.robotics.screwTheory.FourBarKinematicLoopFunctionTools;
import us.ihmc.robotics.screwTheory.InvertedFourBarJointIKSolver;

public class InvertedFourBarJointIKBinarySolver
implements InvertedFourBarJointIKSolver {
    private static final boolean DEBUG = false;
    private final double tolerance;
    private final int maxIterations;
    private int iterations;
    private final FourBar fourBar = new FourBar();
    private boolean useNaiveMethod = false;
    private boolean limitsInverted = false;
    private FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters = null;
    private double lastTheta = Double.NaN;
    private double thetaMin = Double.NaN;
    private double thetaMax = Double.NaN;
    private FourBarVertex lastVertexToSolveFor = null;
    private double lastSolution = Double.NaN;

    public InvertedFourBarJointIKBinarySolver(double tolerance) {
        this(tolerance, 100);
    }

    public InvertedFourBarJointIKBinarySolver(double tolerance, int maxIterations) {
        this.tolerance = tolerance;
        this.maxIterations = maxIterations;
    }

    public void setUseNaiveMethod(boolean useNaiveMethod) {
        this.useNaiveMethod = useNaiveMethod;
    }

    @Override
    public void setConverters(FourBarKinematicLoopFunctionTools.FourBarToJointConverter[] converters) {
        this.converters = converters;
    }

    @Override
    public double solve(double theta, FourBarVertex vertexToSolveFor) {
        if (!Double.isNaN(this.lastSolution) && vertexToSolveFor == this.lastVertexToSolveFor && EuclidCoreTools.epsilonEquals((double)this.lastTheta, (double)theta, (double)this.tolerance)) {
            return this.lastSolution;
        }
        if (!FourBarTools.isFourBarInverted(vertexToSolveFor)) {
            throw new IllegalArgumentException("The given vertex does not belong to an inverted four bar.");
        }
        this.lastTheta = theta;
        this.lastVertexToSolveFor = vertexToSolveFor;
        double angle = this.isThetaAtLimit(theta, vertexToSolveFor);
        this.lastSolution = !Double.isNaN(angle) ? angle : (this.useNaiveMethod ? this.solveNaive(theta, vertexToSolveFor) : this.solveInternal(theta, vertexToSolveFor));
        return this.lastSolution;
    }

    private double isThetaAtLimit(double theta, FourBarVertex vertexToSolveFor) {
        FourBarVertex A = vertexToSolveFor;
        boolean isNextCrossing = A.getNextEdge().isCrossing();
        FourBarVertex B = isNextCrossing ? A.getNextVertex() : A.getPreviousVertex();
        double minAngleA = this.convert(A, A.getMinAngle());
        double maxAngleA = this.convert(A, A.getMaxAngle());
        this.thetaMin = minAngleA + this.convert(B, B.getMinAngle());
        this.thetaMax = maxAngleA + this.convert(B, B.getMaxAngle());
        boolean bl = this.limitsInverted = this.thetaMin > this.thetaMax;
        if (this.limitsInverted) {
            this.thetaMin = -this.thetaMin;
            this.thetaMax = -this.thetaMax;
        }
        if (A.isConvex() == isNextCrossing) {
            if (theta <= this.thetaMin + this.tolerance) {
                return minAngleA;
            }
            if (theta >= this.thetaMax - this.tolerance) {
                return maxAngleA;
            }
        } else {
            if (-theta <= this.thetaMin + this.tolerance) {
                return minAngleA;
            }
            if (-theta >= this.thetaMax - this.tolerance) {
                return maxAngleA;
            }
        }
        return Double.NaN;
    }

    private double solveNaive(double theta, FourBarVertex vertexToSolveFor) {
        long start = System.nanoTime();
        this.setupFourBar(vertexToSolveFor);
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterA = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterB = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterD = null;
        if (this.converters != null) {
            converterA = this.getConverter(vertexToSolveFor);
            converterB = this.getConverter(vertexToSolveFor.getNextVertex());
            converterD = this.getConverter(vertexToSolveFor.getPreviousVertex());
        }
        FourBarVertex A = this.fourBar.getVertexA();
        double minDAB = A.getMinAngle();
        double maxDAB = A.getMaxAngle();
        double currentDAB = Double.NaN;
        if (A.isConvex() != A.getNextEdge().isCrossing()) {
            theta = -theta;
        }
        this.iterations = 0;
        while (this.iterations < this.maxIterations) {
            currentDAB = 0.5 * (minDAB + maxDAB);
            this.fourBar.update(FourBarAngle.DAB, currentDAB);
            double actualTheta = converterA == null ? currentDAB : converterA.toJointAngle(currentDAB);
            actualTheta = this.fourBar.getEdgeDA().isCrossing() ? (actualTheta += this.convert(converterD, this.fourBar.getAngleCDA())) : (actualTheta += this.convert(converterB, this.fourBar.getAngleABC()));
            if (this.limitsInverted) {
                actualTheta = -actualTheta;
            }
            if (EuclidCoreTools.epsilonEquals((double)actualTheta, (double)theta, (double)this.tolerance)) break;
            if (actualTheta > theta) {
                maxDAB = currentDAB;
                this.thetaMax = actualTheta;
            } else {
                minDAB = currentDAB;
                this.thetaMin = actualTheta;
            }
            if (Math.abs(this.thetaMax - this.thetaMin) <= this.tolerance) break;
            ++this.iterations;
        }
        return this.convert(converterA, currentDAB);
    }

    private void setupFourBar(FourBarVertex vertexToSolverFor) {
        FourBarVertex A = vertexToSolverFor;
        FourBarVertex B = A.getNextVertex();
        FourBarVertex C = B.getNextVertex();
        FourBarVertex D = C.getNextVertex();
        this.fourBar.setup(A.getNextEdge().getLength(), B.getNextEdge().getLength(), C.getNextEdge().getLength(), D.getNextEdge().getLength(), A.isConvex(), B.isConvex(), C.isConvex(), D.isConvex());
    }

    private double solveInternal(double theta, FourBarVertex vertexToSolveFor) {
        long start = System.nanoTime();
        FourBarVertex A = vertexToSolveFor;
        FourBarEdge ABEdge = A.getNextEdge();
        FourBarEdge BCEdge = ABEdge.getNext();
        FourBarEdge CDEdge = BCEdge.getNext();
        FourBarEdge DAEdge = CDEdge.getNext();
        double AB = ABEdge.getLength();
        double BC = BCEdge.getLength();
        double CD = CDEdge.getLength();
        double DA = DAEdge.getLength();
        double minDAB = A.getMinAngle();
        double maxDAB = A.getMaxAngle();
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterA = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterB = null;
        FourBarKinematicLoopFunctionTools.FourBarToJointConverter converterD = null;
        if (this.converters != null) {
            converterA = this.getConverter(vertexToSolveFor);
            converterB = this.getConverter(vertexToSolveFor.getNextVertex());
            converterD = this.getConverter(vertexToSolveFor.getPreviousVertex());
        }
        if (vertexToSolveFor.isConvex() != ABEdge.isCrossing()) {
            theta = -theta;
        }
        double currentDAB = Double.NaN;
        this.iterations = 0;
        while (this.iterations < this.maxIterations) {
            double otherAngle;
            currentDAB = 0.5 * (minDAB + maxDAB);
            double BD = EuclidGeometryTools.unknownTriangleSideLengthByLawOfCosine((double)AB, (double)DA, (double)currentDAB);
            if (DAEdge.isCrossing()) {
                double cosADB = FourBarTools.cosineAngleWithCosineLaw(DA, BD, AB);
                double cosCDB = FourBarTools.cosineAngleWithCosineLaw(CD, BD, BC);
                otherAngle = Math.abs(Math.acos(cosADB * cosCDB + Math.sqrt((1.0 - cosADB * cosADB) * (1.0 - cosCDB * cosCDB))));
                if (!DAEdge.getStart().isConvex()) {
                    otherAngle = -otherAngle;
                }
                otherAngle = this.convert(converterD, otherAngle);
            } else {
                double cosABD = FourBarTools.cosineAngleWithCosineLaw(AB, BD, DA);
                double cosCBD = FourBarTools.cosineAngleWithCosineLaw(BC, BD, CD);
                otherAngle = Math.abs(Math.acos(cosABD * cosCBD + Math.sqrt((1.0 - cosABD * cosABD) * (1.0 - cosCBD * cosCBD))));
                if (!BCEdge.getStart().isConvex()) {
                    otherAngle = -otherAngle;
                }
                otherAngle = this.convert(converterB, otherAngle);
            }
            double actualTheta = this.convert(converterA, currentDAB) + otherAngle;
            if (this.limitsInverted) {
                actualTheta = -actualTheta;
            }
            if (EuclidCoreTools.epsilonEquals((double)actualTheta, (double)theta, (double)this.tolerance)) break;
            if (actualTheta > theta) {
                maxDAB = currentDAB;
                this.thetaMax = actualTheta;
            } else {
                minDAB = currentDAB;
                this.thetaMin = actualTheta;
            }
            if (Math.abs(this.thetaMax - this.thetaMin) <= this.tolerance) break;
            ++this.iterations;
        }
        return this.convert(converterA, currentDAB);
    }

    private double convert(FourBarVertex vertex, double vertexAngle) {
        return this.convert(this.getConverter(vertex), vertexAngle);
    }

    private double convert(FourBarKinematicLoopFunctionTools.FourBarToJointConverter converter, double vertexAngle) {
        return converter == null ? vertexAngle : converter.toJointAngle(vertexAngle);
    }

    private FourBarKinematicLoopFunctionTools.FourBarToJointConverter getConverter(FourBarVertex vertex) {
        return this.converters == null ? null : this.converters[vertex.getFourBarAngle().ordinal()];
    }
}

