/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.Collections;
import java.util.List;
import java.util.function.DoubleSupplier;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameFactories;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.RigidBody;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MecanoFactories;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.robotics.screwTheory.FourBarKinematicLoopFunction;
import us.ihmc.robotics.screwTheory.InvertedFourBarJointIKBinarySolver;
import us.ihmc.robotics.screwTheory.InvertedFourBarJointIKSolver;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class InvertedFourBarJoint
implements OneDoFJointBasics {
    private final String name;
    private final String nameId;
    private final RigidBodyBasics predecessor;
    private RigidBodyBasics successor;
    private final MovingReferenceFrame beforeJointFrame;
    private final MovingReferenceFrame afterJointFrame;
    private final FourBarKinematicLoopFunction fourBarFunction;
    private InvertedFourBarJointIKSolver ikSolver;
    private final TwistReadOnly jointTwist;
    private final Twist unitJointTwist = new Twist();
    private final Twist unitSuccessorTwist = new Twist();
    private final Twist unitPredecessorTwist = new Twist();
    private final List<TwistReadOnly> unitTwists;
    private final SpatialAccelerationReadOnly jointAcceleration;
    private final SpatialAcceleration jointBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration successorBiasAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitJointAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitSuccessorAcceleration = new SpatialAcceleration();
    private final SpatialAcceleration unitPredecessorAcceleration = new SpatialAcceleration();
    private final Wrench unitJointWrench = new Wrench();
    private WrenchReadOnly jointWrench;
    private final Vector3D rotationVector = new Vector3D();
    private final Twist tempTwist = new Twist();
    private final SpatialAcceleration tempAcceleration = new SpatialAcceleration();
    private final Twist deltaTwist = new Twist();
    private final Twist bodyTwist = new Twist();

    public InvertedFourBarJoint(String name, RevoluteJointBasics[] fourBarJoints, int masterJointIndex) {
        this.fourBarFunction = new FourBarKinematicLoopFunction(name, fourBarJoints, masterJointIndex);
        if (!this.fourBarFunction.isInverted()) {
            throw new IllegalArgumentException("The given joint configuration does not represent an inverted four bar.");
        }
        this.setIKSolver(new InvertedFourBarJointIKBinarySolver(1.0E-5));
        this.name = name;
        this.predecessor = this.getJointA().getPredecessor();
        this.predecessor.getChildrenJoints().remove(this.getJointA());
        this.predecessor.getChildrenJoints().remove(this.getJointB());
        this.predecessor.addChildJoint((JointBasics)this);
        if (this.getJointB().isLoopClosure() || this.getJointC().isLoopClosure()) {
            this.beforeJointFrame = this.getJointA().getFrameBeforeJoint();
            this.afterJointFrame = this.getJointD().getFrameAfterJoint();
        } else {
            this.beforeJointFrame = this.getJointB().getFrameBeforeJoint();
            this.afterJointFrame = this.getJointC().getFrameAfterJoint();
        }
        this.nameId = this.predecessor.isRootBody() ? name : this.predecessor.getParentJoint().getNameId() + ":" + name;
        this.unitTwists = Collections.singletonList(this.unitJointTwist);
        this.jointTwist = MecanoFactories.newTwistReadOnly(this::getQd, (TwistReadOnly)this.unitJointTwist);
        this.jointAcceleration = this.setupJointAcceleration();
    }

    private SpatialAccelerationReadOnly setupJointAcceleration() {
        DoubleSupplier wx = () -> this.getQdd() * this.unitJointAcceleration.getAngularPartX() + this.jointBiasAcceleration.getAngularPartX();
        DoubleSupplier wy = () -> this.getQdd() * this.unitJointAcceleration.getAngularPartY() + this.jointBiasAcceleration.getAngularPartY();
        DoubleSupplier wz = () -> this.getQdd() * this.unitJointAcceleration.getAngularPartZ() + this.jointBiasAcceleration.getAngularPartZ();
        DoubleSupplier vx = () -> this.getQdd() * this.unitJointAcceleration.getLinearPartX() + this.jointBiasAcceleration.getLinearPartX();
        DoubleSupplier vy = () -> this.getQdd() * this.unitJointAcceleration.getLinearPartY() + this.jointBiasAcceleration.getLinearPartY();
        DoubleSupplier vz = () -> this.getQdd() * this.unitJointAcceleration.getLinearPartZ() + this.jointBiasAcceleration.getLinearPartZ();
        FrameVector3DReadOnly angularPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly(this::getFrameAfterJoint, (DoubleSupplier)wx, (DoubleSupplier)wy, (DoubleSupplier)wz);
        FrameVector3DReadOnly linearPart = EuclidFrameFactories.newLinkedFrameVector3DReadOnly(this::getFrameAfterJoint, (DoubleSupplier)vx, (DoubleSupplier)vy, (DoubleSupplier)vz);
        return MecanoFactories.newSpatialAccelerationVectorReadOnly((ReferenceFrame)this.afterJointFrame, (ReferenceFrame)this.beforeJointFrame, (FrameVector3DReadOnly)angularPart, (FrameVector3DReadOnly)linearPart);
    }

    public void setSuccessor(RigidBodyBasics successor) {
        if (this.successor != null) {
            throw new IllegalOperationException("The successor of this joint has already been set.");
        }
        this.successor = successor;
        this.jointWrench = MecanoFactories.newWrenchReadOnly(this::getTau, (WrenchReadOnly)this.unitJointWrench);
    }

    public void setIKSolver(InvertedFourBarJointIKSolver ikSolver) {
        this.ikSolver = ikSolver;
        ikSolver.setConverters(this.fourBarFunction.getConverters());
    }

    public void updateFrame() {
        this.fourBarFunction.updateState(true, true);
        this.getJointA().getFrameBeforeJoint().update();
        this.getJointB().getFrameBeforeJoint().update();
        this.getJointC().getFrameBeforeJoint().update();
        this.getJointD().getFrameBeforeJoint().update();
        this.getJointA().getFrameAfterJoint().update();
        this.getJointB().getFrameAfterJoint().update();
        this.getJointC().getFrameAfterJoint().update();
        this.getJointD().getFrameAfterJoint().update();
        this.updateMotionSubspace();
    }

    public void updateMotionSubspace() {
        double c_2;
        double c_1;
        double J_2;
        double J_1;
        RevoluteJointBasics joint2;
        RevoluteJointBasics joint1;
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        DMatrixRMaj loopConvectiveTerm = this.fourBarFunction.getLoopConvectiveTerm();
        if (this.beforeJointFrame == this.getJointA().getFrameBeforeJoint()) {
            joint1 = this.getJointA();
            joint2 = this.getJointD();
            J_1 = loopJacobian.get(0);
            J_2 = loopJacobian.get(3);
            c_1 = loopConvectiveTerm.get(0);
            c_2 = loopConvectiveTerm.get(3);
        } else {
            joint1 = this.getJointB();
            joint2 = this.getJointC();
            J_1 = loopJacobian.get(1);
            J_2 = loopJacobian.get(2);
            c_1 = loopConvectiveTerm.get(1);
            c_2 = loopConvectiveTerm.get(2);
        }
        this.unitJointTwist.setIncludingFrame((SpatialMotionReadOnly)joint1.getUnitJointTwist());
        this.unitJointTwist.scale(J_1);
        this.unitJointTwist.setBodyFrame((ReferenceFrame)joint2.getFrameBeforeJoint());
        this.unitJointTwist.changeFrame((ReferenceFrame)joint2.getFrameAfterJoint());
        this.tempTwist.setIncludingFrame((SpatialMotionReadOnly)joint2.getUnitJointTwist());
        this.tempTwist.scale(J_2);
        this.unitJointTwist.add((TwistReadOnly)this.tempTwist);
        this.unitJointTwist.scale(1.0 / (J_1 + J_2));
        this.unitJointAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.unitJointTwist);
        joint2.getFrameAfterJoint().getTwistRelativeToOther((ReferenceFrame)joint1.getFrameAfterJoint(), (TwistBasics)this.deltaTwist);
        joint2.getFrameBeforeJoint().getTwistRelativeToOther((ReferenceFrame)joint1.getFrameBeforeJoint(), (TwistBasics)this.bodyTwist);
        this.deltaTwist.changeFrame((ReferenceFrame)joint2.getFrameAfterJoint());
        this.bodyTwist.changeFrame((ReferenceFrame)joint2.getFrameAfterJoint());
        this.jointBiasAcceleration.setIncludingFrame((SpatialMotionReadOnly)joint1.getUnitJointAcceleration());
        this.jointBiasAcceleration.scale(c_1);
        this.jointBiasAcceleration.setBodyFrame((ReferenceFrame)joint2.getFrameBeforeJoint());
        this.jointBiasAcceleration.changeFrame((ReferenceFrame)joint2.getFrameAfterJoint(), (TwistReadOnly)this.deltaTwist, (TwistReadOnly)this.bodyTwist);
        this.tempAcceleration.setIncludingFrame((SpatialMotionReadOnly)joint2.getUnitJointAcceleration());
        this.tempAcceleration.scale(c_2);
        this.jointBiasAcceleration.add((SpatialAccelerationReadOnly)this.tempAcceleration);
        this.tempAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.unitJointAcceleration);
        this.tempAcceleration.scale(-(c_1 + c_2));
        this.jointBiasAcceleration.add((SpatialVectorReadOnly)this.tempAcceleration);
        if (this.getSuccessor() != null) {
            this.unitSuccessorTwist.setIncludingFrame((SpatialMotionReadOnly)this.unitJointTwist);
            this.unitSuccessorTwist.setBaseFrame((ReferenceFrame)this.predecessor.getBodyFixedFrame());
            this.unitSuccessorTwist.setBodyFrame((ReferenceFrame)this.successor.getBodyFixedFrame());
            this.unitSuccessorTwist.changeFrame((ReferenceFrame)this.successor.getBodyFixedFrame());
            this.unitPredecessorTwist.setIncludingFrame((SpatialMotionReadOnly)this.unitSuccessorTwist);
            this.unitPredecessorTwist.invert();
            this.unitPredecessorTwist.changeFrame((ReferenceFrame)this.predecessor.getBodyFixedFrame());
            this.unitSuccessorAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.unitSuccessorTwist);
            this.unitPredecessorAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.unitPredecessorTwist);
            this.successorBiasAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.jointBiasAcceleration);
            this.successorBiasAcceleration.setBaseFrame((ReferenceFrame)this.getPredecessor().getBodyFixedFrame());
            this.successorBiasAcceleration.setBodyFrame((ReferenceFrame)this.getSuccessor().getBodyFixedFrame());
            this.successorBiasAcceleration.changeFrame((ReferenceFrame)this.getSuccessor().getBodyFixedFrame());
            this.unitJointWrench.setIncludingFrame((SpatialVectorReadOnly)this.fourBarFunction.getMasterJoint().getUnitJointTwist());
            this.unitJointWrench.changeFrame((ReferenceFrame)this.afterJointFrame);
            this.unitJointWrench.setBodyFrame((ReferenceFrame)this.getSuccessor().getBodyFixedFrame());
        }
    }

    public FourBarKinematicLoopFunction getFourBarFunction() {
        return this.fourBarFunction;
    }

    public RevoluteJointBasics getMasterJoint() {
        return this.fourBarFunction.getMasterJoint();
    }

    public RevoluteJointBasics getJointA() {
        return this.fourBarFunction.getJointA();
    }

    public RevoluteJointBasics getJointB() {
        return this.fourBarFunction.getJointB();
    }

    public RevoluteJointBasics getJointC() {
        return this.fourBarFunction.getJointC();
    }

    public RevoluteJointBasics getJointD() {
        return this.fourBarFunction.getJointD();
    }

    public InvertedFourBarJointIKSolver getIKSolver() {
        return this.ikSolver;
    }

    public MovingReferenceFrame getFrameBeforeJoint() {
        return this.beforeJointFrame;
    }

    public MovingReferenceFrame getFrameAfterJoint() {
        return this.afterJointFrame;
    }

    public RigidBodyBasics getPredecessor() {
        return this.predecessor;
    }

    public RigidBodyBasics getSuccessor() {
        return this.successor;
    }

    public boolean isMotionSubspaceVariable() {
        return true;
    }

    public MovingReferenceFrame getLoopClosureFrame() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getNameId() {
        return this.nameId;
    }

    public void setupLoopClosure(RigidBodyBasics successor, RigidBodyTransformReadOnly transformFromSuccessorParentJoint) {
        throw new UnsupportedOperationException("Loop closure using a four bar joint has not been implemented.");
    }

    public FrameVector3DReadOnly getJointAxis() {
        return this.getMasterJoint().getJointAxis();
    }

    public double getQ() {
        return this.getJointA().getQ() + this.getJointD().getQ();
    }

    public double getQd() {
        return this.getJointA().getQd() + this.getJointD().getQd();
    }

    public double getQdd() {
        return this.getJointA().getQdd() + this.getJointD().getQdd();
    }

    public double getTau() {
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        this.fourBarFunction.updateEffort();
        if (this.getMasterJoint() == this.getJointA() || this.getMasterJoint() == this.getJointD()) {
            return this.getMasterJoint().getTau() / (loopJacobian.get(0) + loopJacobian.get(3));
        }
        return this.getMasterJoint().getTau() / (loopJacobian.get(1) + loopJacobian.get(2));
    }

    public double getJointLimitLower() {
        return this.getJointA().getJointLimitLower() + this.getJointD().getJointLimitLower();
    }

    public double getJointLimitUpper() {
        return this.getJointA().getJointLimitUpper() + this.getJointD().getJointLimitUpper();
    }

    public double getVelocityLimitLower() {
        return this.getJointA().getVelocityLimitLower() + this.getJointD().getVelocityLimitLower();
    }

    public double getVelocityLimitUpper() {
        return this.getJointA().getVelocityLimitUpper() + this.getJointD().getVelocityLimitUpper();
    }

    public double getEffortLimitLower() {
        return this.getMasterJoint().getEffortLimitLower();
    }

    public double getEffortLimitUpper() {
        return this.getMasterJoint().getEffortLimitUpper();
    }

    public TwistReadOnly getUnitJointTwist() {
        return this.unitJointTwist;
    }

    public TwistReadOnly getUnitSuccessorTwist() {
        return this.unitSuccessorTwist;
    }

    public TwistReadOnly getUnitPredecessorTwist() {
        return this.unitPredecessorTwist;
    }

    public SpatialAccelerationReadOnly getUnitJointAcceleration() {
        return this.unitJointAcceleration;
    }

    public SpatialAccelerationReadOnly getUnitSuccessorAcceleration() {
        return this.unitSuccessorAcceleration;
    }

    public SpatialAccelerationReadOnly getUnitPredecessorAcceleration() {
        return this.unitPredecessorAcceleration;
    }

    public void getJointConfiguration(RigidBodyTransform jointConfigurationToPack) {
        this.afterJointFrame.getTransformToDesiredFrame(jointConfigurationToPack, (ReferenceFrame)this.beforeJointFrame);
    }

    public TwistReadOnly getJointTwist() {
        return this.jointTwist;
    }

    public List<TwistReadOnly> getUnitTwists() {
        return this.unitTwists;
    }

    public SpatialAccelerationReadOnly getJointAcceleration() {
        return this.jointAcceleration;
    }

    public SpatialAccelerationReadOnly getJointBiasAcceleration() {
        return this.jointBiasAcceleration;
    }

    public SpatialAccelerationReadOnly getSuccessorBiasAcceleration() {
        return this.successorBiasAcceleration;
    }

    public void getPredecessorAcceleration(SpatialAccelerationBasics accelerationToPack) {
        throw new UnsupportedOperationException("Implement me!");
    }

    public SpatialAccelerationReadOnly getPredecessorBiasAcceleration() {
        throw new UnsupportedOperationException("Implement me!");
    }

    public WrenchReadOnly getJointWrench() {
        return this.jointWrench;
    }

    public void setJointOrientation(Orientation3DReadOnly jointOrientation) {
        jointOrientation.getRotationVector((Vector3DBasics)this.rotationVector);
        this.setQ(this.rotationVector.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    public void setJointPosition(Tuple3DReadOnly jointPosition) {
    }

    public void setJointAngularVelocity(Vector3DReadOnly jointAngularVelocity) {
        this.setQd(jointAngularVelocity.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    public void setJointLinearVelocity(Vector3DReadOnly jointLinearVelocity) {
    }

    public void setJointAngularAcceleration(Vector3DReadOnly jointAngularAcceleration) {
        this.setQdd(jointAngularAcceleration.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    public void setJointLinearAcceleration(Vector3DReadOnly jointLinearAcceleration) {
    }

    public void setJointTorque(Vector3DReadOnly jointTorque) {
        this.setTau(jointTorque.dot((Vector3DReadOnly)this.getJointAxis()));
    }

    public void setJointForce(Vector3DReadOnly jointForce) {
    }

    public void setQ(double q) {
        this.getMasterJoint().setQ(this.computeMasterJointQ(q));
    }

    public double computeMasterJointQ(double q) {
        return this.ikSolver.solve(q, this.fourBarFunction.getMasterVertex());
    }

    public void setQd(double qd) {
        this.getMasterJoint().setQd(this.computeMasterJointQd(qd));
    }

    public double computeMasterJointQd(double qd) {
        this.fourBarFunction.updateState(false, false);
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        return qd / (loopJacobian.get(0) + loopJacobian.get(3));
    }

    public void setQdd(double qdd) {
        this.getMasterJoint().setQdd(this.computeMasterJointQdd(qdd));
    }

    public double computeMasterJointQdd(double qdd) {
        this.fourBarFunction.updateState(false, false);
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        DMatrixRMaj loopConvectiveTerm = this.fourBarFunction.getLoopConvectiveTerm();
        qdd = qdd - loopConvectiveTerm.get(0) - loopConvectiveTerm.get(3);
        double qdd_master = qdd / (loopJacobian.get(0) + loopJacobian.get(3));
        return qdd_master;
    }

    public void setTau(double tau) {
        this.getJointA().setJointTauToZero();
        this.getJointB().setJointTauToZero();
        this.getJointC().setJointTauToZero();
        this.getJointD().setJointTauToZero();
        this.getMasterJoint().setTau(this.computeMasterJointTau(tau));
    }

    public double computeMasterJointTau(double tau) {
        DMatrixRMaj loopJacobian = this.fourBarFunction.getLoopJacobian();
        if (this.getMasterJoint() == this.getJointA() || this.getMasterJoint() == this.getJointD()) {
            return (loopJacobian.get(0) + loopJacobian.get(3)) * tau;
        }
        return (loopJacobian.get(1) + loopJacobian.get(2)) * tau;
    }

    public void setJointLimitLower(double jointLimitLower) {
        throw new UnsupportedOperationException();
    }

    public void setJointLimitUpper(double jointLimitUpper) {
        throw new UnsupportedOperationException();
    }

    public void setVelocityLimitLower(double velocityLimitLower) {
        throw new UnsupportedOperationException();
    }

    public void setVelocityLimitUpper(double velocityLimitUpper) {
        throw new UnsupportedOperationException();
    }

    public void setEffortLimitLower(double effortLimitLower) {
        this.getMasterJoint().setEffortLimitLower(effortLimitLower);
    }

    public void setEffortLimitUpper(double effortLimitUpper) {
        this.getMasterJoint().setEffortLimitUpper(effortLimitUpper);
    }

    public String toString() {
        String qAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQ());
        String qdAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQd());
        String qddAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getQdd());
        String tauAsString = String.format(EuclidCoreIOTools.DEFAULT_FORMAT, this.getTau());
        return this.getClass().getSimpleName() + " " + this.getName() + ", q: " + qAsString + ", qd: " + qdAsString + ", qdd: " + qddAsString + ", tau: " + tauAsString;
    }

    public int hashCode() {
        return this.nameId.hashCode();
    }

    public static InvertedFourBarJoint cloneInvertedFourBarJoint(InvertedFourBarJoint original, ReferenceFrame stationaryFrame, String cloneSuffix) {
        RigidBodyBasics originalPredecessor = original.getPredecessor();
        RigidBody clonePredecessor = new RigidBody(originalPredecessor.getName() + cloneSuffix, stationaryFrame);
        return InvertedFourBarJoint.cloneInvertedFourBarJoint(original, (RigidBodyBasics)clonePredecessor, cloneSuffix);
    }

    public static InvertedFourBarJoint cloneInvertedFourBarJoint(InvertedFourBarJoint original, RigidBodyBasics clonePredecessor, String cloneSuffix) {
        RevoluteJoint cloneJointA;
        RevoluteJoint cloneJointD;
        RevoluteJoint cloneJointC;
        RevoluteJoint cloneJointB;
        MultiBodySystemFactories.JointBuilder jointBuilder = MultiBodySystemFactories.DEFAULT_JOINT_BUILDER;
        MultiBodySystemFactories.RigidBodyBuilder bodyBuilder = MultiBodySystemFactories.DEFAULT_RIGID_BODY_BUILDER;
        if (original.getJointA().isLoopClosure()) {
            cloneJointB = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointB(), cloneSuffix, clonePredecessor);
            RigidBodyBasics cloneBodyBC = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getJointB().getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointB);
            cloneJointC = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointC(), cloneSuffix, cloneBodyBC);
            RigidBodyBasics cloneSuccessor = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointC);
            cloneJointD = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointD(), cloneSuffix, cloneSuccessor);
            RigidBodyBasics cloneBodyAD = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getJointD().getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointD);
            cloneJointA = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointA(), cloneSuffix, cloneBodyAD);
            RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original.getJointA().getLoopClosureFrame().getTransformToParent());
            transform.invert();
            cloneJointA.setupLoopClosure(clonePredecessor, (RigidBodyTransformReadOnly)transform);
        } else if (original.getJointB().isLoopClosure()) {
            cloneJointA = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointA(), cloneSuffix, clonePredecessor);
            RigidBodyBasics cloneBodyAD = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getJointA().getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointA);
            cloneJointD = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointD(), cloneSuffix, cloneBodyAD);
            RigidBodyBasics cloneSuccessor = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointD);
            cloneJointC = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointC(), cloneSuffix, cloneSuccessor);
            RigidBodyBasics cloneBodyBC = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getJointC().getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointC);
            cloneJointB = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointB(), cloneSuffix, cloneBodyBC);
            RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original.getJointB().getLoopClosureFrame().getTransformToParent());
            transform.invert();
            cloneJointB.setupLoopClosure(clonePredecessor, (RigidBodyTransformReadOnly)transform);
        } else {
            cloneJointA = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointA(), cloneSuffix, clonePredecessor);
            RigidBodyBasics cloneBodyAD = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getJointA().getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointA);
            cloneJointD = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointD(), cloneSuffix, cloneBodyAD);
            cloneJointB = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointB(), cloneSuffix, clonePredecessor);
            RigidBodyBasics cloneBodyBC = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getJointB().getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointB);
            cloneJointC = (RevoluteJoint)jointBuilder.cloneOneDoFJoint((OneDoFJointReadOnly)original.getJointC(), cloneSuffix, cloneBodyBC);
            if (original.getJointC().isLoopClosure()) {
                RigidBodyBasics cloneSuccessor = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointD);
                RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original.getJointC().getLoopClosureFrame().getTransformToParent());
                transform.invert();
                cloneJointC.setupLoopClosure(cloneSuccessor, (RigidBodyTransformReadOnly)transform);
            } else {
                RigidBodyBasics cloneSuccessor = bodyBuilder.cloneRigidBody((RigidBodyReadOnly)original.getSuccessor(), null, cloneSuffix, (JointBasics)cloneJointC);
                RigidBodyTransform transform = new RigidBodyTransform((RigidBodyTransformReadOnly)original.getJointD().getLoopClosureFrame().getTransformToParent());
                transform.invert();
                cloneJointD.setupLoopClosure(cloneSuccessor, (RigidBodyTransformReadOnly)transform);
            }
        }
        return new InvertedFourBarJoint(original.getName() + cloneSuffix, new RevoluteJointBasics[]{cloneJointA, cloneJointB, cloneJointC, cloneJointD}, original.getFourBarFunction().getMasterJointIndex());
    }
}

