/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import org.ejml.LinearSolverSafe;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.data.Matrix;
import org.ejml.dense.row.factory.LinearSolverFactory_DDRM;
import org.ejml.interfaces.linsol.LinearSolverDense;
import us.ihmc.robotics.screwTheory.JacobianSolver;

public class InverseJacobianSolver
implements JacobianSolver {
    private final LinearSolverDense<DMatrixRMaj> solver = new LinearSolverSafe(LinearSolverFactory_DDRM.leastSquaresQrPivot((boolean)true, (boolean)false));
    private final DMatrixRMaj jacobianMatrix;

    public InverseJacobianSolver(int matrixSize) {
        this.jacobianMatrix = new DMatrixRMaj(matrixSize, matrixSize);
    }

    @Override
    public void solve(DMatrixRMaj solutionToPack, DMatrixRMaj vector) {
        if (!this.solver.setA((Matrix)this.jacobianMatrix)) {
            throw new RuntimeException("jacobian is singular");
        }
        this.solver.solve((Matrix)vector, (Matrix)solutionToPack);
    }

    @Override
    public void setJacobian(DMatrixRMaj jacobianMatrix) {
        this.jacobianMatrix.set((DMatrixD1)jacobianMatrix);
    }
}

