/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.mecano.multiBodySystem.PlanarJoint;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.SphericalJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.robotics.screwTheory.GenericCRC32;

public class InverseDynamicsJointStateChecksum {
    protected final GenericCRC32 checksum;
    private final ChecksumUpdater[] checksumUpdaters;

    public InverseDynamicsJointStateChecksum(RigidBodyBasics rootBody, GenericCRC32 checksum) {
        this.checksum = checksum;
        this.checksumUpdaters = (ChecksumUpdater[])SubtreeStreams.fromChildren((RigidBodyBasics)rootBody).map(joint -> InverseDynamicsJointStateChecksum.newJointChecksumUpdater(checksum, joint)).toArray(ChecksumUpdater[]::new);
    }

    public void calculate() {
        for (ChecksumUpdater checksumUpdater : this.checksumUpdaters) {
            checksumUpdater.updateChecksum();
        }
    }

    public static ChecksumUpdater newJointChecksumUpdater(GenericCRC32 checksum, JointBasics joint) {
        if (joint instanceof SixDoFJoint) {
            return InverseDynamicsJointStateChecksum.newJointChecksumUpdater(checksum, (SixDoFJoint)joint);
        }
        if (joint instanceof PlanarJoint) {
            return InverseDynamicsJointStateChecksum.newJointChecksumUpdater(checksum, (PlanarJoint)joint);
        }
        if (joint instanceof OneDoFJointBasics) {
            return InverseDynamicsJointStateChecksum.newJointChecksumUpdater(checksum, (OneDoFJointBasics)joint);
        }
        if (joint instanceof SphericalJoint) {
            return InverseDynamicsJointStateChecksum.newJointChecksumUpdater(checksum, (SphericalJoint)joint);
        }
        throw new RuntimeException("Unhandled type of joint: " + joint.getClass().getSimpleName());
    }

    public static ChecksumUpdater newJointChecksumUpdater(GenericCRC32 checksum, SixDoFJoint joint) {
        return () -> {
            checksum.update((Tuple4DReadOnly)joint.getJointPose().getOrientation());
            checksum.update((Tuple3DReadOnly)joint.getJointPose().getPosition());
            checksum.update((Tuple3DReadOnly)joint.getJointTwist().getAngularPart());
            checksum.update((Tuple3DReadOnly)joint.getJointTwist().getLinearPart());
            checksum.update((Tuple3DReadOnly)joint.getJointAcceleration().getAngularPart());
            checksum.update((Tuple3DReadOnly)joint.getJointAcceleration().getLinearPart());
        };
    }

    public static ChecksumUpdater newJointChecksumUpdater(GenericCRC32 checksum, PlanarJoint joint) {
        return () -> {
            checksum.update(joint.getJointPose().getOrientation().getPitch());
            checksum.update(joint.getJointPose().getPosition().getX());
            checksum.update(joint.getJointPose().getPosition().getY());
            checksum.update(joint.getJointTwist().getAngularPartY());
            checksum.update(joint.getJointTwist().getLinearPartX());
            checksum.update(joint.getJointTwist().getLinearPartZ());
            checksum.update(joint.getJointAcceleration().getAngularPartY());
            checksum.update(joint.getJointAcceleration().getLinearPartX());
            checksum.update(joint.getJointAcceleration().getLinearPartZ());
        };
    }

    public static ChecksumUpdater newJointChecksumUpdater(GenericCRC32 checksum, OneDoFJointBasics joint) {
        return () -> {
            checksum.update(joint.getQ());
            checksum.update(joint.getQd());
            checksum.update(joint.getQdd());
        };
    }

    public static ChecksumUpdater newJointChecksumUpdater(GenericCRC32 checksum, SphericalJoint joint) {
        return () -> {
            checksum.update((Tuple4DReadOnly)joint.getJointOrientation());
            checksum.update((Tuple3DReadOnly)joint.getJointAngularVelocity());
            checksum.update((Tuple3DReadOnly)joint.getJointAngularAcceleration());
        };
    }

    public static interface ChecksumUpdater {
        public void updateChecksum();
    }
}

