/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.mecano.algorithms.interfaces.RigidBodyAccelerationProvider;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.MultiBodySystemReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.SpatialAcceleration;
import us.ihmc.mecano.spatial.SpatialForce;
import us.ihmc.mecano.spatial.SpatialInertia;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.SpatialAccelerationReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialInertiaReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;

public class GravityCoriolisExternalWrenchMatrixCalculator {
    private final MultiBodySystemReadOnly input;
    private final RecursionStep initialRecursionStep;
    private final Map<RigidBodyReadOnly, RecursionStep> rigidBodyToRecursionStepMap = new LinkedHashMap<RigidBodyReadOnly, RecursionStep>();
    private final DMatrixRMaj jointTauMatrix;
    private final boolean considerCoriolisAndCentrifugalForces;
    private final RigidBodyAccelerationProvider coriolisAccelerationProvider;
    private final SpatialForce jointForceFromChild = new SpatialForce();

    public GravityCoriolisExternalWrenchMatrixCalculator(RigidBodyReadOnly rootBody) {
        this(rootBody, true);
    }

    public GravityCoriolisExternalWrenchMatrixCalculator(RigidBodyReadOnly rootBody, boolean considerCoriolisAndCentrifugalForces) {
        this(MultiBodySystemReadOnly.toMultiBodySystemInput((RigidBodyReadOnly)rootBody), considerCoriolisAndCentrifugalForces);
    }

    public GravityCoriolisExternalWrenchMatrixCalculator(MultiBodySystemReadOnly input) {
        this(input, true, true);
    }

    public GravityCoriolisExternalWrenchMatrixCalculator(MultiBodySystemReadOnly input, boolean considerIgnoredSubtreesInertia) {
        this(input, true, considerIgnoredSubtreesInertia);
    }

    public GravityCoriolisExternalWrenchMatrixCalculator(MultiBodySystemReadOnly input, boolean considerCoriolisAndCentrifugalForces, boolean considerIgnoredSubtreesInertia) {
        this.input = input;
        this.considerCoriolisAndCentrifugalForces = considerCoriolisAndCentrifugalForces;
        RigidBodyReadOnly rootBody = input.getRootBody();
        this.initialRecursionStep = new RecursionStep(rootBody, null, null);
        this.rigidBodyToRecursionStepMap.put(rootBody, this.initialRecursionStep);
        this.buildMultiBodyTree(this.initialRecursionStep, input.getJointsToIgnore());
        if (considerIgnoredSubtreesInertia) {
            this.initialRecursionStep.includeIgnoredSubtreeInertia();
        }
        int nDoFs = MultiBodySystemTools.computeDegreesOfFreedom((List)input.getJointsToConsider());
        this.jointTauMatrix = new DMatrixRMaj(nDoFs, 1);
        this.coriolisAccelerationProvider = RigidBodyAccelerationProvider.toRigidBodyAccelerationProvider(body -> this.rigidBodyToRecursionStepMap.get(body).rigidBodyAcceleration, (ReferenceFrame)input.getInertialFrame(), (boolean)considerCoriolisAndCentrifugalForces, (boolean)false);
    }

    private void buildMultiBodyTree(RecursionStep parent, Collection<? extends JointReadOnly> jointsToIgnore) {
        for (JointReadOnly childJoint : parent.rigidBody.getChildrenJoints()) {
            RigidBodyReadOnly childBody;
            if (jointsToIgnore.contains(childJoint) || (childBody = childJoint.getSuccessor()) == null) continue;
            int[] jointIndices = this.input.getJointMatrixIndexProvider().getJointDoFIndices(childJoint);
            RecursionStep child = new RecursionStep(childBody, parent, jointIndices);
            this.rigidBodyToRecursionStepMap.put(childBody, child);
            this.buildMultiBodyTree(child, jointsToIgnore);
        }
    }

    public void setGravitionalAcceleration(FrameTuple3DReadOnly gravity) {
        gravity.checkReferenceFrameMatch(this.input.getInertialFrame());
        this.setGravitionalAcceleration((Tuple3DReadOnly)gravity);
    }

    public void setGravitionalAcceleration(Tuple3DReadOnly gravity) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().setAndNegate(gravity);
    }

    public void setGravitionalAcceleration(double gravity) {
        this.setGravitionalAcceleration(0.0, 0.0, gravity);
    }

    public void setGravitionalAcceleration(double gravityX, double gravityY, double gravityZ) {
        SpatialAcceleration rootAcceleration = this.initialRecursionStep.rigidBodyAcceleration;
        rootAcceleration.setToZero();
        rootAcceleration.getLinearPart().set(gravityX, gravityY, gravityZ);
        rootAcceleration.negate();
    }

    public void setRootAcceleration(SpatialAccelerationReadOnly newRootAcceleration) {
        this.initialRecursionStep.rigidBodyAcceleration.set((SpatialMotionReadOnly)newRootAcceleration);
    }

    public void setExternalWrenchesToZero() {
        this.initialRecursionStep.setExternalWrenchToZeroRecursive();
    }

    public FixedFrameWrenchBasics getExternalWrench(RigidBodyReadOnly rigidBody) {
        return this.rigidBodyToRecursionStepMap.get(rigidBody).externalWrench;
    }

    public void setExternalWrench(RigidBodyReadOnly rigidBody, WrenchReadOnly externalWrench) {
        this.getExternalWrench(rigidBody).setMatchingFrame(externalWrench);
    }

    public void compute() {
        this.initialRecursionStep.passOne();
        this.initialRecursionStep.passTwo();
    }

    public MultiBodySystemReadOnly getInput() {
        return this.input;
    }

    public DMatrixRMaj getJointTauMatrix() {
        return this.jointTauMatrix;
    }

    public WrenchReadOnly getComputedJointWrench(JointReadOnly joint) {
        RecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.jointWrench;
    }

    public DMatrixRMaj getComputedJointTau(JointReadOnly joint) {
        RecursionStep recursionStep = this.rigidBodyToRecursionStepMap.get(joint.getSuccessor());
        if (recursionStep == null) {
            return null;
        }
        return recursionStep.tau;
    }

    public void writeComputedJointWrenches(JointBasics[] joints) {
        for (JointBasics joint : joints) {
            this.writeComputedJointWrench(joint);
        }
    }

    public void writeComputedJointWrenches(List<? extends JointBasics> joints) {
        for (int i = 0; i < joints.size(); ++i) {
            this.writeComputedJointWrench(joints.get(i));
        }
    }

    public boolean writeComputedJointWrench(JointBasics joint) {
        WrenchReadOnly jointWrench = this.getComputedJointWrench((JointReadOnly)joint);
        if (jointWrench == null) {
            return false;
        }
        joint.setJointWrench(jointWrench);
        return true;
    }

    public RigidBodyAccelerationProvider getAccelerationProvider() {
        return this.coriolisAccelerationProvider;
    }

    private final class RecursionStep {
        private final RigidBodyReadOnly rigidBody;
        private final SpatialInertia bodyInertia;
        private final RecursionStep parent;
        private final List<RecursionStep> children = new ArrayList<RecursionStep>();
        private final Wrench jointWrench;
        private final FixedFrameWrenchBasics externalWrench;
        private final SpatialAcceleration rigidBodyAcceleration;
        private final Twist localJointTwist = new Twist();
        private final DMatrixRMaj S;
        private final DMatrixRMaj tau;
        private final DMatrixRMaj jointWrenchMatrix;
        private int[] jointIndices;

        public RecursionStep(RigidBodyReadOnly rigidBody, RecursionStep parent, int[] jointIndices) {
            this.rigidBody = rigidBody;
            this.parent = parent;
            this.jointIndices = jointIndices;
            this.rigidBodyAcceleration = new SpatialAcceleration((ReferenceFrame)this.getBodyFixedFrame(), GravityCoriolisExternalWrenchMatrixCalculator.this.input.getInertialFrame(), (ReferenceFrame)this.getBodyFixedFrame());
            if (this.isRoot()) {
                this.bodyInertia = null;
                this.jointWrench = null;
                this.externalWrench = null;
                this.S = null;
                this.tau = null;
                this.jointWrenchMatrix = null;
            } else {
                parent.children.add(this);
                int nDoFs = this.getJoint().getDegreesOfFreedom();
                this.bodyInertia = new SpatialInertia(rigidBody.getInertia());
                this.jointWrench = new Wrench();
                this.externalWrench = new Wrench((ReferenceFrame)this.getBodyFixedFrame(), (ReferenceFrame)this.getBodyFixedFrame());
                this.S = new DMatrixRMaj(6, nDoFs);
                this.tau = new DMatrixRMaj(nDoFs, 1);
                this.jointWrenchMatrix = new DMatrixRMaj(6, 1);
                this.getJoint().getMotionSubspace((DMatrix1Row)this.S);
            }
        }

        public void includeIgnoredSubtreeInertia() {
            if (!this.isRoot() && this.children.size() != this.rigidBody.getChildrenJoints().size()) {
                for (JointReadOnly childJoint : this.rigidBody.getChildrenJoints()) {
                    if (!GravityCoriolisExternalWrenchMatrixCalculator.this.input.getJointsToIgnore().contains(childJoint)) continue;
                    SpatialInertia subtreeIneria = MultiBodySystemTools.computeSubtreeInertia((JointReadOnly)childJoint);
                    subtreeIneria.changeFrame((ReferenceFrame)this.getBodyFixedFrame());
                    this.bodyInertia.add((SpatialInertiaReadOnly)subtreeIneria);
                }
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).includeIgnoredSubtreeInertia();
            }
        }

        public void passOne() {
            if (!this.isRoot()) {
                TwistReadOnly bodyTwistToUse;
                this.rigidBodyAcceleration.setIncludingFrame((SpatialMotionReadOnly)this.parent.rigidBodyAcceleration);
                if (GravityCoriolisExternalWrenchMatrixCalculator.this.considerCoriolisAndCentrifugalForces) {
                    this.getJoint().getPredecessorTwist((TwistBasics)this.localJointTwist);
                    this.rigidBodyAcceleration.changeFrame((ReferenceFrame)this.getBodyFixedFrame(), (TwistReadOnly)this.localJointTwist, this.parent.getBodyFixedFrame().getTwistOfFrame());
                    bodyTwistToUse = this.getBodyTwist();
                } else {
                    this.rigidBodyAcceleration.changeFrame((ReferenceFrame)this.getBodyFixedFrame());
                    bodyTwistToUse = null;
                }
                this.rigidBodyAcceleration.setBodyFrame((ReferenceFrame)this.getBodyFixedFrame());
                this.bodyInertia.computeDynamicWrench((SpatialAccelerationReadOnly)this.rigidBodyAcceleration, bodyTwistToUse, (WrenchBasics)this.jointWrench);
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passOne();
            }
        }

        public void passTwo() {
            int childIndex;
            for (childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).passTwo();
            }
            if (this.isRoot()) {
                return;
            }
            this.jointWrench.sub((WrenchReadOnly)this.externalWrench);
            this.jointWrench.changeFrame((ReferenceFrame)this.getFrameAfterJoint());
            for (childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                GravityCoriolisExternalWrenchMatrixCalculator.this.jointForceFromChild.setIncludingFrame((SpatialVectorReadOnly)this.children.get((int)childIndex).jointWrench);
                GravityCoriolisExternalWrenchMatrixCalculator.this.jointForceFromChild.changeFrame((ReferenceFrame)this.getFrameAfterJoint());
                this.jointWrench.add((SpatialVectorReadOnly)GravityCoriolisExternalWrenchMatrixCalculator.this.jointForceFromChild);
            }
            this.jointWrench.get((DMatrix)this.jointWrenchMatrix);
            CommonOps_DDRM.multTransA((DMatrix1Row)this.S, (DMatrix1Row)this.jointWrenchMatrix, (DMatrix1Row)this.tau);
            for (int dofIndex = 0; dofIndex < this.getJoint().getDegreesOfFreedom(); ++dofIndex) {
                GravityCoriolisExternalWrenchMatrixCalculator.this.jointTauMatrix.set(this.jointIndices[dofIndex], 0, this.tau.get(dofIndex, 0));
            }
        }

        public void setExternalWrenchToZeroRecursive() {
            if (!this.isRoot()) {
                this.externalWrench.setToZero();
            }
            for (int childIndex = 0; childIndex < this.children.size(); ++childIndex) {
                this.children.get(childIndex).setExternalWrenchToZeroRecursive();
            }
        }

        private MovingReferenceFrame getBodyFixedFrame() {
            return this.rigidBody.getBodyFixedFrame();
        }

        public MovingReferenceFrame getFrameAfterJoint() {
            return this.getJoint().getFrameAfterJoint();
        }

        public JointReadOnly getJoint() {
            return this.rigidBody.getParentJoint();
        }

        public TwistReadOnly getBodyTwist() {
            return this.getBodyFixedFrame().getTwistOfFrame();
        }

        private boolean isRoot() {
            return this.parent == null;
        }
    }
}

