/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.util.zip.CRC32;
import org.ejml.data.DMatrixRMaj;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;

public class GenericCRC32
extends CRC32 {
    private final byte[] byteArray = new byte[8];
    private final ByteBuffer byteBuffer = ByteBuffer.wrap(this.byteArray);
    private final DoubleBuffer doubleBuffer = this.byteBuffer.asDoubleBuffer();
    private final LongBuffer longBuffer = this.byteBuffer.asLongBuffer();
    private final IntBuffer intBuffer = this.byteBuffer.asIntBuffer();

    public void update(double value) {
        this.doubleBuffer.put(0, value);
        this.update(this.byteArray);
    }

    public void updateInteger(int value) {
        this.intBuffer.put(0, value);
        this.update(this.byteArray, 0, 4);
    }

    public void update(long value) {
        this.longBuffer.put(value);
        this.update(this.byteArray);
    }

    public void update(Tuple2DReadOnly value) {
        this.update(value.getX());
        this.update(value.getY());
    }

    public void update(Tuple3DReadOnly value) {
        this.update(value.getX());
        this.update(value.getY());
        this.update(value.getZ());
    }

    public void update(Tuple4DReadOnly value) {
        this.update(value.getS());
        this.update(value.getX());
        this.update(value.getY());
        this.update(value.getZ());
    }

    public void update(boolean value) {
        this.update(value ? 1 : 0);
    }

    public void update(String value) {
        this.update(value.hashCode());
    }

    public void update(DMatrixRMaj value) {
        for (int i = 0; i < value.getNumElements(); ++i) {
            this.update(value.get(i));
        }
    }
}

