/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RevoluteJointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.geometry.GeometryTools;
import us.ihmc.robotics.kinematics.fourbar.FourBar;
import us.ihmc.robotics.kinematics.fourbar.FourBarAngle;
import us.ihmc.robotics.kinematics.fourbar.FourBarVertex;

public class FourBarKinematicLoopFunctionTools {
    private static final String A_NAME = "A";
    private static final String B_NAME = "B";
    private static final String C_NAME = "C";
    private static final String D_NAME = "D";

    public static double angleABC(Point2DReadOnly A, Point2DReadOnly B, Point2DReadOnly C) {
        double BAx = A.getX() - B.getX();
        double BAy = A.getY() - B.getY();
        double BCx = C.getX() - B.getX();
        double BCy = C.getY() - B.getY();
        return EuclidGeometryTools.angleFromFirstToSecondVector2D((double)BAx, (double)BAy, (double)BCx, (double)BCy);
    }

    public static int configureFourBarKinematics(RevoluteJointBasics[] joints, FourBarToJointConverter[] converters, FourBar fourBar, int masterJointIndex, double epsilon) {
        if (joints.length != 4) {
            throw new IllegalArgumentException("Expected 4 joints");
        }
        RevoluteJointBasics loopClosureJoint = null;
        RevoluteJointBasics masterJoint = joints[masterJointIndex];
        RigidBodyReadOnly ancestor = FourBarKinematicLoopFunctionTools.findCommonClosestAncestor((JointReadOnly)joints[0], (JointReadOnly)joints[1], (JointReadOnly)joints[2], (JointReadOnly)joints[3]);
        for (int i = 0; i < 4; ++i) {
            joints[i].setQ(0.0);
            joints[i].getFrameAfterJoint().update();
            if (!joints[i].isLoopClosure()) continue;
            loopClosureJoint = joints[i];
        }
        if (loopClosureJoint == null) {
            throw new IllegalArgumentException("Could not find the loop closure joint.");
        }
        RigidBodyTransform error = loopClosureJoint.getLoopClosureFrame().getTransformToDesiredFrame((ReferenceFrame)loopClosureJoint.getSuccessor().getParentJoint().getFrameAfterJoint());
        if (error.getTranslation().length() > epsilon) {
            throw new IllegalArgumentException("The four bar is not properly closed at zero-configuration, error:\n" + error);
        }
        ReferenceFrame fourBarLocalFrame = GeometryTools.constructReferenceFrameFromPointAndAxis("LocalFrame", (FramePoint3DReadOnly)new FramePoint3D((ReferenceFrame)masterJoint.getFrameBeforeJoint()), Axis3D.Z, masterJoint.getJointAxis());
        FramePoint3D tempFramePoint3D = new FramePoint3D();
        FrameVector3D[] axes = new FrameVector3D[]{new FrameVector3D(), new FrameVector3D(), new FrameVector3D(), new FrameVector3D()};
        FramePoint2D[] origins = new FramePoint2D[]{new FramePoint2D(), new FramePoint2D(), new FramePoint2D(), new FramePoint2D()};
        for (int i = 0; i < 4; ++i) {
            RevoluteJointBasics joint = joints[i];
            FrameVector3D axis = axes[i];
            axis.setIncludingFrame((FrameTuple3DReadOnly)joint.getJointAxis());
            axis.changeFrame(fourBarLocalFrame);
            tempFramePoint3D.setToZero((ReferenceFrame)joint.getFrameAfterJoint());
            tempFramePoint3D.changeFrame(fourBarLocalFrame);
            origins[i].setIncludingFrame((FrameTuple3DReadOnly)tempFramePoint3D);
        }
        int jointAIndex = -1;
        int jointBIndex = -1;
        for (int i = 0; i < 4; ++i) {
            if (joints[i].getPredecessor() != ancestor) continue;
            if (jointAIndex == -1) {
                jointAIndex = i;
                continue;
            }
            jointBIndex = i;
        }
        int jointCIndex = -1;
        int jointDIndex = -1;
        for (int i = 0; i < 4; ++i) {
            if (i == jointAIndex || i == jointBIndex) continue;
            if (joints[i].getPredecessor() == joints[jointAIndex].getSuccessor()) {
                jointDIndex = i;
                continue;
            }
            jointCIndex = i;
        }
        if (FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)origins[jointDIndex], (Point2DReadOnly)origins[jointAIndex], (Point2DReadOnly)origins[jointBIndex]) < 0.0) {
            int temp = jointAIndex;
            jointAIndex = jointBIndex;
            jointBIndex = temp;
            temp = jointDIndex;
            jointDIndex = jointCIndex;
            jointCIndex = temp;
        }
        RevoluteJointBasics jointA = joints[jointAIndex];
        RevoluteJointBasics jointB = joints[jointBIndex];
        RevoluteJointBasics jointC = joints[jointCIndex];
        RevoluteJointBasics jointD = joints[jointDIndex];
        FourBarKinematicLoopFunctionTools.checkKinematicLayout((RevoluteJointReadOnly)jointA, (RevoluteJointReadOnly)jointB, (RevoluteJointReadOnly)jointC, (RevoluteJointReadOnly)jointD);
        joints[0] = jointA;
        joints[1] = jointB;
        joints[2] = jointC;
        joints[3] = jointD;
        FramePoint2D originA = origins[jointAIndex];
        FramePoint2D originB = origins[jointBIndex];
        FramePoint2D originC = origins[jointCIndex];
        FramePoint2D originD = origins[jointDIndex];
        FrameVector3D axisA = axes[jointAIndex];
        FrameVector3D axisB = axes[jointBIndex];
        FrameVector3D axisC = axes[jointCIndex];
        FrameVector3D axisD = axes[jointDIndex];
        if (!EuclidFrameTools.areVector3DsParallel((FrameVector3DReadOnly)axisA, (FrameVector3DReadOnly)axisB, (double)epsilon)) {
            throw new IllegalArgumentException(String.format("The axes of the joint %s and %s are not parallel.", jointA.getName(), jointB.getName()));
        }
        if (!EuclidFrameTools.areVector3DsParallel((FrameVector3DReadOnly)axisA, (FrameVector3DReadOnly)axisC, (double)epsilon)) {
            throw new IllegalArgumentException(String.format("The axes of the joint %s and %s are not parallel.", jointA.getName(), jointC.getName()));
        }
        if (!EuclidFrameTools.areVector3DsParallel((FrameVector3DReadOnly)axisA, (FrameVector3DReadOnly)axisD, (double)epsilon)) {
            throw new IllegalArgumentException(String.format("The axes of the joint %s and %s are not parallel.", jointA.getName(), jointD.getName()));
        }
        converters[0].set(FourBarAngle.DAB, -Math.signum(axisA.getZ()), FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)originD, (Point2DReadOnly)originA, (Point2DReadOnly)originB));
        converters[1].set(FourBarAngle.ABC, Math.signum(axisB.getZ()), FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)originA, (Point2DReadOnly)originB, (Point2DReadOnly)originC));
        converters[2].set(FourBarAngle.BCD, Math.signum(axisC.getZ()), FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)originB, (Point2DReadOnly)originC, (Point2DReadOnly)originD));
        converters[3].set(FourBarAngle.CDA, -Math.signum(axisD.getZ()), FourBarKinematicLoopFunctionTools.angleABC((Point2DReadOnly)originC, (Point2DReadOnly)originD, (Point2DReadOnly)originA));
        fourBar.setup((Point2DReadOnly)originA, (Point2DReadOnly)originB, (Point2DReadOnly)originC, (Point2DReadOnly)originD);
        for (FourBarAngle fourBarAngle : FourBarAngle.values) {
            double upperLimit;
            double lowerLimit;
            int index = fourBarAngle.ordinal();
            FourBarVertex fourBarVertex = fourBar.getVertex(fourBarAngle);
            RevoluteJointBasics joint = joints[index];
            FourBarToJointConverter converter = converters[index];
            if (converter.getSign() > 0.0) {
                lowerLimit = converter.toJointAngle(fourBarVertex.getMinAngle());
                upperLimit = converter.toJointAngle(fourBarVertex.getMaxAngle());
            } else {
                lowerLimit = converter.toJointAngle(fourBarVertex.getMaxAngle());
                upperLimit = converter.toJointAngle(fourBarVertex.getMinAngle());
            }
            if (joint.getJointLimitLower() < lowerLimit) {
                LogTools.warn((String)"Correcting {} lower limit from {} to {}", (Object)joint.getName(), (Object)joint.getJointLimitLower(), (Object)lowerLimit);
                joint.setJointLimitLower(lowerLimit);
            }
            if (!(joint.getJointLimitUpper() > upperLimit)) continue;
            LogTools.warn((String)"Correcting {} upper limit from {} to {}", (Object)joint.getName(), (Object)joint.getJointLimitUpper(), (Object)upperLimit);
            joint.setJointLimitUpper(upperLimit);
        }
        for (int i = 0; i < 4; ++i) {
            if (joints[i] != masterJoint) continue;
            return i;
        }
        throw new IllegalStateException("Something went wrong: Could not retrieve the master joint.");
    }

    private static void checkKinematicLayout(RevoluteJointReadOnly jointA, RevoluteJointReadOnly jointB, RevoluteJointReadOnly jointC, RevoluteJointReadOnly jointD) {
        RigidBodyReadOnly ancestor = FourBarKinematicLoopFunctionTools.findCommonClosestAncestor((JointReadOnly)jointA, (JointReadOnly)jointB, (JointReadOnly)jointC, (JointReadOnly)jointD);
        if (jointA.getPredecessor() == ancestor) {
            if (jointB.getPredecessor() == ancestor) {
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointA, (JointReadOnly)jointD, A_NAME, D_NAME);
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointB, (JointReadOnly)jointC, B_NAME, C_NAME);
                FourBarKinematicLoopFunctionTools.checkCommonSuccessorLayout((JointReadOnly)jointC, (JointReadOnly)jointD, C_NAME, D_NAME);
                return;
            }
            if (jointD.getPredecessor() == ancestor) {
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointD, (JointReadOnly)jointC, D_NAME, C_NAME);
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointA, (JointReadOnly)jointB, A_NAME, B_NAME);
                FourBarKinematicLoopFunctionTools.checkCommonSuccessorLayout((JointReadOnly)jointB, (JointReadOnly)jointC, B_NAME, C_NAME);
                return;
            }
        } else if (jointC.getPredecessor() == ancestor) {
            if (jointB.getPredecessor() == ancestor) {
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointB, (JointReadOnly)jointA, B_NAME, A_NAME);
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointC, (JointReadOnly)jointD, C_NAME, D_NAME);
                FourBarKinematicLoopFunctionTools.checkCommonSuccessorLayout((JointReadOnly)jointA, (JointReadOnly)jointD, A_NAME, D_NAME);
                return;
            }
            if (jointD.getPredecessor() == ancestor) {
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointD, (JointReadOnly)jointA, D_NAME, A_NAME);
                FourBarKinematicLoopFunctionTools.checkParentChildLayout((JointReadOnly)jointC, (JointReadOnly)jointB, C_NAME, B_NAME);
                FourBarKinematicLoopFunctionTools.checkCommonSuccessorLayout((JointReadOnly)jointA, (JointReadOnly)jointB, A_NAME, B_NAME);
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Improper kinematics for four bar linkage. Could not find any consecutive pair of joints with the same predecessor.\n\tjoints [A=%s, B=%s, C=%s, D=%s]", jointA.getName(), jointB.getName(), jointC.getName(), jointD.getName()));
    }

    private static void checkParentChildLayout(JointReadOnly parentJoint, JointReadOnly childJoint, String parentJointFourBarName, String childJointFourBarName) {
        if (parentJoint.getSuccessor() != childJoint.getPredecessor()) {
            String messageFormat = "The joints %1$s & %2$s are expected to be connected:\n\tjoints [%1$s=%3$s, %2$s=%4$s]\n\tsuccessor %1$s==%5$s, predecessor %2$s=%6$s";
            throw new IllegalArgumentException(String.format(messageFormat, parentJointFourBarName, childJointFourBarName, parentJoint.getName(), childJoint.getName(), parentJoint.getSuccessor().getName(), childJoint.getPredecessor().getName()));
        }
    }

    private static void checkCommonSuccessorLayout(JointReadOnly joint1, JointReadOnly joint2, String joint1FourBarName, String joint2FourBarName) {
        if (joint1.getSuccessor() != joint1.getSuccessor()) {
            String messageFormat = "The joints %1$s & %2$s are expected to share the same successor:\n\tjoints [%1$s=%3$s, %2$s=%4$s]\\n\\tsuccessors [%1$s=%5$s, %2$s=%6$s]";
            throw new IllegalArgumentException(String.format(messageFormat, joint1FourBarName, joint2FourBarName, joint1.getName(), joint2.getName(), joint1.getSuccessor().getName(), joint2.getSuccessor().getName()));
        }
    }

    public static RigidBodyReadOnly findCommonClosestAncestor(JointReadOnly jointA, JointReadOnly jointB, JointReadOnly jointC, JointReadOnly jointD) {
        RigidBodyReadOnly ancestor = jointA.getPredecessor();
        if (!MultiBodySystemTools.isAncestor((RigidBodyReadOnly)jointB.getPredecessor(), (RigidBodyReadOnly)ancestor)) {
            ancestor = jointB.getPredecessor();
        }
        if (!MultiBodySystemTools.isAncestor((RigidBodyReadOnly)jointC.getPredecessor(), (RigidBodyReadOnly)ancestor)) {
            ancestor = jointC.getPredecessor();
        }
        if (!MultiBodySystemTools.isAncestor((RigidBodyReadOnly)jointD.getPredecessor(), (RigidBodyReadOnly)ancestor)) {
            ancestor = jointD.getPredecessor();
        }
        return ancestor;
    }

    static class FourBarToJointConverter {
        private FourBarAngle fourBarAngle;
        private double sign;
        private double interiorAngleAtZero;

        public void set(FourBarAngle fourBarAngle, double sign, double interiorAngleAtZero) {
            this.fourBarAngle = fourBarAngle;
            this.sign = sign;
            this.interiorAngleAtZero = interiorAngleAtZero;
        }

        public double toJointAngle(double interiorAngle) {
            return this.sign * (interiorAngle - this.interiorAngleAtZero);
        }

        public double toJointDerivative(double interiorAngularDerivative) {
            return this.sign * interiorAngularDerivative;
        }

        public double toFourBarInteriorAngle(double jointAngle) {
            return this.sign * jointAngle + this.interiorAngleAtZero;
        }

        public double toFourBarInteriorAngularDerivative(double jointDerivative) {
            return this.sign * jointDerivative;
        }

        public FourBarAngle getFourBarAngle() {
            return this.fourBarAngle;
        }

        public double getSign() {
            return this.sign;
        }

        public double getInteriorAngleAtZero() {
            return this.interiorAngleAtZero;
        }

        public String toString() {
            return "Converter for vertex: " + (Object)((Object)this.fourBarAngle) + ", sign= " + this.sign + ", int. angle at zero= " + this.interiorAngleAtZero;
        }
    }
}

